/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.context;

import java.io.Externalizable;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.inject.spi.Bean;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.context.AbstractContext;
import org.apache.webbeans.context.type.ContextTypes;
import org.apache.webbeans.util.WebBeansUtil;

public class SessionContext
extends AbstractContext
implements Serializable,
Externalizable {
    private static final long serialVersionUID = 1L;

    public SessionContext() {
        super(ContextTypes.SESSION);
    }

    public void setComponentInstanceMap() {
        this.componentInstanceMap = new ConcurrentHashMap();
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        WebBeansContext webBeansContext = WebBeansContext.currentInstance();
        this.type = (ContextTypes)((Object)in.readObject());
        this.scopeType = (Class)in.readObject();
        Map map = (Map)in.readObject();
        this.setComponentInstanceMap();
        Iterator it = map.keySet().iterator();
        Bean<?> contextual = null;
        while (it.hasNext()) {
            String id = (String)it.next();
            if (id != null) {
                contextual = webBeansContext.getBeanManagerImpl().getPassivationCapableBean(id);
            }
            if (contextual == null) continue;
            this.componentInstanceMap.put(contextual, map.get(id));
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject((Object)this.type);
        out.writeObject(this.scopeType);
        Iterator it = this.componentInstanceMap.keySet().iterator();
        HashMap map = new HashMap();
        while (it.hasNext()) {
            Contextual contextual = (Contextual)it.next();
            String id = WebBeansUtil.isPassivationCapable(contextual);
            if (id == null) {
                throw new NotSerializableException("cannot serialize " + contextual.toString());
            }
            map.put(id, this.componentInstanceMap.get(contextual));
        }
        out.writeObject(map);
    }
}

