/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.swizzle.stream;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.codehaus.swizzle.stream.ScanBuffer;
import org.codehaus.swizzle.stream.StreamTokenHandler;

public class FixedTokenListReplacementInputStream
extends FilterInputStream {
    private final StreamTokenHandler handler;
    private InputStream value;
    private final ScanBuffer[] tokenBuffers;
    private final ScanBuffer mainBuffer;
    private StreamReadingStrategy strategy;
    private final StreamReadingStrategy flushingValue = new StreamReadingStrategy(){

        public int _read() throws IOException {
            int i = FixedTokenListReplacementInputStream.this.value.read();
            if (i == -1) {
                FixedTokenListReplacementInputStream.this.strategy = FixedTokenListReplacementInputStream.this.lookingForToken;
                i = FixedTokenListReplacementInputStream.this.read();
            }
            return i;
        }
    };
    private final StreamReadingStrategy flushingMainBuffer = new StreamReadingStrategy(){

        public int _read() throws IOException {
            int buffer = FixedTokenListReplacementInputStream.this.mainBuffer.append(-1);
            if (buffer != -1) {
                return buffer;
            }
            if (FixedTokenListReplacementInputStream.this.mainBuffer.hasData()) {
                return this._read();
            }
            FixedTokenListReplacementInputStream.this.strategy = FixedTokenListReplacementInputStream.this.flushingValue;
            return FixedTokenListReplacementInputStream.this.read();
        }
    };
    private final StreamReadingStrategy lookingForToken = new StreamReadingStrategy(){

        public int _read() throws IOException {
            int i;
            int stream = FixedTokenListReplacementInputStream.this.superRead();
            int buffer = FixedTokenListReplacementInputStream.this.mainBuffer.append(stream);
            for (i = 0; i < FixedTokenListReplacementInputStream.this.tokenBuffers.length; ++i) {
                ScanBuffer tokenBuffer = FixedTokenListReplacementInputStream.this.tokenBuffers[i];
                tokenBuffer.append(stream);
                if (!tokenBuffer.match()) continue;
                FixedTokenListReplacementInputStream.this.clearAllBuffers();
                String token = tokenBuffer.getScanString();
                FixedTokenListReplacementInputStream.this.mainBuffer.clear(token.length());
                FixedTokenListReplacementInputStream.this.value = FixedTokenListReplacementInputStream.this.handler.processToken(token);
                if (FixedTokenListReplacementInputStream.this.mainBuffer.hasData()) {
                    FixedTokenListReplacementInputStream.this.strategy = FixedTokenListReplacementInputStream.this.flushingMainBuffer;
                } else {
                    FixedTokenListReplacementInputStream.this.strategy = FixedTokenListReplacementInputStream.this.flushingValue;
                }
                return buffer != -1 ? buffer : FixedTokenListReplacementInputStream.this.read();
            }
            i = buffer == -1 && FixedTokenListReplacementInputStream.this.mainBuffer.hasData() ? this._read() : buffer;
            return i;
        }
    };

    public FixedTokenListReplacementInputStream(InputStream in, List tokens, StreamTokenHandler handler) {
        this(in, tokens, handler, true);
    }

    public FixedTokenListReplacementInputStream(InputStream in, List tokens, StreamTokenHandler handler, boolean caseSensitive) {
        super(in);
        int largestBuffer = 0;
        this.tokenBuffers = new ScanBuffer[tokens.size()];
        for (int i = 0; i < tokens.size(); ++i) {
            ScanBuffer buffer;
            String token = (String)tokens.get(i);
            this.tokenBuffers[i] = buffer = new ScanBuffer(token, caseSensitive);
            largestBuffer = buffer.size() > largestBuffer ? buffer.size() : largestBuffer;
        }
        this.mainBuffer = new ScanBuffer(largestBuffer);
        this.handler = handler;
        this.strategy = this.lookingForToken;
    }

    public int read() throws IOException {
        return this.strategy._read();
    }

    private void clearAllBuffers() {
        for (int i = 0; i < this.tokenBuffers.length; ++i) {
            ScanBuffer tokenBuffer = this.tokenBuffers[i];
            tokenBuffer.flush();
        }
    }

    private int superRead() throws IOException {
        return super.read();
    }

    static interface StreamReadingStrategy {
        public int _read() throws IOException;
    }
}

