/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.ejbd;

import java.net.URI;
import java.util.Properties;
import javax.ejb.EJBHome;
import javax.ejb.EJBMetaData;
import javax.ejb.EJBObject;
import javax.ejb.Handle;
import javax.ejb.HomeHandle;
import org.apache.openejb.BeanContext;
import org.apache.openejb.InterfaceType;
import org.apache.openejb.ProxyInfo;
import org.apache.openejb.client.ClientMetaData;
import org.apache.openejb.client.EJBHomeHandle;
import org.apache.openejb.client.EJBHomeHandler;
import org.apache.openejb.client.EJBMetaDataImpl;
import org.apache.openejb.client.EJBObjectHandle;
import org.apache.openejb.client.EJBObjectHandler;
import org.apache.openejb.client.JNDIContext;
import org.apache.openejb.client.ServerMetaData;
import org.apache.openejb.server.ejbd.CallContext;
import org.apache.openejb.server.ejbd.EjbDaemon;
import org.apache.openejb.spi.ApplicationServer;

class ClientObjectFactory
implements ApplicationServer {
    public static final ThreadLocal<ServerMetaData> serverMetaData = new ThreadLocal();
    protected ServerMetaData defaultServerMetaData;

    public ClientObjectFactory(EjbDaemon daemon, Properties props) {
        String uriString = "foo://127.0.0.1:4201";
        try {
            uriString = props.getProperty("openejb.ejbd.uri", uriString);
            this.defaultServerMetaData = new ServerMetaData(new URI[]{new URI(uriString)});
        }
        catch (Exception e) {
            EjbDaemon.logger.error("Failed to read 'openejb.ejbd.uri': " + uriString, (Throwable)e);
        }
    }

    public EJBMetaData getEJBMetaData(ProxyInfo info) {
        CallContext call = CallContext.getCallContext();
        BeanContext beanContext = info.getBeanContext();
        int idCode = -1;
        return this.buildEjbMetaData(info, beanContext, -1);
    }

    public Handle getHandle(ProxyInfo info) {
        CallContext call = CallContext.getCallContext();
        BeanContext beanContext = info.getBeanContext();
        int idCode = -1;
        Object securityIdentity = null;
        try {
            securityIdentity = call.getEJBRequest().getClientIdentity();
        }
        catch (Exception e) {
            // empty catch block
        }
        ClientMetaData cMetaData = new ClientMetaData(securityIdentity);
        EJBMetaDataImpl eMetaData = this.buildEjbMetaData(info, beanContext, -1);
        Object primKey = info.getPrimaryKey();
        EJBObjectHandler handler = EJBObjectHandler.createEJBObjectHandler((EJBMetaDataImpl)eMetaData, (ServerMetaData)this.getServerMetaData(), (ClientMetaData)cMetaData, (Object)primKey, null);
        return new EJBObjectHandle(handler.createEJBObjectProxy());
    }

    private ServerMetaData getServerMetaData() {
        ServerMetaData serverMetaData = ClientObjectFactory.serverMetaData.get();
        if (serverMetaData == null) {
            serverMetaData = this.defaultServerMetaData;
        }
        return serverMetaData;
    }

    public HomeHandle getHomeHandle(ProxyInfo info) {
        CallContext call = CallContext.getCallContext();
        BeanContext beanContext = info.getBeanContext();
        int idCode = -1;
        Object securityIdentity = null;
        try {
            securityIdentity = call.getEJBRequest().getClientIdentity();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ClientMetaData cMetaData = new ClientMetaData(securityIdentity);
        EJBMetaDataImpl eMetaData = this.buildEjbMetaData(info, beanContext, -1);
        EJBHomeHandler hanlder = EJBHomeHandler.createEJBHomeHandler((EJBMetaDataImpl)eMetaData, (ServerMetaData)this.getServerMetaData(), (ClientMetaData)cMetaData, (JNDIContext.AuthenticationInfo)call.get(JNDIContext.AuthenticationInfo.class));
        return new EJBHomeHandle(hanlder.createEJBHomeProxy());
    }

    public EJBObject getEJBObject(ProxyInfo info) {
        CallContext call = CallContext.getCallContext();
        BeanContext beanContext = info.getBeanContext();
        int idCode = -1;
        Object securityIdentity = null;
        try {
            securityIdentity = call.getEJBRequest().getClientIdentity();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ClientMetaData cMetaData = new ClientMetaData(securityIdentity);
        EJBMetaDataImpl eMetaData = this.buildEjbMetaData(info, beanContext, -1);
        Object primKey = info.getPrimaryKey();
        EJBObjectHandler hanlder = EJBObjectHandler.createEJBObjectHandler((EJBMetaDataImpl)eMetaData, (ServerMetaData)this.getServerMetaData(), (ClientMetaData)cMetaData, (Object)primKey, null);
        return (EJBObject)hanlder.createEJBObjectProxy();
    }

    public Object getBusinessObject(ProxyInfo info) {
        CallContext call = CallContext.getCallContext();
        BeanContext beanContext = info.getBeanContext();
        int idCode = -1;
        Object securityIdentity = null;
        try {
            securityIdentity = call.getEJBRequest().getClientIdentity();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ClientMetaData cMetaData = new ClientMetaData(securityIdentity);
        EJBMetaDataImpl eMetaData = new EJBMetaDataImpl(null, null, beanContext.getPrimaryKeyClass(), beanContext.getComponentType().toString(), beanContext.getDeploymentID().toString(), -1, ClientObjectFactory.convert(info.getInterfaceType()), info.getInterfaces(), beanContext.getAsynchronousMethodSignatures());
        eMetaData.loadProperties(beanContext.getProperties());
        Object primKey = info.getPrimaryKey();
        EJBObjectHandler hanlder = EJBObjectHandler.createEJBObjectHandler((EJBMetaDataImpl)eMetaData, (ServerMetaData)this.getServerMetaData(), (ClientMetaData)cMetaData, (Object)primKey, null);
        return hanlder.createEJBObjectProxy();
    }

    public static org.apache.openejb.client.InterfaceType convert(InterfaceType type) {
        switch (type) {
            case EJB_HOME: {
                return org.apache.openejb.client.InterfaceType.EJB_HOME;
            }
            case EJB_OBJECT: {
                return org.apache.openejb.client.InterfaceType.EJB_OBJECT;
            }
            case EJB_LOCAL_HOME: {
                return org.apache.openejb.client.InterfaceType.EJB_LOCAL_HOME;
            }
            case EJB_LOCAL: {
                return org.apache.openejb.client.InterfaceType.EJB_LOCAL;
            }
            case BUSINESS_LOCAL: {
                return org.apache.openejb.client.InterfaceType.BUSINESS_LOCAL;
            }
            case BUSINESS_LOCAL_HOME: {
                return org.apache.openejb.client.InterfaceType.BUSINESS_LOCAL_HOME;
            }
            case BUSINESS_REMOTE: {
                return org.apache.openejb.client.InterfaceType.BUSINESS_REMOTE;
            }
            case BUSINESS_REMOTE_HOME: {
                return org.apache.openejb.client.InterfaceType.BUSINESS_REMOTE_HOME;
            }
        }
        return null;
    }

    public EJBHome getEJBHome(ProxyInfo info) {
        CallContext call = CallContext.getCallContext();
        BeanContext beanContext = info.getBeanContext();
        int idCode = -1;
        Object securityIdentity = null;
        try {
            securityIdentity = call.getEJBRequest().getClientIdentity();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ClientMetaData cMetaData = new ClientMetaData(securityIdentity);
        EJBMetaDataImpl eMetaData = this.buildEjbMetaData(info, beanContext, -1);
        EJBHomeHandler hanlder = EJBHomeHandler.createEJBHomeHandler((EJBMetaDataImpl)eMetaData, (ServerMetaData)this.getServerMetaData(), (ClientMetaData)cMetaData, null);
        return hanlder.createEJBHomeProxy();
    }

    private EJBMetaDataImpl buildEjbMetaData(ProxyInfo info, BeanContext beanContext, int idCode) {
        EJBMetaDataImpl eMetaData = new EJBMetaDataImpl(beanContext.getHomeInterface(), beanContext.getRemoteInterface(), beanContext.getPrimaryKeyClass(), beanContext.getComponentType().toString(), beanContext.getDeploymentID().toString(), idCode, ClientObjectFactory.convert(info.getInterfaceType()), info.getInterfaces(), beanContext.getAsynchronousMethodSignatures());
        eMetaData.loadProperties(beanContext.getProperties());
        return eMetaData;
    }
}

