/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.ejbd;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.openejb.ApplicationException;
import org.apache.openejb.BeanContext;
import org.apache.openejb.InvalidateReferenceException;
import org.apache.openejb.ProxyInfo;
import org.apache.openejb.RpcContainer;
import org.apache.openejb.SystemException;
import org.apache.openejb.client.ClusterableRequest;
import org.apache.openejb.client.ClusterableResponse;
import org.apache.openejb.client.EJBHomeProxyHandle;
import org.apache.openejb.client.EJBObjectProxyHandle;
import org.apache.openejb.client.EJBRequest;
import org.apache.openejb.client.EJBResponse;
import org.apache.openejb.client.ThrowableArtifact;
import org.apache.openejb.core.ThreadContext;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.server.ejbd.BasicClusterableRequestHandler;
import org.apache.openejb.server.ejbd.CallContext;
import org.apache.openejb.server.ejbd.ClusterableRequestHandler;
import org.apache.openejb.server.ejbd.EjbDaemon;
import org.apache.openejb.server.ejbd.ServerSideResolver;
import org.apache.openejb.spi.SecurityService;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

class EjbRequestHandler {
    public static final ServerSideResolver SERVER_SIDE_RESOLVER = new ServerSideResolver();
    private static final Logger logger = Logger.getInstance((LogCategory)LogCategory.OPENEJB_SERVER_REMOTE.createChild("ejb"), (String)"org.apache.openejb.server.util.resources");
    private final EjbDaemon daemon;
    private final ClusterableRequestHandler clusterableRequestHandler;
    private Map<String, AtomicBoolean> asynchronousInvocationCancelMap = new ConcurrentHashMap<String, AtomicBoolean>();

    EjbRequestHandler(EjbDaemon daemon) {
        this.daemon = daemon;
        this.clusterableRequestHandler = this.newClusterableRequestHandler();
    }

    protected BasicClusterableRequestHandler newClusterableRequestHandler() {
        return new BasicClusterableRequestHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processRequest(ObjectInputStream in, ObjectOutputStream out) {
        EJBHomeProxyHandle.resolver.set(SERVER_SIDE_RESOLVER);
        EJBObjectProxyHandle.resolver.set(SERVER_SIDE_RESOLVER);
        EJBRequest req = new EJBRequest();
        EJBResponse res = new EJBResponse();
        try {
            req.readExternal((ObjectInput)in);
        }
        catch (Throwable t) {
            this.replyWithFatalError(out, t, "Error caught during request processing");
            return;
        }
        CallContext call = null;
        BeanContext di = null;
        try {
            di = this.daemon.getDeployment(req);
        }
        catch (RemoteException e) {
            this.replyWithFatalError(out, e, "No such deployment");
            return;
        }
        catch (Throwable t) {
            this.replyWithFatalError(out, t, "Unkown error occured while retrieving deployment");
            return;
        }
        ClassLoader classLoader = di.getBeanClass().getClassLoader();
        Thread.currentThread().setContextClassLoader(classLoader);
        try {
            req.getBody().readExternal((ObjectInput)in);
        }
        catch (Throwable t) {
            this.replyWithFatalError(out, t, "Error caught during request processing");
            return;
        }
        try {
            call = CallContext.getCallContext();
            call.setEJBRequest(req);
            call.setBeanContext(di);
        }
        catch (Throwable t) {
            this.replyWithFatalError(out, t, "Unable to set the thread context for this request");
            return;
        }
        SecurityService securityService = (SecurityService)SystemInstance.get().getComponent(SecurityService.class);
        try {
            Object clientIdentity = req.getClientIdentity();
            if (clientIdentity != null) {
                securityService.associate(clientIdentity);
            }
        }
        catch (Throwable t) {
            this.replyWithFatalError(out, t, "Security system failed to associate thread with the thread");
            return;
        }
        try {
            switch (req.getRequestMethod()) {
                case 23: {
                    this.doEjbObject_BUSINESS_METHOD(req, res);
                    this.updateServer(req, res);
                    return;
                }
                case 10: {
                    this.doEjbHome_CREATE(req, res);
                    this.updateServer(req, res);
                    return;
                }
                case 24: {
                    this.doEjbHome_METHOD(req, res);
                    this.updateServer(req, res);
                    return;
                }
                case 9: {
                    this.doEjbHome_FIND(req, res);
                    this.updateServer(req, res);
                    return;
                }
                case 14: {
                    this.doEjbObject_GET_EJB_HOME(req, res);
                    this.updateServer(req, res);
                    return;
                }
                case 15: {
                    this.doEjbObject_GET_HANDLE(req, res);
                    this.updateServer(req, res);
                    return;
                }
                case 16: {
                    this.doEjbObject_GET_PRIMARY_KEY(req, res);
                    this.updateServer(req, res);
                    return;
                }
                case 17: {
                    this.doEjbObject_IS_IDENTICAL(req, res);
                    this.updateServer(req, res);
                    return;
                }
                case 18: {
                    this.doEjbObject_REMOVE(req, res);
                    return;
                }
                case 1: {
                    this.doEjbHome_GET_EJB_META_DATA(req, res);
                    this.updateServer(req, res);
                    return;
                }
                case 2: {
                    this.doEjbHome_GET_HOME_HANDLE(req, res);
                    this.updateServer(req, res);
                    return;
                }
                case 3: {
                    this.doEjbHome_REMOVE_BY_HANDLE(req, res);
                    return;
                }
                case 4: {
                    this.doEjbHome_REMOVE_BY_PKEY(req, res);
                    return;
                }
                case 35: {
                    this.doFUTURE_CANCEL_METHOD(req, res);
                    return;
                }
            }
            return;
        }
        catch (InvalidateReferenceException e) {
            res.setResponse(10, (Object)new ThrowableArtifact(e.getRootCause()));
            return;
        }
        catch (ApplicationException e) {
            res.setResponse(9, (Object)new ThrowableArtifact(e.getRootCause()));
            return;
        }
        catch (SystemException e) {
            res.setResponse(11, (Object)new ThrowableArtifact(e.getRootCause()));
            logger.fatal(req + ": OpenEJB encountered an unknown system error in container: ", (Throwable)e);
            return;
        }
        catch (Throwable t) {
            this.replyWithFatalError(out, t, "Unknown error in container");
            return;
        }
        finally {
            if (logger.isDebugEnabled()) {
                try {
                    logger.debug("EJB REQUEST: " + req + " -- RESPONSE: " + res);
                }
                catch (Exception justInCase) {}
            }
            try {
                res.writeExternal((ObjectOutput)out);
            }
            catch (IOException ie) {
                logger.fatal("Couldn't write EjbResponse to output stream", (Throwable)ie);
            }
            securityService.disassociate();
            call.reset();
            EJBHomeProxyHandle.resolver.set(null);
            EJBObjectProxyHandle.resolver.set(null);
        }
    }

    protected void updateServer(EJBRequest req, EJBResponse res) {
        CallContext callContext = CallContext.getCallContext();
        BeanContext beanContext = callContext.getBeanContext();
        this.clusterableRequestHandler.updateServer(beanContext, (ClusterableRequest)req, (ClusterableResponse)res);
    }

    protected void doFUTURE_CANCEL_METHOD(EJBRequest req, EJBResponse res) throws Exception {
        AtomicBoolean invocationCancelTag = this.asynchronousInvocationCancelMap.get(req.getBody().getRequestId());
        if (invocationCancelTag != null) {
            invocationCancelTag.set((Boolean)req.getBody().getMethodParameters()[0]);
            res.setResponse(4, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doEjbObject_BUSINESS_METHOD(EJBRequest req, EJBResponse res) throws Exception {
        CallContext call = CallContext.getCallContext();
        BeanContext beanContext = call.getBeanContext();
        boolean asynchronous = beanContext.isAsynchronous(req.getMethodInstance());
        try {
            RpcContainer c;
            Object result;
            if (asynchronous) {
                AtomicBoolean invocationCancelTag = new AtomicBoolean(false);
                ThreadContext.initAsynchronousCancelled((AtomicBoolean)invocationCancelTag);
                this.asynchronousInvocationCancelMap.put(req.getBody().getRequestId(), invocationCancelTag);
            }
            if ((result = (c = (RpcContainer)call.getBeanContext().getContainer()).invoke((Object)req.getDeploymentId(), req.getInterfaceClass(), req.getMethodInstance(), req.getMethodParameters(), req.getPrimaryKey())) != null && asynchronous) {
                result = ((Future)result).get();
            }
            res.setResponse(4, result);
        }
        finally {
            if (asynchronous) {
                ThreadContext.removeAsynchronousCancelled();
                this.asynchronousInvocationCancelMap.remove(req.getBody().getRequestId());
            }
        }
    }

    protected void doEjbHome_METHOD(EJBRequest req, EJBResponse res) throws Exception {
        CallContext call = CallContext.getCallContext();
        RpcContainer c = (RpcContainer)call.getBeanContext().getContainer();
        Object result = c.invoke((Object)req.getDeploymentId(), req.getInterfaceClass(), req.getMethodInstance(), req.getMethodParameters(), req.getPrimaryKey());
        res.setResponse(4, result);
    }

    protected void doEjbHome_CREATE(EJBRequest req, EJBResponse res) throws Exception {
        CallContext call = CallContext.getCallContext();
        RpcContainer c = (RpcContainer)call.getBeanContext().getContainer();
        Object result = c.invoke((Object)req.getDeploymentId(), req.getInterfaceClass(), req.getMethodInstance(), req.getMethodParameters(), req.getPrimaryKey());
        if (result instanceof ProxyInfo) {
            ProxyInfo info = (ProxyInfo)result;
            res.setResponse(4, info.getPrimaryKey());
        } else {
            result = new RemoteException("The bean is not EJB compliant.  The bean should be created or and exception should be thrown.");
            logger.error(req + "The bean is not EJB compliant.  The bean should be created or and exception should be thrown.");
            res.setResponse(10, (Object)new ThrowableArtifact((Throwable)result));
        }
    }

    protected void doEjbHome_FIND(EJBRequest req, EJBResponse res) throws Exception {
        CallContext call = CallContext.getCallContext();
        RpcContainer c = (RpcContainer)call.getBeanContext().getContainer();
        Object result = c.invoke((Object)req.getDeploymentId(), req.getInterfaceClass(), req.getMethodInstance(), req.getMethodParameters(), req.getPrimaryKey());
        if (result instanceof Collection) {
            Object[] primaryKeys = ((Collection)result).toArray();
            for (int i = 0; i < primaryKeys.length; ++i) {
                ProxyInfo proxyInfo = (ProxyInfo)primaryKeys[i];
                primaryKeys[i] = proxyInfo == null ? null : proxyInfo.getPrimaryKey();
            }
            res.setResponse(7, (Object)primaryKeys);
        } else if (result instanceof Enumeration) {
            Enumeration resultAsEnum = (Enumeration)result;
            ArrayList<Object> listOfPKs = new ArrayList<Object>();
            while (resultAsEnum.hasMoreElements()) {
                ProxyInfo proxyInfo = (ProxyInfo)resultAsEnum.nextElement();
                if (proxyInfo == null) {
                    listOfPKs.add(null);
                    continue;
                }
                listOfPKs.add(proxyInfo.getPrimaryKey());
            }
            res.setResponse(20, (Object)listOfPKs.toArray(new Object[listOfPKs.size()]));
        } else if (result instanceof ProxyInfo) {
            ProxyInfo proxyInfo = (ProxyInfo)result;
            result = proxyInfo.getPrimaryKey();
            res.setResponse(6, result);
        } else if (result == null) {
            res.setResponse(6, null);
        } else {
            String message = "The bean is not EJB compliant. The finder method [" + req.getMethodInstance().getName() + "] is declared " + "to return neither Collection nor the Remote Interface, " + "but [" + result.getClass().getName() + "]";
            result = new RemoteException(message);
            logger.error(req + " " + message);
            res.setResponse(10, result);
        }
    }

    protected void doEjbObject_GET_EJB_HOME(EJBRequest req, EJBResponse res) throws Exception {
        this.checkMethodAuthorization(req, res);
    }

    protected void doEjbObject_GET_HANDLE(EJBRequest req, EJBResponse res) throws Exception {
        this.checkMethodAuthorization(req, res);
    }

    protected void doEjbObject_GET_PRIMARY_KEY(EJBRequest req, EJBResponse res) throws Exception {
        this.checkMethodAuthorization(req, res);
    }

    protected void doEjbObject_IS_IDENTICAL(EJBRequest req, EJBResponse res) throws Exception {
        this.checkMethodAuthorization(req, res);
    }

    protected void doEjbObject_REMOVE(EJBRequest req, EJBResponse res) throws Exception {
        CallContext call = CallContext.getCallContext();
        RpcContainer c = (RpcContainer)call.getBeanContext().getContainer();
        Object result = c.invoke((Object)req.getDeploymentId(), req.getInterfaceClass(), req.getMethodInstance(), req.getMethodParameters(), req.getPrimaryKey());
        res.setResponse(4, null);
    }

    protected void doEjbHome_GET_EJB_META_DATA(EJBRequest req, EJBResponse res) throws Exception {
        this.checkMethodAuthorization(req, res);
    }

    protected void doEjbHome_GET_HOME_HANDLE(EJBRequest req, EJBResponse res) throws Exception {
        this.checkMethodAuthorization(req, res);
    }

    protected void doEjbHome_REMOVE_BY_HANDLE(EJBRequest req, EJBResponse res) throws Exception {
        CallContext call = CallContext.getCallContext();
        RpcContainer c = (RpcContainer)call.getBeanContext().getContainer();
        Object result = c.invoke((Object)req.getDeploymentId(), req.getInterfaceClass(), req.getMethodInstance(), req.getMethodParameters(), req.getPrimaryKey());
        res.setResponse(4, null);
    }

    protected void doEjbHome_REMOVE_BY_PKEY(EJBRequest req, EJBResponse res) throws Exception {
        CallContext call = CallContext.getCallContext();
        RpcContainer c = (RpcContainer)call.getBeanContext().getContainer();
        Object result = c.invoke((Object)req.getDeploymentId(), req.getInterfaceClass(), req.getMethodInstance(), req.getMethodParameters(), req.getPrimaryKey());
        res.setResponse(4, null);
    }

    protected void checkMethodAuthorization(EJBRequest req, EJBResponse res) throws Exception {
        res.setResponse(4, null);
    }

    private void replyWithFatalError(ObjectOutputStream out, Throwable error, String message) {
        logger.fatal(message, error);
        RemoteException re = new RemoteException("The server has encountered a fatal error: " + message + " " + error, error);
        EJBResponse res = new EJBResponse();
        res.setResponse(11, (Object)new ThrowableArtifact((Throwable)re));
        try {
            res.writeExternal((ObjectOutput)out);
        }
        catch (IOException ie) {
            logger.error("Failed to write to EJBResponse", (Throwable)ie);
        }
    }
}

