/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.client;

import java.lang.reflect.Constructor;
import java.net.ConnectException;
import java.net.URI;
import java.net.URISyntaxException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.mail.Session;
import javax.naming.AuthenticationException;
import javax.naming.Binding;
import javax.naming.CompoundName;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.Reference;
import javax.naming.ServiceUnavailableException;
import javax.naming.spi.InitialContextFactory;
import javax.naming.spi.NamingManager;
import javax.sql.DataSource;
import org.apache.openejb.client.AuthenticationRequest;
import org.apache.openejb.client.AuthenticationResponse;
import org.apache.openejb.client.Client;
import org.apache.openejb.client.ClientDataSource;
import org.apache.openejb.client.ClientInstance;
import org.apache.openejb.client.ClientMetaData;
import org.apache.openejb.client.ClientRuntimeException;
import org.apache.openejb.client.DataSourceMetaData;
import org.apache.openejb.client.EJBHomeHandler;
import org.apache.openejb.client.EJBHomeProxy;
import org.apache.openejb.client.EJBMetaDataImpl;
import org.apache.openejb.client.EJBObjectHandler;
import org.apache.openejb.client.JNDIRequest;
import org.apache.openejb.client.JNDIResponse;
import org.apache.openejb.client.NameClassPairEnumeration;
import org.apache.openejb.client.RequestMethodCode;
import org.apache.openejb.client.ServerMetaData;
import org.apache.openejb.client.ThrowableArtifact;
import org.apache.openejb.client.WsMetaData;
import org.apache.openejb.client.event.RemoteInitialContextCreated;
import org.omg.CORBA.ORB;

public class JNDIContext
implements InitialContextFactory,
Context {
    public static final String DEFAULT_PROVIDER_URL = "ejbd://localhost:4201";
    private String tail = "/";
    private ServerMetaData server;
    private ClientMetaData client;
    private Hashtable env;
    private String moduleId;
    private ClientInstance clientIdentity;

    public JNDIContext() {
    }

    public JNDIContext(JNDIContext that) {
        this.tail = that.tail;
        this.server = that.server;
        this.client = that.client;
        this.moduleId = that.moduleId;
        this.env = (Hashtable)that.env.clone();
        this.clientIdentity = that.clientIdentity;
    }

    private JNDIResponse request(JNDIRequest req) throws Exception {
        req.setServerHash(this.server.buildHash());
        JNDIResponse response = new JNDIResponse();
        Client.request(req, response, this.server);
        if (null != response.getServer()) {
            this.server.merge(response.getServer());
        }
        return response;
    }

    protected AuthenticationResponse requestAuthorization(AuthenticationRequest req) throws RemoteException {
        return (AuthenticationResponse)Client.request(req, new AuthenticationResponse(), this.server);
    }

    public Context getInitialContext(Hashtable environment) throws NamingException {
        URI location;
        if (environment == null) {
            throw new NamingException("Invalid argument, hashtable cannot be null.");
        }
        this.env = (Hashtable)environment.clone();
        String userID = (String)this.env.get("java.naming.security.principal");
        String psswrd = (String)this.env.get("java.naming.security.credentials");
        String providerUrl = (String)this.env.get("java.naming.provider.url");
        this.moduleId = (String)this.env.get("openejb.client.moduleId");
        try {
            providerUrl = this.addMissingParts(providerUrl);
            location = new URI(providerUrl);
        }
        catch (URISyntaxException e) {
            throw (ConfigurationException)new ConfigurationException("Property value for java.naming.provider.url invalid: " + providerUrl + " - " + e.getMessage()).initCause(e);
        }
        this.server = new ServerMetaData(location);
        Client.Context context = Client.getContext(this.server);
        context.getProperties().putAll((Map<?, ?>)environment);
        String strategy = context.getOptions().get("openejb.client.connection.strategy", "default");
        context.getClusterMetaData().setConnectionStrategy(strategy);
        Client.fireEvent(new RemoteInitialContextCreated(location));
        if (userID != null) {
            this.authenticate(userID, psswrd);
        } else {
            this.client = new ClientMetaData();
        }
        return this;
    }

    String addMissingParts(String providerUrl) throws URISyntaxException {
        if (providerUrl == null || providerUrl.length() == 0) {
            providerUrl = DEFAULT_PROVIDER_URL;
        } else {
            int colonIndex = providerUrl.indexOf(":");
            int slashesIndex = providerUrl.indexOf("//");
            if (colonIndex == -1 && slashesIndex == -1) {
                providerUrl = "ejbd://" + providerUrl + ":4201";
            } else if (colonIndex == -1) {
                URI providerUri = new URI(providerUrl);
                String scheme = providerUri.getScheme();
                if (!scheme.equals("http") && !scheme.equals("https")) {
                    providerUrl = providerUrl + ":4201";
                }
            } else if (slashesIndex == -1) {
                providerUrl = "ejbd://" + providerUrl;
            }
        }
        return providerUrl;
    }

    public void authenticate(String userID, String psswrd) throws AuthenticationException {
        String realmName = (String)this.env.get("openejb.authentication.realmName");
        AuthenticationRequest req = new AuthenticationRequest(realmName, userID, psswrd);
        AuthenticationResponse res = null;
        try {
            res = this.requestAuthorization(req);
        }
        catch (RemoteException e) {
            throw new AuthenticationException(e.getLocalizedMessage());
        }
        switch (res.getResponseCode()) {
            case 1: {
                this.client = res.getIdentity();
                break;
            }
            case 2: {
                this.client = res.getIdentity();
                this.server = res.getServer();
                break;
            }
            case 3: {
                throw (AuthenticationException)new AuthenticationException("This principle is not authorized.").initCause(res.getDeniedCause());
            }
        }
    }

    public EJBHomeProxy createEJBHomeProxy(EJBMetaDataImpl ejbData) {
        EJBHomeHandler handler = EJBHomeHandler.createEJBHomeHandler(ejbData, this.server, this.client);
        EJBHomeProxy proxy = handler.createEJBHomeProxy();
        handler.ejb.ejbHomeProxy = proxy;
        return proxy;
    }

    private Object createBusinessObject(Object result) {
        EJBMetaDataImpl ejb = (EJBMetaDataImpl)result;
        Object primaryKey = ejb.getPrimaryKey();
        EJBObjectHandler handler = EJBObjectHandler.createEJBObjectHandler(ejb, this.server, this.client, primaryKey);
        return handler.createEJBObjectProxy();
    }

    @Override
    public Object lookup(String name) throws NamingException {
        if (name == null) {
            throw new InvalidNameException("The name cannot be null");
        }
        if (name.equals("")) {
            return new JNDIContext(this);
        }
        if (name.startsWith("java:")) {
            name = name.replaceFirst("^java:", "");
        } else if (!name.startsWith("/")) {
            name = this.tail + name;
        }
        String prop = name.replaceFirst("comp/env/", "");
        String value = System.getProperty(prop);
        if (value != null) {
            return this.parseEntry(prop, value);
        }
        if (name.equals("comp/ORB")) {
            return this.getDefaultOrb();
        }
        JNDIRequest req = new JNDIRequest();
        req.setRequestMethod(RequestMethodCode.JNDI_LOOKUP);
        req.setRequestString(name);
        req.setModuleId(this.moduleId);
        JNDIResponse res = null;
        try {
            res = this.request(req);
        }
        catch (Exception e) {
            if (e instanceof RemoteException && e.getCause() instanceof ConnectException) {
                e = (Exception)e.getCause();
                throw (ServiceUnavailableException)new ServiceUnavailableException("Cannot lookup '" + name + "'.").initCause(e);
            }
            throw (NamingException)new NamingException("Cannot lookup '" + name + "'.").initCause(e);
        }
        switch (res.getResponseCode()) {
            case 13: {
                return this.createEJBHomeProxy((EJBMetaDataImpl)res.getResult());
            }
            case 21: {
                return this.createBusinessObject(res.getResult());
            }
            case 12: {
                return res.getResult();
            }
            case 23: {
                return res.getResult();
            }
            case 14: {
                JNDIContext subCtx = new JNDIContext(this);
                if (!name.endsWith("/")) {
                    name = name + '/';
                }
                subCtx.tail = name;
                return subCtx;
            }
            case 22: {
                return this.createDataSource((DataSourceMetaData)res.getResult());
            }
            case 25: {
                return this.createWebservice((WsMetaData)res.getResult());
            }
            case 24: {
                String type = (String)res.getResult();
                value = System.getProperty("Resource/" + type);
                if (value == null) {
                    return null;
                }
                return this.parseEntry(prop, value);
            }
            case 26: {
                Reference ref = (Reference)res.getResult();
                try {
                    return NamingManager.getObjectInstance(ref, this.getNameParser(name).parse(name), this, this.env);
                }
                catch (Exception e) {
                    throw (NamingException)new NamingException("Could not dereference " + ref).initCause(e);
                }
            }
            case 16: {
                throw new NameNotFoundException(name + " does not exist in the system.  Check that the app was successfully deployed.");
            }
            case 17: {
                Throwable throwable = ((ThrowableArtifact)res.getResult()).getThrowable();
                if (throwable instanceof NamingException) {
                    throw (NamingException)throwable;
                }
                throw (NamingException)new NamingException().initCause(throwable);
            }
            case 18: {
                throw (RuntimeException)res.getResult();
            }
            case 19: {
                throw (Error)res.getResult();
            }
        }
        throw new ClientRuntimeException("Invalid response from server: " + res.getResponseCode());
    }

    private Object parseEntry(String name, String value) throws NamingException {
        try {
            URI uri = new URI(value);
            String scheme = uri.getScheme();
            if (scheme.equals("link")) {
                value = System.getProperty(uri.getSchemeSpecificPart());
                if (value == null) {
                    return null;
                }
                return this.parseEntry(name, value);
            }
            if (scheme.equals("datasource")) {
                uri = new URI(uri.getSchemeSpecificPart());
                String driver = uri.getScheme();
                String url = uri.getSchemeSpecificPart();
                return new ClientDataSource(driver, url, null, null);
            }
            if (scheme.equals("connectionfactory")) {
                uri = new URI(uri.getSchemeSpecificPart());
                String driver = uri.getScheme();
                String url = uri.getSchemeSpecificPart();
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                if (classLoader == null) {
                    this.getClass().getClassLoader();
                }
                if (classLoader == null) {
                    ClassLoader.getSystemClassLoader();
                }
                try {
                    Class<?> clazz = Class.forName(driver, true, classLoader);
                    Constructor<?> constructor = clazz.getConstructor(String.class);
                    Object connectionFactory = constructor.newInstance(url);
                    return connectionFactory;
                }
                catch (Exception e) {
                    throw new IllegalStateException("Cannot use ConnectionFactory in client VM without the classh: " + driver, e);
                }
            }
            if (scheme.equals("javamail")) {
                return Session.getDefaultInstance((Properties)new Properties());
            }
            if (scheme.equals("orb")) {
                return this.getDefaultOrb();
            }
            throw new UnsupportedOperationException("Unsupported Naming URI scheme '" + scheme + "'");
        }
        catch (URISyntaxException e) {
            throw (NamingException)new NamingException("Unparsable jndi entry '" + name + "=" + value + "'.  Exception: " + e.getMessage()).initCause(e);
        }
    }

    private DataSource createDataSource(DataSourceMetaData dataSourceMetaData) {
        return new ClientDataSource(dataSourceMetaData);
    }

    private Object createWebservice(WsMetaData webserviceMetaData) throws NamingException {
        try {
            return webserviceMetaData.createWebservice();
        }
        catch (Exception e) {
            throw (NamingException)new NamingException("Error creating webservice").initCause(e);
        }
    }

    private ORB getDefaultOrb() {
        return ORB.init();
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        return this.lookup(name.toString());
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String name) throws NamingException {
        if (name == null) {
            throw new InvalidNameException("The name cannot be null");
        }
        if (name.startsWith("java:")) {
            name = name.replaceFirst("^java:", "");
        } else if (!name.startsWith("/")) {
            name = this.tail + name;
        }
        JNDIRequest req = new JNDIRequest(RequestMethodCode.JNDI_LIST, name);
        req.setModuleId(this.moduleId);
        JNDIResponse res = null;
        try {
            res = this.request(req);
        }
        catch (Exception e) {
            if (e instanceof RemoteException && e.getCause() instanceof ConnectException) {
                e = (Exception)e.getCause();
                throw (ServiceUnavailableException)new ServiceUnavailableException("Cannot list '" + name + "'.").initCause(e);
            }
            throw (NamingException)new NamingException("Cannot list '" + name + "'.").initCause(e);
        }
        switch (res.getResponseCode()) {
            case 12: {
                return null;
            }
            case 15: {
                return (NamingEnumeration)res.getResult();
            }
            case 16: {
                throw new NameNotFoundException(name);
            }
            case 17: {
                Throwable throwable = ((ThrowableArtifact)res.getResult()).getThrowable();
                if (throwable instanceof NamingException) {
                    throw (NamingException)throwable;
                }
                throw (NamingException)new NamingException().initCause(throwable);
            }
            case 19: {
                throw (Error)res.getResult();
            }
        }
        throw new ClientRuntimeException("Invalid response from server :" + res.getResponseCode());
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        return this.list(name.toString());
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String name) throws NamingException {
        Object o = this.lookup(name);
        if (o instanceof Context) {
            Context context = (Context)o;
            NamingEnumeration<NameClassPair> enumeration = context.list("");
            ArrayList<NameClassPair> bindings = new ArrayList<NameClassPair>();
            while (enumeration.hasMoreElements()) {
                NameClassPair pair = (NameClassPair)enumeration.nextElement();
                bindings.add(new LazyBinding(pair.getName(), pair.getClassName(), context));
            }
            return new NameClassPairEnumeration<Binding>(bindings);
        }
        return null;
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        return this.listBindings(name.toString());
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        return this.lookup(name);
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        return this.lookupLink(name.toString());
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        return new SimpleNameParser();
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        return new SimpleNameParser();
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        throw new OperationNotSupportedException("TODO: Needs to be implemented");
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        throw new OperationNotSupportedException("TODO: Needs to be implemented");
    }

    @Override
    public Object addToEnvironment(String key, Object value) throws NamingException {
        return this.env.put(key, value);
    }

    @Override
    public Object removeFromEnvironment(String key) throws NamingException {
        return this.env.remove(key);
    }

    public Hashtable getEnvironment() throws NamingException {
        return (Hashtable)this.env.clone();
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        return "";
    }

    @Override
    public void close() throws NamingException {
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        this.bind(name.toString(), obj);
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        this.rebind(name.toString(), obj);
    }

    @Override
    public void unbind(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void unbind(Name name) throws NamingException {
        this.unbind(name.toString());
    }

    @Override
    public void rename(String oldname, String newname) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void rename(Name oldname, Name newname) throws NamingException {
        this.rename(oldname.toString(), newname.toString());
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        this.destroySubcontext(name.toString());
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        return this.createSubcontext(name.toString());
    }

    private static final class SimpleNameParser
    implements NameParser {
        private static final Properties PARSER_PROPERTIES = new Properties();

        private SimpleNameParser() {
        }

        @Override
        public Name parse(String name) throws NamingException {
            return new CompoundName(name, PARSER_PROPERTIES);
        }

        static {
            PARSER_PROPERTIES.put("jndi.syntax.direction", "left_to_right");
            PARSER_PROPERTIES.put("jndi.syntax.separator", "/");
        }
    }

    private static class LazyBinding
    extends Binding {
        private static final long serialVersionUID = 1L;
        private RuntimeException failed;
        private Context context;

        public LazyBinding(String name, String className, Context context) {
            super(name, className, null);
            this.context = context;
        }

        @Override
        public synchronized Object getObject() {
            if (super.getObject() == null) {
                if (this.failed != null) {
                    throw this.failed;
                }
                try {
                    super.setObject(this.context.lookup(this.getName()));
                }
                catch (NamingException e) {
                    this.failed = new ClientRuntimeException("Failed to lazily fetch the binding '" + this.getName() + "'", e);
                    throw this.failed;
                }
            }
            return super.getObject();
        }
    }
}

