/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.lifecycle;

import java.io.IOException;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.MethodExpression;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.ProjectStage;
import javax.faces.application.ViewExpiredException;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PostAddToViewEvent;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import javax.faces.view.ViewDeclarationLanguage;
import javax.faces.view.ViewMetadata;
import javax.servlet.http.HttpServletResponse;
import org.apache.myfaces.lifecycle.DefaultRestoreViewSupport;
import org.apache.myfaces.lifecycle.PhaseExecutor;
import org.apache.myfaces.lifecycle.RestoreViewSupport;
import org.apache.myfaces.renderkit.ErrorPageWriter;
import org.apache.myfaces.shared.config.MyfacesConfig;

class RestoreViewExecutor
extends PhaseExecutor {
    private static final Logger log = Logger.getLogger(RestoreViewExecutor.class.getName());
    private RestoreViewSupport _restoreViewSupport;
    private Boolean _viewNotFoundCheck;

    RestoreViewExecutor() {
    }

    public void doPrePhaseActions(FacesContext facesContext) {
        facesContext.getApplication().getViewHandler().initView(facesContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(FacesContext facesContext) {
        boolean errorPageRequest;
        if (facesContext == null) {
            throw new FacesException("FacesContext is null");
        }
        Application application = facesContext.getApplication();
        ViewHandler viewHandler = application.getViewHandler();
        UIViewRoot viewRoot = facesContext.getViewRoot();
        RestoreViewSupport restoreViewSupport = this.getRestoreViewSupport(facesContext);
        if (viewRoot != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("View already exists in the FacesContext");
            }
            viewRoot.setLocale(facesContext.getExternalContext().getRequestLocale());
            restoreViewSupport.processComponentBinding(facesContext, (UIComponent)viewRoot);
            this._invokeViewRootAfterPhaseListener(facesContext);
            return false;
        }
        String viewId = restoreViewSupport.calculateViewId(facesContext);
        boolean bl = errorPageRequest = facesContext.getExternalContext().getRequestMap().get("javax.servlet.error.message") != null;
        if (!errorPageRequest && restoreViewSupport.isPostback(facesContext)) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Request is a postback");
            }
            if (this.checkViewNotFound(facesContext)) {
                String derivedViewId = viewHandler.deriveLogicalViewId(facesContext, viewId);
                ViewDeclarationLanguage vdl = viewHandler.getViewDeclarationLanguage(facesContext, derivedViewId);
                if (facesContext.getResponseComplete()) {
                    return true;
                }
                if (vdl == null || derivedViewId == null) {
                    this.sendSourceNotFound(facesContext, viewId);
                    return true;
                }
                if (!restoreViewSupport.checkViewExists(facesContext, derivedViewId)) {
                    this.sendSourceNotFound(facesContext, viewId);
                    return true;
                }
            }
            try {
                facesContext.setProcessingEvents(false);
                viewRoot = viewHandler.restoreView(facesContext, viewId);
                if (viewRoot == null) {
                    if (facesContext.getResponseComplete()) {
                        boolean derivedViewId = true;
                        return derivedViewId;
                    }
                    throw new ViewExpiredException("No saved view state could be found for the view identifier: " + viewId, viewId);
                }
                facesContext.setViewRoot(viewRoot);
            }
            finally {
                facesContext.setProcessingEvents(true);
            }
            restoreViewSupport.processComponentBinding(facesContext, (UIComponent)viewRoot);
        } else {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Request is not a postback. New UIViewRoot will be created");
            }
            String logicalViewId = viewHandler.deriveLogicalViewId(facesContext, viewId);
            ViewDeclarationLanguage vdl = viewHandler.getViewDeclarationLanguage(facesContext, logicalViewId);
            if (facesContext.getResponseComplete()) {
                return true;
            }
            if (this.checkViewNotFound(facesContext)) {
                if (vdl == null || logicalViewId == null) {
                    this.sendSourceNotFound(facesContext, viewId);
                    return true;
                }
                if (!restoreViewSupport.checkViewExists(facesContext, logicalViewId)) {
                    this.sendSourceNotFound(facesContext, viewId);
                    return true;
                }
            }
            if (vdl != null) {
                ViewMetadata metadata = vdl.getViewMetadata(facesContext, viewId);
                Collection viewParameters = null;
                if (metadata != null) {
                    viewRoot = metadata.createMetadataView(facesContext);
                    if (viewRoot != null) {
                        viewParameters = ViewMetadata.getViewParameters((UIViewRoot)viewRoot);
                    } else if (facesContext.getResponseComplete()) {
                        return true;
                    }
                }
                if (viewParameters == null || viewParameters.isEmpty()) {
                    facesContext.renderResponse();
                }
            } else {
                facesContext.renderResponse();
            }
            if (viewRoot == null) {
                viewRoot = viewHandler.createView(facesContext, viewId);
            }
            if (viewRoot == null && facesContext.getResponseComplete()) {
                return true;
            }
            facesContext.setViewRoot(viewRoot);
            application.publishEvent(facesContext, PostAddToViewEvent.class, (Object)viewRoot);
        }
        if (errorPageRequest && facesContext.isProjectStage(ProjectStage.Development)) {
            facesContext.getViewRoot().getViewMap().put("__myFacesErrorPageBean", new ErrorPageWriter.ErrorPageBean());
        }
        this._invokeViewRootAfterPhaseListener(facesContext);
        return false;
    }

    private void _invokeViewRootAfterPhaseListener(FacesContext facesContext) {
        UIViewRoot root = facesContext.getViewRoot();
        MethodExpression afterPhaseExpression = root.getAfterPhaseListener();
        if (afterPhaseExpression != null) {
            PhaseEvent event = new PhaseEvent(facesContext, this.getPhase(), this._getLifecycle(facesContext));
            try {
                afterPhaseExpression.invoke(facesContext.getELContext(), new Object[]{event});
            }
            catch (Throwable t) {
                log.log(Level.SEVERE, "An Exception occured while processing " + afterPhaseExpression.getExpressionString() + " in Phase " + this.getPhase(), t);
            }
        }
    }

    private Lifecycle _getLifecycle(FacesContext facesContext) {
        LifecycleFactory factory = (LifecycleFactory)FactoryFinder.getFactory((String)"javax.faces.lifecycle.LifecycleFactory");
        String id = facesContext.getExternalContext().getInitParameter("javax.faces.LIFECYCLE_ID");
        if (id == null) {
            id = "DEFAULT";
        }
        return factory.getLifecycle(id);
    }

    protected RestoreViewSupport getRestoreViewSupport() {
        return this.getRestoreViewSupport(FacesContext.getCurrentInstance());
    }

    protected RestoreViewSupport getRestoreViewSupport(FacesContext context) {
        if (this._restoreViewSupport == null) {
            this._restoreViewSupport = new DefaultRestoreViewSupport(context);
        }
        return this._restoreViewSupport;
    }

    public void setRestoreViewSupport(RestoreViewSupport restoreViewSupport) {
        this._restoreViewSupport = restoreViewSupport;
    }

    public PhaseId getPhase() {
        return PhaseId.RESTORE_VIEW;
    }

    protected boolean checkViewNotFound(FacesContext facesContext) {
        if (this._viewNotFoundCheck == null) {
            this._viewNotFoundCheck = MyfacesConfig.getCurrentInstance(facesContext.getExternalContext()).isStrictJsf2ViewNotFound();
        }
        return this._viewNotFoundCheck;
    }

    private void sendSourceNotFound(FacesContext context, String message) {
        HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
        try {
            context.responseComplete();
            response.sendError(404, message);
        }
        catch (IOException ioe) {
            throw new FacesException((Throwable)ioe);
        }
    }
}

