/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.cdi;

import java.lang.annotation.Annotation;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.el.ELResolver;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.jsp.JspApplicationContext;
import javax.servlet.jsp.JspFactory;
import org.apache.openejb.AppContext;
import org.apache.openejb.BeanContext;
import org.apache.openejb.OpenEJBRuntimeException;
import org.apache.openejb.assembler.classic.AppInfo;
import org.apache.openejb.assembler.classic.Assembler;
import org.apache.openejb.cdi.CdiAppContextsService;
import org.apache.openejb.cdi.CdiEjbBean;
import org.apache.openejb.cdi.CdiPlugin;
import org.apache.openejb.cdi.CdiResourceInjectionService;
import org.apache.openejb.cdi.CdiScanner;
import org.apache.openejb.cdi.OptimizedLoaderService;
import org.apache.openejb.cdi.StartupObject;
import org.apache.openejb.cdi.WebappBeanManager;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.webbeans.config.BeansDeployer;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.config.WebBeansFinder;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.intercept.InterceptorResolutionService;
import org.apache.webbeans.portable.AbstractProducer;
import org.apache.webbeans.portable.InjectionTargetImpl;
import org.apache.webbeans.portable.events.discovery.BeforeShutdownImpl;
import org.apache.webbeans.spi.ContainerLifecycle;
import org.apache.webbeans.spi.ContextsService;
import org.apache.webbeans.spi.JNDIService;
import org.apache.webbeans.spi.ResourceInjectionService;
import org.apache.webbeans.spi.ScannerService;
import org.apache.webbeans.spi.adaptor.ELAdaptor;
import org.apache.webbeans.util.WebBeansUtil;
import org.apache.webbeans.xml.WebBeansXMLConfigurator;

public class OpenEJBLifecycle
implements ContainerLifecycle {
    public static final ThreadLocal<AppInfo> CURRENT_APP_INFO = new ThreadLocal();
    private static final Logger logger = Logger.getInstance(LogCategory.OPENEJB_CDI, OpenEJBLifecycle.class);
    public static final String OPENEJB_CDI_SKIP_CLASS_NOT_FOUND = "openejb.cdi.skip-class-not-found";
    protected ScannerService scannerService;
    protected final ContextsService contextsService;
    private final BeansDeployer deployer;
    private final WebBeansXMLConfigurator xmlDeployer;
    private final JNDIService jndiService;
    private final BeanManagerImpl beanManager;
    private final WebBeansContext webBeansContext;
    private ScheduledExecutorService service;

    public OpenEJBLifecycle(WebBeansContext webBeansContext) {
        this.webBeansContext = webBeansContext;
        this.beforeInitApplication(null);
        this.beanManager = webBeansContext.getBeanManagerImpl();
        this.xmlDeployer = new WebBeansXMLConfigurator();
        this.deployer = new BeansDeployer(this.xmlDeployer, webBeansContext);
        this.jndiService = (JNDIService)webBeansContext.getService(JNDIService.class);
        this.beanManager.setXMLConfigurator(this.xmlDeployer);
        this.scannerService = webBeansContext.getScannerService();
        this.contextsService = webBeansContext.getContextsService();
        this.initApplication(null);
    }

    public BeanManager getBeanManager() {
        return this.beanManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startApplication(Object startupObject) {
        if (startupObject instanceof ServletContextEvent) {
            this.startServletContext((ServletContext)this.getServletContext(startupObject));
            return;
        }
        if (!(startupObject instanceof StartupObject)) {
            logger.debug("startupObject is not of StartupObject type; ignored");
            return;
        }
        StartupObject stuff = (StartupObject)startupObject;
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        logger.info("OpenWebBeans Container is starting...");
        long begin = System.currentTimeMillis();
        try {
            Thread.currentThread().setContextClassLoader(stuff.getClassLoader());
            this.beforeStartApplication(startupObject);
            this.webBeansContext.getPluginLoader().startUp();
            CdiPlugin cdiPlugin = (CdiPlugin)this.webBeansContext.getPluginLoader().getEjbPlugin();
            AppContext appContext = stuff.getAppContext();
            if (stuff.getWebContext() == null) {
                appContext.setWebBeansContext(this.webBeansContext);
            }
            cdiPlugin.setClassLoader(stuff.getClassLoader());
            cdiPlugin.setWebBeansContext(this.webBeansContext);
            cdiPlugin.startup();
            cdiPlugin.configureDeployments(stuff.getBeanContexts());
            CdiResourceInjectionService injectionService = (CdiResourceInjectionService)this.webBeansContext.getService(ResourceInjectionService.class);
            injectionService.setAppContext(stuff.getAppContext());
            try {
                this.webBeansContext.getExtensionLoader().loadExtensionServices(Thread.currentThread().getContextClassLoader());
                this.contextsService.init(startupObject);
                logger.debug("Scanning classpaths for beans artifacts.");
                if (this.scannerService instanceof CdiScanner) {
                    CdiScanner service = (CdiScanner)this.scannerService;
                    service.init(startupObject);
                } else {
                    new CdiScanner().init(startupObject);
                }
                this.scannerService.scan();
                CURRENT_APP_INFO.set(((StartupObject)StartupObject.class.cast(startupObject)).getAppInfo());
                this.deployer.deploy(this.scannerService);
            }
            catch (Exception e1) {
                Assembler.logger.error("CDI Beans module deployment failed", e1);
                throw new OpenEJBRuntimeException(e1);
            }
            finally {
                CURRENT_APP_INFO.remove();
            }
            for (BeanContext bc : stuff.getBeanContexts()) {
                CdiEjbBean cdiEjbBean = bc.get(CdiEjbBean.class);
                if (cdiEjbBean == null) continue;
                if (AbstractProducer.class.isInstance((Object)cdiEjbBean)) {
                    ((AbstractProducer)AbstractProducer.class.cast((Object)cdiEjbBean)).defineInterceptorStack((Bean)cdiEjbBean, cdiEjbBean.getAnnotatedType(), cdiEjbBean.getWebBeansContext());
                }
                bc.mergeOWBAndOpenEJBInfo();
                bc.set(InterceptorResolutionService.BeanInterceptorInfo.class, ((InjectionTargetImpl)InjectionTargetImpl.class.cast(cdiEjbBean.getInjectionTarget())).getInterceptorInfo());
                cdiEjbBean.initInternals();
            }
            this.afterStartApplication(startupObject);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCl);
            OptimizedLoaderService.ADDITIONAL_EXTENSIONS.remove();
            CdiScanner.ADDITIONAL_CLASSES.remove();
        }
        logger.info("OpenWebBeans Container has started, it took {0} ms.", Long.toString(System.currentTimeMillis() - begin));
    }

    public void stopApplication(Object endObject) {
        logger.debug("OpenWebBeans Container is stopping.");
        try {
            this.beforeStopApplication(null);
            if (this.beanManager instanceof WebappBeanManager) {
                ((WebappBeanManager)this.beanManager).beforeStop();
            }
            this.beanManager.fireEvent((Object)new BeforeShutdownImpl(), new Annotation[0]);
            this.contextsService.destroy(null);
            if (this.jndiService != null) {
                this.jndiService.unbind("java:comp/BeanManager");
            }
            ((CdiPlugin)this.webBeansContext.getPluginLoader().getEjbPlugin()).clearProxies();
            this.webBeansContext.getPluginLoader().shutDown();
            this.webBeansContext.getExtensionLoader().clear();
            this.beanManager.getInjectionResolver().clearCaches();
            this.webBeansContext.getAnnotatedElementFactory().clear();
            this.afterStopApplication(null);
            this.beanManager.clear();
            WebBeansFinder.clearInstances((Object)WebBeansUtil.getCurrentClassLoader());
        }
        catch (Exception e) {
            logger.error("An error occured while stopping the container.", e);
        }
    }

    protected ScannerService getScannerService() {
        return this.scannerService;
    }

    public ContextsService getContextService() {
        return this.contextsService;
    }

    protected WebBeansXMLConfigurator getXmlDeployer() {
        return this.xmlDeployer;
    }

    protected JNDIService getJndiService() {
        return this.jndiService;
    }

    public void initApplication(Properties properties) {
        this.afterInitApplication(properties);
    }

    protected void beforeInitApplication(Properties properties) {
    }

    protected void afterInitApplication(Properties properties) {
    }

    protected void afterStartApplication(Object startupObject) {
        if (this.beanManager instanceof WebappBeanManager) {
            ((WebappBeanManager)this.beanManager).afterStart();
        }
    }

    public void startServletContext(ServletContext servletContext) {
        this.service = OpenEJBLifecycle.initializeServletContext(servletContext, this.webBeansContext);
    }

    public static ScheduledExecutorService initializeServletContext(final ServletContext servletContext, WebBeansContext context) {
        String strDelay = context.getOpenWebBeansConfiguration().getProperty("org.apache.webbeans.conversation.Conversation.periodicDelay", "150000");
        long delay = Long.parseLong(strDelay);
        ScheduledExecutorService executorService = Executors.newScheduledThreadPool(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runable) {
                Thread t = new Thread(runable, "OwbConversationCleaner-" + servletContext.getContextPath());
                t.setDaemon(true);
                return t;
            }
        });
        executorService.scheduleWithFixedDelay(new ConversationCleaner(context), delay, delay, TimeUnit.MILLISECONDS);
        ELAdaptor elAdaptor = (ELAdaptor)context.getService(ELAdaptor.class);
        ELResolver resolver = elAdaptor.getOwbELResolver();
        if (context.getOpenWebBeansConfiguration().isJspApplication()) {
            logger.debug("Application is configured as JSP. Adding EL Resolver.");
            JspFactory factory = JspFactory.getDefaultFactory();
            if (factory != null) {
                JspApplicationContext applicationCtx = factory.getJspApplicationContext(servletContext);
                applicationCtx.addELResolver(resolver);
            } else {
                logger.debug("Default JspFactory instance was not found");
            }
        }
        servletContext.setAttribute(BeanManager.class.getName(), (Object)context.getBeanManagerImpl());
        return executorService;
    }

    protected void afterStopApplication(Object stopObject) throws Exception {
        ResourceInjectionService injectionServices = (ResourceInjectionService)this.webBeansContext.getService(ResourceInjectionService.class);
        if (injectionServices != null) {
            injectionServices.clear();
        }
        ((CdiAppContextsService)((Object)CdiAppContextsService.class.cast(this.contextsService))).removeThreadLocals();
        WebBeansFinder.clearInstances((Object)WebBeansUtil.getCurrentClassLoader());
    }

    private Object getServletContext(Object object) {
        if (object instanceof ServletContextEvent) {
            object = ((ServletContextEvent)object).getServletContext();
            return object;
        }
        return object;
    }

    protected void beforeStartApplication(Object startupObject) {
    }

    protected void beforeStopApplication(Object stopObject) throws Exception {
        if (this.service != null) {
            this.service.shutdownNow();
        }
    }

    private static final class ConversationCleaner
    implements Runnable {
        private final WebBeansContext webBeansContext;

        private ConversationCleaner(WebBeansContext webBeansContext) {
            this.webBeansContext = webBeansContext;
        }

        @Override
        public void run() {
            this.webBeansContext.getConversationManager().destroyWithRespectToTimout();
        }
    }
}

