/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.bean;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.el.ValueExpression;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.bean.TypeRepository;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface FacesBean {
    public Type getType();

    public Object getProperty(PropertyKey var1);

    public void setProperty(PropertyKey var1, Object var2);

    public Object getLocalProperty(PropertyKey var1);

    public ValueExpression getValueExpression(PropertyKey var1);

    public ValueBinding getValueBinding(PropertyKey var1);

    public Object getRawProperty(PropertyKey var1);

    public void setValueExpression(PropertyKey var1, ValueExpression var2);

    public void setValueBinding(PropertyKey var1, ValueBinding var2);

    public void addEntry(PropertyKey var1, Object var2);

    public void removeEntry(PropertyKey var1, Object var2);

    public Object[] getEntries(PropertyKey var1, Class<?> var2);

    public boolean containsEntry(PropertyKey var1, Class<?> var2);

    public Iterator<? extends Object> entries(PropertyKey var1);

    public void addAll(FacesBean var1);

    public Set<PropertyKey> keySet();

    public Set<PropertyKey> bindingKeySet();

    public void markInitialState();

    public Object saveState(FacesContext var1);

    public void restoreState(FacesContext var1, Object var2);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Type {
        private final Map<String, PropertyKey> _keyMap;
        private final List<PropertyKey> _unmodifiableKeys;
        private final ArrayList<PropertyKey> _keyList;
        private boolean _isLocked;
        private int _index;
        private final Type _superType;
        private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(Type.class);

        public Type() {
            this(null);
        }

        public Type(Type superType) {
            this._superType = superType;
            this._keyMap = new HashMap<String, PropertyKey>();
            this._keyList = new ArrayList();
            this._unmodifiableKeys = Collections.unmodifiableList(this._keyList);
            if (this._superType != null) {
                this._keyMap.putAll(this._superType._keyMap);
                this._keyList.addAll(this._superType._keyList);
                this._index = this._superType._index;
                this._superType.lock();
            }
        }

        public PropertyKey findKey(String name) {
            return this._keyMap.get(name);
        }

        public PropertyKey findKey(int index) {
            if (index < 0 || index >= this._keyList.size()) {
                return null;
            }
            return this._keyList.get(index);
        }

        public final PropertyKey registerKey(String name, Class<?> type, Object defaultValue) {
            return this.registerKey(name, type, defaultValue, 0);
        }

        public final PropertyKey registerKey(String name, Class<?> type) {
            return this.registerKey(name, type, null, 0);
        }

        public final PropertyKey registerKey(String name) {
            return this.registerKey(name, Object.class, null, 0);
        }

        public final PropertyKey registerKey(String name, int capabilities) {
            return this.registerKey(name, Object.class, null, capabilities);
        }

        public final PropertyKey registerKey(String name, Class<?> type, int capabilities) {
            return this.registerKey(name, type, null, capabilities);
        }

        public PropertyKey registerAlias(PropertyKey key, String alias) {
            this._checkLocked();
            if (this.findKey(alias) != null) {
                throw new IllegalStateException();
            }
            this._keyMap.put(alias, key);
            return key;
        }

        public PropertyKey registerKey(String name, Class<?> type, Object defaultValue, int capabilities) {
            this._checkLocked();
            this._checkName(name);
            PropertyKey key = this.createPropertyKey(name, type, defaultValue, capabilities, this.getNextIndex());
            this.addKey(key);
            return key;
        }

        public void lock() {
            this._isLocked = true;
        }

        public void lockAndRegister(String componentFamily, String rendererType) {
            this.lock();
            TypeRepository.registerType(componentFamily, rendererType, this);
        }

        public Iterator<PropertyKey> keys() {
            return this.propertyKeys().iterator();
        }

        public Collection<PropertyKey> propertyKeys() {
            return this._unmodifiableKeys;
        }

        protected PropertyKey createPropertyKey(String name, Class<?> type, Object defaultValue, int capabilities, int index) {
            if (this._superType != null) {
                return this._superType.createPropertyKey(name, type, defaultValue, capabilities, index);
            }
            return new PropertyKey(name, type, defaultValue, capabilities, index);
        }

        protected int getNextIndex() {
            int index = this._index;
            this._index = index + 1;
            return index;
        }

        protected void addKey(PropertyKey key) {
            this._checkLocked();
            PropertyKey oldValue = this._keyMap.put(key.getName(), key);
            if (oldValue != null) {
                this._keyMap.put(key.getName(), oldValue);
                throw new IllegalStateException(_LOG.getMessage("NAME_ALREADY_REGISTERED", key.getName()));
            }
            int index = key.getIndex();
            if (index >= 0) {
                Type._expandListToIndex(this._keyList, index);
                oldValue = this._keyList.set(index, key);
                if (oldValue != null) {
                    this._keyList.set(index, oldValue);
                    throw new IllegalStateException(_LOG.getMessage("INDEX_ALREADY_REGISTERED", index));
                }
            }
            key.__setOwner(this);
        }

        private static void _expandListToIndex(ArrayList<PropertyKey> list, int count) {
            list.ensureCapacity(count + 1);
            int addCount = count + 1 - list.size();
            for (int i = 0; i < addCount; ++i) {
                list.add(null);
            }
        }

        private void _checkLocked() {
            if (this._isLocked) {
                throw new IllegalStateException(_LOG.getMessage("TYPE_ALREADY_LOCKED"));
            }
        }

        private void _checkName(String name) {
            if (this.findKey(name) != null) {
                throw new IllegalStateException(_LOG.getMessage("NAME_ALREADY_REGISTERED", name));
            }
        }
    }
}

