/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.runtime;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.maven.shared.runtime.MavenProjectProperties;
import org.apache.maven.shared.runtime.MavenRuntimeException;
import org.apache.maven.shared.runtime.MavenRuntimeVisitor;
import org.codehaus.plexus.util.IOUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PropertiesMavenRuntimeVisitor
implements MavenRuntimeVisitor {
    private static final String GROUP_ID_PROPERTY = "groupId";
    private static final String ARTIFACT_ID_PROPERTY = "artifactId";
    private static final String VERSION_PROPERTY = "version";
    private final List<MavenProjectProperties> projects = new ArrayList<MavenProjectProperties>();

    @Override
    public void visitProjectProperties(URL url) throws MavenRuntimeException {
        MavenProjectProperties project = this.parseProjectProperties(url);
        this.projects.add(project);
    }

    @Override
    public void visitProjectXML(URL url) throws MavenRuntimeException {
    }

    public List<MavenProjectProperties> getProjects() {
        return Collections.unmodifiableList(this.projects);
    }

    private MavenProjectProperties parseProjectProperties(URL url) throws MavenRuntimeException {
        Properties properties = new Properties();
        InputStream in = null;
        try {
            URLConnection connection = url.openConnection();
            connection.setUseCaches(false);
            in = connection.getInputStream();
            properties.load(in);
        }
        catch (IOException exception) {
            try {
                throw new MavenRuntimeException("Cannot read project properties: " + url, exception);
            }
            catch (Throwable throwable) {
                IOUtil.close(in);
                throw throwable;
            }
        }
        IOUtil.close((InputStream)in);
        String groupId = properties.getProperty(GROUP_ID_PROPERTY);
        String artifactId = properties.getProperty(ARTIFACT_ID_PROPERTY);
        String version = properties.getProperty(VERSION_PROPERTY);
        return new MavenProjectProperties(groupId, artifactId, version);
    }
}

