/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.runtime;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MavenProjectUtils {
    private MavenProjectUtils() {
        throw new AssertionError();
    }

    public static void mediateDependencyVersions(List<MavenProject> projects) {
        Map<String, String> versionsByProjectId = MavenProjectUtils.getVersionsByProjectId(projects);
        for (MavenProject project : projects) {
            MavenProjectUtils.mediateProject(project, versionsByProjectId);
        }
    }

    private static void mediateProject(MavenProject project, Map<String, String> versionsByProjectId) {
        for (Dependency dependency : project.getDependencies()) {
            MavenProjectUtils.mediateDependency(dependency, versionsByProjectId);
        }
    }

    private static void mediateDependency(Dependency dependency, Map<String, String> versionsByProjectId) {
        String projectId = MavenProjectUtils.versionlessKey(dependency);
        String version = versionsByProjectId.get(projectId);
        if (version != null) {
            dependency.setVersion(version);
        }
    }

    private static Map<String, String> getVersionsByProjectId(List<MavenProject> projects) {
        HashMap<String, String> versionsByProjectId = new HashMap<String, String>();
        for (MavenProject project : projects) {
            String projectId = MavenProjectUtils.versionlessKey(project);
            String version = project.getVersion();
            versionsByProjectId.put(projectId, version);
        }
        return versionsByProjectId;
    }

    private static String versionlessKey(MavenProject project) {
        return ArtifactUtils.versionlessKey((String)project.getGroupId(), (String)project.getArtifactId());
    }

    private static String versionlessKey(Dependency dependency) {
        return ArtifactUtils.versionlessKey((String)dependency.getGroupId(), (String)dependency.getArtifactId());
    }
}

