/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release.exec;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class RawStreamPumper
extends Thread {
    private InputStream in;
    private OutputStream out;
    boolean done;
    boolean poll;
    byte[] buffer = new byte[256];

    public RawStreamPumper(InputStream in, OutputStream out, boolean poll) {
        this.in = in;
        this.out = out;
        this.poll = poll;
    }

    public RawStreamPumper(InputStream in, OutputStream out) {
        this.in = in;
        this.out = out;
        this.poll = false;
    }

    public void setDone() {
        this.done = true;
    }

    public void closeInput() throws IOException {
        this.in.close();
    }

    public void closeOutput() throws IOException {
        this.out.close();
    }

    @Override
    public void run() {
        try {
            if (this.poll) {
                while (!this.done) {
                    if (this.in.available() > 0) {
                        int i = this.in.read(this.buffer);
                        if (i != -1) {
                            this.out.write(this.buffer, 0, i);
                            this.out.flush();
                            continue;
                        }
                        this.done = true;
                        continue;
                    }
                    Thread.sleep(1L);
                }
            } else {
                int i = this.in.read(this.buffer);
                while (i != -1 && !this.done) {
                    if (i != -1) {
                        this.out.write(this.buffer, 0, i);
                        this.out.flush();
                    } else {
                        this.done = true;
                    }
                    i = this.in.read(this.buffer);
                }
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            this.done = true;
        }
    }
}

