/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release.phase;

import java.io.File;
import java.util.List;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.branch.BranchScmResult;
import org.apache.maven.scm.manager.NoSuchScmProviderException;
import org.apache.maven.scm.provider.ScmProvider;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;
import org.apache.maven.shared.release.ReleaseExecutionException;
import org.apache.maven.shared.release.ReleaseFailureException;
import org.apache.maven.shared.release.ReleaseResult;
import org.apache.maven.shared.release.config.ReleaseDescriptor;
import org.apache.maven.shared.release.env.ReleaseEnvironment;
import org.apache.maven.shared.release.phase.AbstractReleasePhase;
import org.apache.maven.shared.release.scm.ReleaseScmCommandException;
import org.apache.maven.shared.release.scm.ReleaseScmRepositoryException;
import org.apache.maven.shared.release.scm.ScmRepositoryConfigurator;

public class ScmBranchPhase
extends AbstractReleasePhase {
    private ScmRepositoryConfigurator scmRepositoryConfigurator;

    public ReleaseResult execute(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List reactorProjects) throws ReleaseExecutionException, ReleaseFailureException {
        BranchScmResult result;
        ScmProvider provider;
        ScmRepository repository;
        ReleaseResult relResult = new ReleaseResult();
        ScmBranchPhase.validateConfiguration(releaseDescriptor);
        this.logInfo(relResult, "Branching release with the label " + releaseDescriptor.getScmReleaseLabel() + "...");
        try {
            repository = this.scmRepositoryConfigurator.getConfiguredRepository(releaseDescriptor, releaseEnvironment.getSettings());
            provider = this.scmRepositoryConfigurator.getRepositoryProvider(repository);
        }
        catch (ScmRepositoryException e) {
            throw new ReleaseScmRepositoryException(e.getMessage(), e.getValidationMessages());
        }
        catch (NoSuchScmProviderException e) {
            throw new ReleaseExecutionException("Unable to configure SCM repository: " + e.getMessage(), e);
        }
        try {
            ScmFileSet fileSet = new ScmFileSet(new File(releaseDescriptor.getWorkingDirectory()));
            String branchName = releaseDescriptor.getScmReleaseLabel();
            result = provider.branch(repository, fileSet, branchName, releaseDescriptor.getScmCommentPrefix() + " copy for branch " + branchName);
        }
        catch (ScmException e) {
            throw new ReleaseExecutionException("An error is occurred in the branch process: " + e.getMessage(), e);
        }
        if (!result.isSuccess()) {
            throw new ReleaseScmCommandException("Unable to branch SCM", (ScmResult)result);
        }
        relResult.setResultCode(0);
        return relResult;
    }

    public ReleaseResult simulate(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List reactorProjects) throws ReleaseExecutionException, ReleaseFailureException {
        ReleaseResult result = new ReleaseResult();
        ScmBranchPhase.validateConfiguration(releaseDescriptor);
        this.logInfo(result, "Full run would be branching " + releaseDescriptor.getWorkingDirectory() + " with label: '" + releaseDescriptor.getScmReleaseLabel() + "'");
        result.setResultCode(0);
        return result;
    }

    private static void validateConfiguration(ReleaseDescriptor releaseDescriptor) throws ReleaseFailureException {
        if (releaseDescriptor.getScmReleaseLabel() == null) {
            throw new ReleaseFailureException("A release label is required for committing");
        }
    }
}

