/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release.phase;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.project.MavenProject;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.checkin.CheckInScmResult;
import org.apache.maven.scm.manager.NoSuchScmProviderException;
import org.apache.maven.scm.provider.ScmProvider;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;
import org.apache.maven.shared.release.ReleaseExecutionException;
import org.apache.maven.shared.release.ReleaseFailureException;
import org.apache.maven.shared.release.ReleaseResult;
import org.apache.maven.shared.release.config.ReleaseDescriptor;
import org.apache.maven.shared.release.env.ReleaseEnvironment;
import org.apache.maven.shared.release.phase.AbstractReleasePhase;
import org.apache.maven.shared.release.scm.ReleaseScmCommandException;
import org.apache.maven.shared.release.scm.ReleaseScmRepositoryException;
import org.apache.maven.shared.release.scm.ScmRepositoryConfigurator;
import org.apache.maven.shared.release.util.ReleaseUtil;

public class ScmCommitPhase
extends AbstractReleasePhase {
    private ScmRepositoryConfigurator scmRepositoryConfigurator;
    private String messageFormat;

    public ReleaseResult execute(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List reactorProjects) throws ReleaseExecutionException, ReleaseFailureException {
        ScmProvider provider;
        ScmRepository repository;
        ReleaseResult relResult = new ReleaseResult();
        ScmCommitPhase.validateConfiguration(releaseDescriptor);
        this.getLogger().info("Checking in modified POMs...");
        try {
            repository = this.scmRepositoryConfigurator.getConfiguredRepository(releaseDescriptor, releaseEnvironment.getSettings());
            provider = this.scmRepositoryConfigurator.getRepositoryProvider(repository);
        }
        catch (ScmRepositoryException e) {
            throw new ReleaseScmRepositoryException(e.getMessage(), e.getValidationMessages());
        }
        catch (NoSuchScmProviderException e) {
            throw new ReleaseExecutionException("Unable to configure SCM repository: " + e.getMessage(), e);
        }
        if (releaseDescriptor.isCommitByProject()) {
            Iterator i = reactorProjects.iterator();
            while (i.hasNext()) {
                MavenProject project = (MavenProject)i.next();
                List pomFiles = ScmCommitPhase.createPomFiles(releaseDescriptor, project);
                ScmFileSet fileSet = new ScmFileSet(project.getFile().getParentFile(), pomFiles);
                this.checkin(provider, repository, fileSet, this.createMessage(releaseDescriptor));
            }
        } else {
            List pomFiles = ScmCommitPhase.createPomFiles(releaseDescriptor, reactorProjects);
            ScmFileSet fileSet = new ScmFileSet(new File(releaseDescriptor.getWorkingDirectory()), pomFiles);
            this.checkin(provider, repository, fileSet, this.createMessage(releaseDescriptor));
        }
        relResult.setResultCode(0);
        return relResult;
    }

    private void checkin(ScmProvider provider, ScmRepository repository, ScmFileSet fileSet, String message) throws ReleaseExecutionException, ReleaseScmCommandException {
        CheckInScmResult result;
        try {
            result = provider.checkIn(repository, fileSet, (ScmVersion)null, message);
        }
        catch (ScmException e) {
            throw new ReleaseExecutionException("An error is occurred in the checkin process: " + e.getMessage(), e);
        }
        if (!result.isSuccess()) {
            throw new ReleaseScmCommandException("Unable to commit files", (ScmResult)result);
        }
    }

    public ReleaseResult simulate(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List reactorProjects) throws ReleaseExecutionException, ReleaseFailureException {
        ReleaseResult result = new ReleaseResult();
        ScmCommitPhase.validateConfiguration(releaseDescriptor);
        List pomFiles = ScmCommitPhase.createPomFiles(releaseDescriptor, reactorProjects);
        this.logInfo(result, "Full run would be checking in " + pomFiles.size() + " files with message: '" + this.createMessage(releaseDescriptor) + "'");
        result.setResultCode(0);
        return result;
    }

    private static void validateConfiguration(ReleaseDescriptor releaseDescriptor) throws ReleaseFailureException {
        if (releaseDescriptor.getScmReleaseLabel() == null) {
            throw new ReleaseFailureException("A release label is required for committing");
        }
    }

    private String createMessage(ReleaseDescriptor releaseDescriptor) {
        return MessageFormat.format(releaseDescriptor.getScmCommentPrefix() + this.messageFormat, releaseDescriptor.getScmReleaseLabel());
    }

    private static List createPomFiles(ReleaseDescriptor releaseDescriptor, MavenProject project) {
        ArrayList<File> pomFiles = new ArrayList<File>();
        pomFiles.add(ReleaseUtil.getStandardPom(project));
        if (releaseDescriptor.isGenerateReleasePoms()) {
            pomFiles.add(ReleaseUtil.getReleasePom(project));
        }
        return pomFiles;
    }

    private static List createPomFiles(ReleaseDescriptor releaseDescriptor, List reactorProjects) {
        ArrayList pomFiles = new ArrayList();
        Iterator i = reactorProjects.iterator();
        while (i.hasNext()) {
            MavenProject project = (MavenProject)i.next();
            pomFiles.addAll(ScmCommitPhase.createPomFiles(releaseDescriptor, project));
        }
        return pomFiles;
    }
}

