/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.site.descriptor;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.doxia.site.SiteModel;
import org.apache.maven.doxia.site.io.xpp3.SiteXpp3Writer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.site.descriptor.AbstractSiteDescriptorMojo;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.xml.XMLWriter;
import org.codehaus.plexus.util.xml.XmlStreamWriter;
import org.codehaus.plexus.util.xml.XmlWriterUtil;

@Mojo(name="effective-site", requiresReports=true)
public class EffectiveSiteMojo
extends AbstractSiteDescriptorMojo {
    @Parameter(property="output")
    protected File output;

    public void execute() throws MojoExecutionException, MojoFailureException {
        SiteModel siteModel = this.prepareSiteModel(this.getLocales().get(0));
        StringWriter w = new StringWriter();
        PrettyPrintXMLWriter writer = new PrettyPrintXMLWriter((Writer)w, StringUtils.repeat((String)" ", (int)2), siteModel.getModelEncoding(), null);
        EffectiveSiteMojo.writeHeader((XMLWriter)writer);
        this.writeEffectiveSite(siteModel, (XMLWriter)writer);
        String effectiveSite = w.toString();
        if (this.output != null) {
            try {
                EffectiveSiteMojo.writeXmlFile(this.output, effectiveSite);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Cannot write effective site descriptor to output: " + this.output, (Exception)e);
            }
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info((CharSequence)("Effective site descriptor written to: " + this.output));
            }
        } else {
            StringBuilder message = new StringBuilder();
            message.append("\nEffective site descriptor, after inheritance and interpolation:\n\n");
            message.append(effectiveSite);
            message.append("\n");
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info((CharSequence)message.toString());
            }
        }
    }

    protected static void writeHeader(XMLWriter writer) {
        XmlWriterUtil.writeCommentLineBreak((XMLWriter)writer);
        XmlWriterUtil.writeComment((XMLWriter)writer, (String)" ");
        XmlWriterUtil.writeComment((XMLWriter)writer, (String)"Generated by Maven Site Plugin");
        XmlWriterUtil.writeComment((XMLWriter)writer, (String)"See: https://maven.apache.org/plugins/maven-site-plugin/");
        XmlWriterUtil.writeComment((XMLWriter)writer, (String)" ");
        XmlWriterUtil.writeCommentLineBreak((XMLWriter)writer);
        XmlWriterUtil.writeLineBreak((XMLWriter)writer);
    }

    protected static void writeComment(XMLWriter writer, String comment) {
        XmlWriterUtil.writeCommentLineBreak((XMLWriter)writer);
        XmlWriterUtil.writeComment((XMLWriter)writer, (String)" ");
        XmlWriterUtil.writeComment((XMLWriter)writer, (String)comment);
        XmlWriterUtil.writeComment((XMLWriter)writer, (String)" ");
        XmlWriterUtil.writeCommentLineBreak((XMLWriter)writer);
        XmlWriterUtil.writeLineBreak((XMLWriter)writer);
    }

    private void writeEffectiveSite(SiteModel siteModel, XMLWriter writer) throws MojoExecutionException {
        StringWriter sWriter = new StringWriter();
        SiteXpp3Writer siteWriter = new SiteXpp3Writer();
        try {
            siteWriter.write((Writer)sWriter, siteModel);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot serialize site descriptor to XML.", (Exception)e);
        }
        String effectiveSite = sWriter.toString();
        effectiveSite = effectiveSite.substring(effectiveSite.indexOf("<project "));
        EffectiveSiteMojo.writeComment(writer, "Effective site descriptor for project '" + this.project.getId() + "'");
        writer.writeMarkup(effectiveSite);
    }

    protected static void writeXmlFile(File output, String content) throws IOException {
        try (XmlStreamWriter out = WriterFactory.newXmlWriter((File)output);){
            output.getParentFile().mkdirs();
            out.write(content);
        }
    }
}

