/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.pmd;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.sourceforge.pmd.PMD;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.plugin.pmd.PmdFileInfo;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.PathTool;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPmdReport
extends AbstractMavenReport {
    protected File targetDirectory;
    protected File outputDirectory;
    private Renderer siteRenderer;
    protected MavenProject project;
    protected String format = "xml";
    private boolean linkXRef;
    private File xrefLocation;
    private File xrefTestLocation;
    private List<String> excludes;
    private List<String> includes;
    private List<String> compileSourceRoots;
    private List<String> testSourceRoots;
    private File[] excludeRoots;
    protected boolean includeTests;
    protected boolean aggregate;
    private String sourceEncoding;
    private String outputEncoding;
    protected List<MavenProject> reactorProjects;

    protected MavenProject getProject() {
        return this.project;
    }

    protected Renderer getSiteRenderer() {
        return this.siteRenderer;
    }

    protected String constructXRefLocation(boolean test) {
        String location = null;
        if (this.linkXRef) {
            File xrefLoc = test ? this.xrefTestLocation : this.xrefLocation;
            String relativePath = PathTool.getRelativePath((String)this.outputDirectory.getAbsolutePath(), (String)xrefLoc.getAbsolutePath());
            if (StringUtils.isEmpty((String)relativePath)) {
                relativePath = ".";
            }
            relativePath = relativePath + "/" + xrefLoc.getName();
            if (xrefLoc.exists()) {
                location = relativePath;
            } else {
                List reportPlugins = this.project.getReportPlugins();
                for (ReportPlugin plugin : reportPlugins) {
                    String artifactId = plugin.getArtifactId();
                    if (!"maven-jxr-plugin".equals(artifactId) && !"jxr-maven-plugin".equals(artifactId)) continue;
                    location = relativePath;
                }
            }
            if (location == null) {
                this.getLog().warn((CharSequence)"Unable to locate Source XRef to link to - DISABLED");
            }
        }
        return location;
    }

    protected Map<File, PmdFileInfo> getFilesToProcess() throws IOException {
        File sroot;
        String testXref;
        String sourceXref = this.constructXRefLocation(false);
        String string = testXref = this.includeTests ? this.constructXRefLocation(true) : "";
        if (this.aggregate && !this.project.isExecutionRoot()) {
            return Collections.emptyMap();
        }
        if (this.excludeRoots == null) {
            this.excludeRoots = new File[0];
        }
        HashSet<File> excludeRootFiles = new HashSet<File>(this.excludeRoots.length);
        for (int i = 0; i < this.excludeRoots.length; ++i) {
            File file = this.excludeRoots[i];
            if (!file.isDirectory()) continue;
            excludeRootFiles.add(file);
        }
        ArrayList<PmdFileInfo> directories = new ArrayList<PmdFileInfo>();
        if (this.compileSourceRoots != null) {
            for (String root : this.compileSourceRoots) {
                sroot = new File(root);
                directories.add(new PmdFileInfo(this.project, sroot, sourceXref));
            }
        }
        if (this.includeTests && this.testSourceRoots != null) {
            for (String root : this.testSourceRoots) {
                sroot = new File(root);
                directories.add(new PmdFileInfo(this.project, sroot, testXref));
            }
        }
        if (this.aggregate) {
            for (MavenProject localProject : this.reactorProjects) {
                List localCompileSourceRoots = localProject.getCompileSourceRoots();
                for (String root : localCompileSourceRoots) {
                    File sroot2 = new File(root);
                    directories.add(new PmdFileInfo(localProject, sroot2, sourceXref));
                }
                if (!this.includeTests) continue;
                List localTestCompileSourceRoots = localProject.getTestCompileSourceRoots();
                for (String root : localTestCompileSourceRoots) {
                    File sroot3 = new File(root);
                    directories.add(new PmdFileInfo(localProject, sroot3, testXref));
                }
            }
        }
        String excluding = this.getExcludes();
        this.getLog().debug((CharSequence)("Exclusions: " + excluding));
        String including = this.getIncludes();
        this.getLog().debug((CharSequence)("Inclusions: " + including));
        TreeMap<File, PmdFileInfo> files = new TreeMap<File, PmdFileInfo>();
        for (PmdFileInfo finfo : directories) {
            File sourceDirectory = finfo.getSourceDirectory();
            if (!sourceDirectory.isDirectory() || excludeRootFiles.contains(sourceDirectory)) continue;
            List newfiles = FileUtils.getFiles((File)sourceDirectory, (String)including, (String)excluding);
            Iterator it2 = newfiles.iterator();
            while (it2.hasNext()) {
                files.put((File)it2.next(), finfo);
            }
        }
        return files;
    }

    private String getIncludes() {
        LinkedHashSet<String> patterns = new LinkedHashSet<String>();
        if (this.includes != null) {
            patterns.addAll(this.includes);
        }
        if (patterns.isEmpty()) {
            patterns.add("**/*.java");
        }
        return StringUtils.join(patterns.iterator(), (String)",");
    }

    private String getExcludes() {
        LinkedHashSet<String> patterns = new LinkedHashSet<String>(FileUtils.getDefaultExcludesAsList());
        if (this.excludes != null) {
            patterns.addAll(this.excludes);
        }
        return StringUtils.join(patterns.iterator(), (String)",");
    }

    protected boolean isHtml() {
        return "html".equals(this.format);
    }

    public boolean canGenerateReport() {
        if (this.aggregate && !this.project.isExecutionRoot()) {
            return false;
        }
        if ("pom".equals(this.project.getPackaging()) && !this.aggregate) {
            return false;
        }
        if ("xml".equals(this.format)) {
            return true;
        }
        try {
            Map<File, PmdFileInfo> filesToProcess = this.getFilesToProcess();
            if (filesToProcess.isEmpty()) {
                return false;
            }
        }
        catch (IOException e) {
            this.getLog().error((Throwable)e);
        }
        return true;
    }

    protected String getOutputDirectory() {
        return this.outputDirectory.getAbsolutePath();
    }

    protected String getSourceEncoding() {
        return this.sourceEncoding;
    }

    protected String getOutputEncoding() {
        return this.outputEncoding != null ? this.outputEncoding : "UTF-8";
    }

    static String getPmdVersion() {
        try {
            return (String)PMD.class.getField("VERSION").get(null);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("PMD VERSION field not accessible", e);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("PMD VERSION field not found", e);
        }
    }
}

