/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.javadoc;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Modifier;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang3.SystemUtils;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.javadoc.JavadocVersion;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Settings;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationOutputHandler;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.Invoker;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.apache.maven.shared.invoker.PrintStreamHandler;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.apache.maven.wagon.proxy.ProxyUtils;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class JavadocUtil {
    public static final int DEFAULT_TIMEOUT = 2000;
    protected static final String ERROR_INIT_VM = "Error occurred during initialization of VM, try to reduce the Java heap size for the MAVEN_OPTS environnement variable using -Xms:<size> and -Xmx:<size>.";

    public static List<String> pruneDirs(MavenProject project, List<String> dirs) {
        ArrayList<String> pruned = new ArrayList<String>(dirs.size());
        for (String dir : dirs) {
            if (dir == null) continue;
            File directory = new File(dir);
            if (!directory.isAbsolute()) {
                directory = new File(project.getBasedir(), directory.getPath());
            }
            if (!directory.isDirectory() || pruned.contains(directory.getAbsolutePath())) continue;
            pruned.add(directory.getAbsolutePath());
        }
        return pruned;
    }

    protected static List<String> pruneFiles(List<String> files) {
        ArrayList<String> pruned = new ArrayList<String>(files.size());
        for (String f : files) {
            if (JavadocUtil.shouldPruneFile(f, pruned)) continue;
            pruned.add(f);
        }
        return pruned;
    }

    public static boolean shouldPruneFile(String f, List<String> pruned) {
        File file;
        return f == null || !(file = new File(f)).isFile() || !JavadocUtil.isEmpty(pruned) && pruned.contains(f);
    }

    protected static List<String> getExcludedNames(List<String> sourcePaths, String[] subpackagesList, String[] excludedPackages) {
        ArrayList<String> excludedNames = new ArrayList<String>();
        for (String path : sourcePaths) {
            for (String aSubpackagesList : subpackagesList) {
                List<String> excludes = JavadocUtil.getExcludedPackages(path, excludedPackages);
                excludedNames.addAll(excludes);
            }
        }
        return excludedNames;
    }

    protected static String quotedArgument(String value) {
        String arg = value;
        if (StringUtils.isNotEmpty((String)arg)) {
            if (arg.contains("'")) {
                arg = StringUtils.replace((String)arg, (String)"'", (String)"\\'");
            }
            arg = "'" + arg + "'";
            arg = StringUtils.replace((String)arg, (String)"\n", (String)" ");
        }
        return arg;
    }

    protected static String quotedPathArgument(String value) {
        String path = value;
        if (StringUtils.isNotEmpty((String)path)) {
            if ((path = path.replace('\\', '/')).contains("'")) {
                String[] split = path.split("'");
                path = "";
                for (int i = 0; i < split.length; ++i) {
                    path = i != split.length - 1 ? path + split[i] + "\\'" : path + split[i];
                }
            }
            path = "'" + path + "'";
        }
        return path;
    }

    protected static void copyJavadocResources(File outputDirectory, File javadocDir, String excludedocfilessubdir) throws IOException {
        if (!javadocDir.isDirectory()) {
            return;
        }
        ArrayList<String> excludes = new ArrayList<String>();
        excludes.addAll(Arrays.asList(FileUtils.getDefaultExcludes()));
        if (StringUtils.isNotEmpty((String)excludedocfilessubdir)) {
            StringTokenizer st = new StringTokenizer(excludedocfilessubdir, ":");
            while (st.hasMoreTokens()) {
                String current = st.nextToken();
                excludes.add("**/" + current + "/**");
            }
        }
        List docFiles = FileUtils.getDirectoryNames((File)javadocDir, (String)"resources,**/doc-files", (String)StringUtils.join(excludes.iterator(), (String)","), (boolean)false, (boolean)true);
        for (String docFile : docFiles) {
            File docFileOutput = new File(outputDirectory, docFile);
            FileUtils.mkdir((String)docFileOutput.getAbsolutePath());
            FileUtils.copyDirectoryStructure((File)new File(javadocDir, docFile), (File)docFileOutput);
            List files = FileUtils.getFileAndDirectoryNames((File)docFileOutput, (String)StringUtils.join(excludes.iterator(), (String)","), null, (boolean)true, (boolean)true, (boolean)true, (boolean)true);
            for (String filename : files) {
                File file = new File(filename);
                if (file.isDirectory()) {
                    FileUtils.deleteDirectory((File)file);
                    continue;
                }
                file.delete();
            }
        }
    }

    protected static List<String> getIncludedFiles(File sourceDirectory, String[] fileList, String[] excludePackages) {
        ArrayList<String> files = new ArrayList<String>();
        for (String aFileList : fileList) {
            boolean include = true;
            for (int k = 0; k < excludePackages.length && include; ++k) {
                String[] excludeName = excludePackages[k].split("[*]");
                if (excludeName.length == 0) continue;
                if (excludeName.length > 1) {
                    for (int u = 0; include && u < excludeName.length; ++u) {
                        if ("".equals(excludeName[u].trim()) || !aFileList.contains(excludeName[u])) continue;
                        include = false;
                    }
                    continue;
                }
                if (!aFileList.startsWith(sourceDirectory.toString() + File.separatorChar + excludeName[0])) continue;
                if (excludeName[0].endsWith(String.valueOf(File.separatorChar))) {
                    File excludedPackage;
                    int i = aFileList.lastIndexOf(File.separatorChar);
                    String packageName = aFileList.substring(0, i + 1);
                    File currentPackage = new File(packageName);
                    if (currentPackage.equals(excludedPackage = new File(sourceDirectory, excludeName[0])) && aFileList.substring(i).contains(".java")) {
                        include = true;
                        continue;
                    }
                    include = false;
                    continue;
                }
                include = false;
            }
            if (!include) continue;
            files.add(JavadocUtil.quotedPathArgument(aFileList));
        }
        return files;
    }

    protected static List<String> getExcludedPackages(String sourceDirectory, String[] excludePackagenames) {
        ArrayList<String> files = new ArrayList<String>();
        for (String excludePackagename : excludePackagenames) {
            String[] fileList;
            for (String aFileList : fileList = FileUtils.getFilesFromExtension((String)sourceDirectory, (String[])new String[]{"java"})) {
                String[] excludeName = excludePackagename.split("[*]");
                for (int u = 0; u < excludeName.length; ++u) {
                    if ("".equals(excludeName[u].trim()) || !aFileList.contains(excludeName[u]) || sourceDirectory.contains(excludeName[u])) continue;
                    files.add(aFileList);
                }
            }
        }
        ArrayList<String> excluded = new ArrayList<String>();
        for (String file : files) {
            int idx = file.lastIndexOf(File.separatorChar);
            String tmpStr = file.substring(0, idx);
            String[] srcSplit = (tmpStr = tmpStr.replace('\\', '/')).split(Pattern.quote(sourceDirectory.replace('\\', '/') + '/'));
            String excludedPackage = srcSplit[1].replace('/', '.');
            if (excluded.contains(excludedPackage)) continue;
            excluded.add(excludedPackage);
        }
        return excluded;
    }

    protected static void addFilesFromSource(List<String> files, File sourceDirectory, List<String> sourceFileIncludes, List<String> sourceFileExcludes, String[] excludePackages) {
        DirectoryScanner ds = new DirectoryScanner();
        if (sourceFileIncludes == null) {
            sourceFileIncludes = Collections.singletonList("**/*.java");
        }
        ds.setIncludes(sourceFileIncludes.toArray(new String[sourceFileIncludes.size()]));
        if (sourceFileExcludes != null && sourceFileExcludes.size() > 0) {
            ds.setExcludes(sourceFileExcludes.toArray(new String[sourceFileExcludes.size()]));
        }
        ds.setBasedir(sourceDirectory);
        ds.scan();
        String[] fileList = ds.getIncludedFiles();
        String[] pathList = new String[fileList.length];
        for (int x = 0; x < fileList.length; ++x) {
            pathList[x] = new File(sourceDirectory, fileList[x]).getAbsolutePath();
        }
        if (pathList.length != 0) {
            List<String> tmpFiles = JavadocUtil.getIncludedFiles(sourceDirectory, pathList, excludePackages);
            files.addAll(tmpFiles);
        }
    }

    protected static JavadocVersion getJavadocVersion(File javadocExe) throws IOException, CommandLineException, IllegalArgumentException {
        if (javadocExe == null || !javadocExe.exists() || !javadocExe.isFile()) {
            throw new IOException("The javadoc executable '" + javadocExe + "' doesn't exist or is not a file. ");
        }
        Commandline cmd = new Commandline();
        cmd.setExecutable(javadocExe.getAbsolutePath());
        cmd.setWorkingDirectory(javadocExe.getParentFile());
        cmd.createArg().setValue("-J-version");
        CommandLineUtils.StringStreamConsumer out = new CommandLineUtils.StringStreamConsumer();
        CommandLineUtils.StringStreamConsumer err = new CommandLineUtils.StringStreamConsumer();
        int exitCode = CommandLineUtils.executeCommandLine((Commandline)cmd, (StreamConsumer)out, (StreamConsumer)err);
        if (exitCode != 0) {
            StringBuilder msg = new StringBuilder("Exit code: " + exitCode + " - " + err.getOutput());
            msg.append('\n');
            msg.append("Command line was:" + CommandLineUtils.toString((String[])cmd.getCommandline()));
            throw new CommandLineException(msg.toString());
        }
        if (StringUtils.isNotEmpty((String)err.getOutput())) {
            return JavadocVersion.parse(JavadocUtil.extractJavadocVersion(err.getOutput()));
        }
        if (StringUtils.isNotEmpty((String)out.getOutput())) {
            return JavadocVersion.parse(JavadocUtil.extractJavadocVersion(out.getOutput()));
        }
        throw new IllegalArgumentException("No output found from the command line 'javadoc -J-version'");
    }

    protected static String extractJavadocVersion(String output) throws IllegalArgumentException {
        if (StringUtils.isEmpty((String)output)) {
            throw new IllegalArgumentException("The output could not be null.");
        }
        Pattern pattern = Pattern.compile("(?s).*?[^a-zA-Z](([0-9]+\\.?[0-9]*)(\\.[0-9]+)?).*");
        Matcher matcher = pattern.matcher(output);
        if (!matcher.matches()) {
            throw new PatternSyntaxException("Unrecognized version of Javadoc: '" + output + "'", pattern.pattern(), pattern.toString().length() - 1);
        }
        return matcher.group(1);
    }

    protected static String parseJavadocMemory(String memory) throws IllegalArgumentException {
        if (StringUtils.isEmpty((String)memory)) {
            throw new IllegalArgumentException("The memory could not be null.");
        }
        Pattern p = Pattern.compile("^\\s*(\\d+)\\s*?\\s*$");
        Matcher m = p.matcher(memory);
        if (m.matches()) {
            return m.group(1) + "m";
        }
        p = Pattern.compile("^\\s*(\\d+)\\s*k(b)?\\s*$", 2);
        m = p.matcher(memory);
        if (m.matches()) {
            return m.group(1) + "k";
        }
        p = Pattern.compile("^\\s*(\\d+)\\s*m(b)?\\s*$", 2);
        m = p.matcher(memory);
        if (m.matches()) {
            return m.group(1) + "m";
        }
        p = Pattern.compile("^\\s*(\\d+)\\s*g(b)?\\s*$", 2);
        m = p.matcher(memory);
        if (m.matches()) {
            return Integer.parseInt(m.group(1)) * 1024 + "m";
        }
        p = Pattern.compile("^\\s*(\\d+)\\s*t(b)?\\s*$", 2);
        m = p.matcher(memory);
        if (m.matches()) {
            return Integer.parseInt(m.group(1)) * 1024 * 1024 + "m";
        }
        throw new IllegalArgumentException("Could convert not to a memory size: " + memory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean validateEncoding(String charsetName) {
        if (StringUtils.isEmpty((String)charsetName)) {
            return false;
        }
        ByteArrayOutputStream ost = new ByteArrayOutputStream();
        OutputStreamWriter osw = null;
        try {
            osw = new OutputStreamWriter((OutputStream)ost, charsetName);
            osw.close();
            osw = null;
        }
        catch (IOException exc) {
            boolean bl;
            try {
                bl = false;
            }
            catch (Throwable throwable) {
                IOUtil.close(osw);
                throw throwable;
            }
            IOUtil.close((Writer)osw);
            return bl;
        }
        IOUtil.close((Writer)osw);
        return true;
    }

    protected static String hideProxyPassword(String cmdLine, Settings settings) {
        if (cmdLine == null) {
            throw new IllegalArgumentException("cmdLine could not be null");
        }
        if (settings == null) {
            return cmdLine;
        }
        Proxy activeProxy = settings.getActiveProxy();
        if (activeProxy != null && StringUtils.isNotEmpty((String)activeProxy.getHost()) && StringUtils.isNotEmpty((String)activeProxy.getUsername()) && StringUtils.isNotEmpty((String)activeProxy.getPassword())) {
            String pass = "-J-Dhttp.proxyPassword=\"" + activeProxy.getPassword() + "\"";
            String hidepass = "-J-Dhttp.proxyPassword=\"" + StringUtils.repeat((String)"*", (int)activeProxy.getPassword().length()) + "\"";
            return StringUtils.replace((String)cmdLine, (String)pass, (String)hidepass);
        }
        return cmdLine;
    }

    protected static List<String> getTagletClassNames(File jarFile) throws IOException, ClassNotFoundException, NoClassDefFoundError {
        List<String> classes = JavadocUtil.getClassNamesFromJar(jarFile);
        File tools = new File(System.getProperty("java.home"), "../lib/tools.jar");
        URLClassLoader cl = tools.exists() && tools.isFile() ? new URLClassLoader(new URL[]{jarFile.toURI().toURL(), tools.toURI().toURL()}, null) : new URLClassLoader(new URL[]{jarFile.toURI().toURL()}, null);
        ArrayList<String> tagletClasses = new ArrayList<String>();
        Class<?> tagletClass = cl.loadClass("com.sun.tools.doclets.Taglet");
        for (String s : classes) {
            Class<?> c = cl.loadClass(s);
            if (!tagletClass.isAssignableFrom(c) || Modifier.isAbstract(c.getModifiers())) continue;
            tagletClasses.add(c.getName());
        }
        return tagletClasses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void copyResource(URL url, File file) throws IOException {
        if (file == null) {
            throw new IOException("The file can't be null.");
        }
        if (url == null) {
            throw new IOException("The url could not be null.");
        }
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        InputStream in = null;
        FileOutputStream out = null;
        try {
            in = url.openStream();
            if (in == null) {
                throw new IOException("The resource " + url + " doesn't exists.");
            }
            out = new FileOutputStream(file);
            IOUtil.copy((InputStream)in, (OutputStream)out);
            ((OutputStream)out).close();
            out = null;
            in.close();
            in = null;
        }
        catch (Throwable throwable) {
            IOUtil.close((InputStream)in);
            IOUtil.close(out);
            throw throwable;
        }
        IOUtil.close((InputStream)in);
        IOUtil.close((OutputStream)out);
    }

    protected static void invokeMaven(Log log, File localRepositoryDir, File projectFile, List<String> goals, Properties properties, File invokerLog) throws MavenInvocationException {
        String invokerLogContent;
        InvocationResult result;
        File javaHome;
        if (projectFile == null) {
            throw new IllegalArgumentException("projectFile should be not null.");
        }
        if (!projectFile.isFile()) {
            throw new IllegalArgumentException(projectFile.getAbsolutePath() + " is not a file.");
        }
        if (goals == null || goals.size() == 0) {
            throw new IllegalArgumentException("goals should be not empty.");
        }
        if (localRepositoryDir == null || !localRepositoryDir.isDirectory()) {
            throw new IllegalArgumentException("localRepositoryDir '" + localRepositoryDir + "' should be a directory.");
        }
        String mavenHome = JavadocUtil.getMavenHome(log);
        if (StringUtils.isEmpty((String)mavenHome)) {
            String msg = "Could NOT invoke Maven because no Maven Home is defined. You need to have set the M2_HOME system env variable or a maven.home Java system properties.";
            if (log != null) {
                log.error((CharSequence)msg);
            } else {
                System.err.println(msg);
            }
            return;
        }
        DefaultInvoker invoker = new DefaultInvoker();
        invoker.setMavenHome(new File(mavenHome));
        invoker.setLocalRepositoryDirectory(localRepositoryDir);
        DefaultInvocationRequest request = new DefaultInvocationRequest();
        request.setBaseDirectory(projectFile.getParentFile());
        request.setPomFile(projectFile);
        if (log != null) {
            request.setDebug(log.isDebugEnabled());
        } else {
            request.setDebug(true);
        }
        request.setGoals(goals);
        if (properties != null) {
            request.setProperties(properties);
        }
        if ((javaHome = JavadocUtil.getJavaHome(log)) != null) {
            request.setJavaHome(javaHome);
        }
        if (log != null && log.isDebugEnabled()) {
            log.debug((CharSequence)("Invoking Maven for the goals: " + goals + " with " + (properties == null ? "no properties" : "properties=" + properties)));
        }
        if ((result = JavadocUtil.invoke(log, (Invoker)invoker, (InvocationRequest)request, invokerLog, goals, properties, null)).getExitCode() != 0 && (invokerLogContent = JavadocUtil.readFile(invokerLog, "UTF-8")) != null && (!invokerLogContent.contains("Scanning for projects...") || invokerLogContent.contains(OutOfMemoryError.class.getName()))) {
            if (log != null) {
                log.error((CharSequence)"Error occurred during initialization of VM, trying to use an empty MAVEN_OPTS...");
                if (log.isDebugEnabled()) {
                    log.debug((CharSequence)("Reinvoking Maven for the goals: " + goals + " with an empty MAVEN_OPTS..."));
                }
            }
            result = JavadocUtil.invoke(log, (Invoker)invoker, (InvocationRequest)request, invokerLog, goals, properties, "");
        }
        if (result.getExitCode() != 0) {
            invokerLogContent = JavadocUtil.readFile(invokerLog, "UTF-8");
            if (invokerLogContent != null && (!invokerLogContent.contains("Scanning for projects...") || invokerLogContent.contains(OutOfMemoryError.class.getName()))) {
                throw new MavenInvocationException(ERROR_INIT_VM);
            }
            throw new MavenInvocationException("Error when invoking Maven, consult the invoker log file: " + invokerLog.getAbsolutePath());
        }
    }

    protected static String readFile(File javaFile, String encoding) {
        try {
            return FileUtils.fileRead((File)javaFile, (String)encoding);
        }
        catch (IOException e) {
            return null;
        }
    }

    protected static String[] splitPath(String path) {
        if (path == null) {
            return null;
        }
        ArrayList<String> subpaths = new ArrayList<String>();
        PathTokenizer pathTokenizer = new PathTokenizer(path);
        while (pathTokenizer.hasMoreTokens()) {
            subpaths.add(pathTokenizer.nextToken());
        }
        return subpaths.toArray(new String[subpaths.size()]);
    }

    protected static String unifyPathSeparator(String path) {
        if (path == null) {
            return null;
        }
        return StringUtils.join((Object[])JavadocUtil.splitPath(path), (String)File.pathSeparator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> getClassNamesFromJar(File jarFile) throws IOException {
        if (jarFile == null || !jarFile.exists() || !jarFile.isFile()) {
            throw new IOException("The jar '" + jarFile + "' doesn't exist or is not a file.");
        }
        ArrayList<String> classes = new ArrayList<String>();
        JarInputStream jarStream = null;
        try {
            jarStream = new JarInputStream(new FileInputStream(jarFile));
            JarEntry jarEntry = jarStream.getNextJarEntry();
            while (jarEntry != null) {
                if (jarEntry.getName().toLowerCase(Locale.ENGLISH).endsWith(".class")) {
                    String name = jarEntry.getName().substring(0, jarEntry.getName().indexOf("."));
                    classes.add(name.replaceAll("/", "\\."));
                }
                jarStream.closeEntry();
                jarEntry = jarStream.getNextJarEntry();
            }
            jarStream.close();
            jarStream = null;
        }
        catch (Throwable throwable) {
            IOUtil.close(jarStream);
            throw throwable;
        }
        IOUtil.close((InputStream)jarStream);
        return classes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InvocationResult invoke(Log log, Invoker invoker, InvocationRequest request, File invokerLog, List<String> goals, Properties properties, String mavenOpts) throws MavenInvocationException {
        PrintStream ps;
        FileOutputStream os = null;
        if (invokerLog != null) {
            if (log != null && log.isDebugEnabled()) {
                log.debug((CharSequence)("Using " + invokerLog.getAbsolutePath() + " to log the invoker"));
            }
            try {
                if (!invokerLog.exists()) {
                    invokerLog.getParentFile().mkdirs();
                }
                os = new FileOutputStream(invokerLog);
                ps = new PrintStream((OutputStream)os, true, "UTF-8");
            }
            catch (FileNotFoundException e) {
                if (log != null && log.isErrorEnabled()) {
                    log.error((CharSequence)("FileNotFoundException: " + e.getMessage() + ". Using System.out to log the invoker."));
                }
                ps = System.out;
            }
            catch (UnsupportedEncodingException e) {
                if (log != null && log.isErrorEnabled()) {
                    log.error((CharSequence)("UnsupportedEncodingException: " + e.getMessage() + ". Using System.out to log the invoker."));
                }
                ps = System.out;
            }
        } else {
            if (log != null && log.isDebugEnabled()) {
                log.debug((CharSequence)"Using System.out to log the invoker.");
            }
            ps = System.out;
        }
        if (mavenOpts != null) {
            request.setMavenOpts(mavenOpts);
        }
        PrintStreamHandler outputHandler = new PrintStreamHandler(ps, false);
        request.setOutputHandler((InvocationOutputHandler)outputHandler);
        outputHandler.consumeLine("Invoking Maven for the goals: " + goals + " with " + (properties == null ? "no properties" : "properties=" + properties));
        outputHandler.consumeLine("");
        outputHandler.consumeLine("M2_HOME=" + JavadocUtil.getMavenHome(log));
        outputHandler.consumeLine("MAVEN_OPTS=" + JavadocUtil.getMavenOpts(log));
        outputHandler.consumeLine("JAVA_HOME=" + JavadocUtil.getJavaHome(log));
        outputHandler.consumeLine("JAVA_OPTS=" + JavadocUtil.getJavaOpts(log));
        outputHandler.consumeLine("");
        try {
            InvocationResult invocationResult = invoker.execute(request);
            return invocationResult;
        }
        finally {
            IOUtil.close((OutputStream)os);
        }
    }

    private static String getMavenHome(Log log) {
        File m2Home;
        String mavenHome;
        block4: {
            mavenHome = System.getProperty("maven.home");
            if (mavenHome == null) {
                try {
                    mavenHome = CommandLineUtils.getSystemEnvVars().getProperty("M2_HOME");
                }
                catch (IOException e) {
                    if (log == null || !log.isDebugEnabled()) break block4;
                    log.debug((CharSequence)("IOException: " + e.getMessage()));
                }
            }
        }
        if (!(m2Home = new File(mavenHome)).exists() && log != null && log.isErrorEnabled()) {
            log.error((CharSequence)"Cannot find Maven application directory. Either specify 'maven.home' system property, or M2_HOME environment variable.");
        }
        return mavenHome;
    }

    private static String getMavenOpts(Log log) {
        String mavenOpts;
        block2: {
            mavenOpts = null;
            try {
                mavenOpts = CommandLineUtils.getSystemEnvVars().getProperty("MAVEN_OPTS");
            }
            catch (IOException e) {
                if (log == null || !log.isDebugEnabled()) break block2;
                log.debug((CharSequence)("IOException: " + e.getMessage()));
            }
        }
        return mavenOpts;
    }

    private static File getJavaHome(Log log) {
        File javaHome;
        block4: {
            javaHome = SystemUtils.IS_OS_MAC_OSX ? SystemUtils.getJavaHome() : new File(SystemUtils.getJavaHome(), "..");
            if (javaHome == null || !javaHome.exists()) {
                try {
                    javaHome = new File(CommandLineUtils.getSystemEnvVars().getProperty("JAVA_HOME"));
                }
                catch (IOException e) {
                    if (log == null || !log.isDebugEnabled()) break block4;
                    log.debug((CharSequence)("IOException: " + e.getMessage()));
                }
            }
        }
        if ((javaHome == null || !javaHome.exists()) && log != null && log.isErrorEnabled()) {
            log.error((CharSequence)"Cannot find Java application directory. Either specify 'java.home' system property, or JAVA_HOME environment variable.");
        }
        return javaHome;
    }

    private static String getJavaOpts(Log log) {
        String javaOpts;
        block2: {
            javaOpts = null;
            try {
                javaOpts = CommandLineUtils.getSystemEnvVars().getProperty("JAVA_OPTS");
            }
            catch (IOException e) {
                if (log == null || !log.isDebugEnabled()) break block2;
                log.debug((CharSequence)("IOException: " + e.getMessage()));
            }
        }
        return javaOpts;
    }

    static List<String> toList(String src) {
        return JavadocUtil.toList(src, null, null);
    }

    static List<String> toList(String src, String elementPrefix, String elementSuffix) {
        if (StringUtils.isEmpty((String)src)) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(src, "[,:;]");
        StringBuilder sb = new StringBuilder(256);
        while (st.hasMoreTokens()) {
            sb.setLength(0);
            if (StringUtils.isNotEmpty((String)elementPrefix)) {
                sb.append(elementPrefix);
            }
            sb.append(st.nextToken());
            if (StringUtils.isNotEmpty((String)elementSuffix)) {
                sb.append(elementSuffix);
            }
            result.add(sb.toString());
        }
        return result;
    }

    static <T> List<T> toList(T[] multiple) {
        return JavadocUtil.toList(null, multiple);
    }

    static <T> List<T> toList(T single, T[] multiple) {
        if (single == null && (multiple == null || multiple.length < 1)) {
            return null;
        }
        ArrayList<T> result = new ArrayList<T>();
        if (single != null) {
            result.add(single);
        }
        if (multiple != null && multiple.length > 0) {
            result.addAll(Arrays.asList(multiple));
        }
        return result;
    }

    public static String toRelative(File basedir, String absolutePath) {
        String relative;
        String basedirPath;
        if ((absolutePath = absolutePath.replace('\\', '/')).startsWith(basedirPath = basedir.getAbsolutePath().replace('\\', '/'))) {
            relative = absolutePath.substring(basedirPath.length());
            if (relative.startsWith("/")) {
                relative = relative.substring(1);
            }
            if (relative.length() <= 0) {
                relative = ".";
            }
        } else {
            relative = absolutePath;
        }
        return relative;
    }

    public static boolean isNotEmpty(Collection<?> collection) {
        return collection != null && !collection.isEmpty();
    }

    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static boolean isValidPackageList(URL url, Settings settings, boolean validateContent) throws IOException {
        boolean bl;
        HttpClient httpClient;
        HttpGet httpMethod;
        BufferedReader reader;
        block18: {
            boolean bl2;
            if (url == null) {
                throw new IllegalArgumentException("The url is null");
            }
            reader = null;
            httpMethod = null;
            httpClient = null;
            try {
                if ("file".equals(url.getProtocol())) {
                    reader = new BufferedReader(new InputStreamReader(url.openStream()));
                } else {
                    HttpResponse response;
                    httpClient = JavadocUtil.createHttpClient(settings, url);
                    httpMethod = new HttpGet(url.toString());
                    try {
                        response = httpClient.execute((HttpUriRequest)httpMethod);
                    }
                    catch (SocketTimeoutException e) {
                        response = httpClient.execute((HttpUriRequest)httpMethod);
                    }
                    int status = response.getStatusLine().getStatusCode();
                    if (status != 200) {
                        throw new FileNotFoundException("Unexpected HTTP status code " + status + " getting resource " + url.toExternalForm() + ".");
                    }
                    reader = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                }
                if (validateContent) {
                    String line = reader.readLine();
                    while (line != null) {
                        if (!JavadocUtil.isValidPackageName(line)) {
                            bl = false;
                            break block18;
                        }
                        line = reader.readLine();
                    }
                }
                reader.close();
                reader = null;
                bl2 = true;
            }
            catch (Throwable throwable) {
                IOUtil.close(reader);
                if (httpMethod != null) {
                    httpMethod.releaseConnection();
                }
                if (httpClient != null) {
                    httpClient.getConnectionManager().shutdown();
                }
                throw throwable;
            }
            IOUtil.close((Reader)reader);
            if (httpMethod != null) {
                httpMethod.releaseConnection();
            }
            if (httpClient != null) {
                httpClient.getConnectionManager().shutdown();
            }
            return bl2;
        }
        IOUtil.close((Reader)reader);
        if (httpMethod != null) {
            httpMethod.releaseConnection();
        }
        if (httpClient != null) {
            httpClient.getConnectionManager().shutdown();
        }
        return bl;
    }

    private static boolean isValidPackageName(String str) {
        int idx;
        if (StringUtils.isEmpty((String)str)) {
            return true;
        }
        while ((idx = str.indexOf(46)) != -1) {
            if (!JavadocUtil.isValidClassName(str.substring(0, idx))) {
                return false;
            }
            str = str.substring(idx + 1);
        }
        return JavadocUtil.isValidClassName(str);
    }

    private static boolean isValidClassName(String str) {
        if (StringUtils.isEmpty((String)str) || !Character.isJavaIdentifierStart(str.charAt(0))) {
            return false;
        }
        for (int i = str.length() - 1; i > 0; --i) {
            if (Character.isJavaIdentifierPart(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static HttpClient createHttpClient(Settings settings, URL url) {
        DefaultHttpClient httpClient = new DefaultHttpClient((ClientConnectionManager)new PoolingClientConnectionManager());
        httpClient.getParams().setIntParameter("http.socket.timeout", 2000);
        httpClient.getParams().setIntParameter("http.connection.timeout", 2000);
        httpClient.getParams().setBooleanParameter("http.protocol.allow-circular-redirects", true);
        httpClient.getParams().setParameter("http.useragent", (Object)"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.0)");
        if (settings != null && settings.getActiveProxy() != null) {
            Proxy activeProxy = settings.getActiveProxy();
            ProxyInfo proxyInfo = new ProxyInfo();
            proxyInfo.setNonProxyHosts(activeProxy.getNonProxyHosts());
            if (StringUtils.isNotEmpty((String)activeProxy.getHost()) && (url == null || !ProxyUtils.validateNonProxyHosts((ProxyInfo)proxyInfo, (String)url.getHost()))) {
                HttpHost proxy = new HttpHost(activeProxy.getHost(), activeProxy.getPort());
                httpClient.getParams().setParameter("http.route.default-proxy", (Object)proxy);
                if (StringUtils.isNotEmpty((String)activeProxy.getUsername()) && activeProxy.getPassword() != null) {
                    UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(activeProxy.getUsername(), activeProxy.getPassword());
                    httpClient.getCredentialsProvider().setCredentials(AuthScope.ANY, (Credentials)credentials);
                }
            }
        }
        return httpClient;
    }

    static boolean equalsIgnoreCase(String value, String ... strings) {
        for (String s : strings) {
            if (!s.equalsIgnoreCase(value)) continue;
            return true;
        }
        return false;
    }

    static boolean equals(String value, String ... strings) {
        for (String s : strings) {
            if (!s.equals(value)) continue;
            return true;
        }
        return false;
    }

    private static class PathTokenizer {
        private StringTokenizer tokenizer;
        private String lookahead = null;
        private boolean onNetWare = Os.isFamily((String)"netware");
        private boolean dosStyleFilesystem;

        public PathTokenizer(String path) {
            this.tokenizer = this.onNetWare ? new StringTokenizer(path, ":;", true) : new StringTokenizer(path, ":;", false);
            this.dosStyleFilesystem = File.pathSeparatorChar == ';';
        }

        public boolean hasMoreTokens() {
            return this.lookahead != null || this.tokenizer.hasMoreTokens();
        }

        public String nextToken() throws NoSuchElementException {
            String token;
            if (this.lookahead != null) {
                token = this.lookahead;
                this.lookahead = null;
            } else {
                token = this.tokenizer.nextToken().trim();
            }
            if (!this.onNetWare) {
                if (token.length() == 1 && Character.isLetter(token.charAt(0)) && this.dosStyleFilesystem && this.tokenizer.hasMoreTokens()) {
                    String nextToken = this.tokenizer.nextToken().trim();
                    if (nextToken.startsWith("\\") || nextToken.startsWith("/")) {
                        token = token + ":" + nextToken;
                    } else {
                        this.lookahead = nextToken;
                    }
                }
            } else {
                String nextToken;
                if (token.equals(File.pathSeparator) || token.equals(":")) {
                    token = this.tokenizer.nextToken().trim();
                }
                if (this.tokenizer.hasMoreTokens() && !(nextToken = this.tokenizer.nextToken().trim()).equals(File.pathSeparator)) {
                    if (nextToken.equals(":")) {
                        if (!(token.startsWith("/") || token.startsWith("\\") || token.startsWith(".") || token.startsWith(".."))) {
                            String oneMore = this.tokenizer.nextToken().trim();
                            if (!oneMore.equals(File.pathSeparator)) {
                                token = token + ":" + oneMore;
                            } else {
                                token = token + ":";
                                this.lookahead = oneMore;
                            }
                        }
                    } else {
                        this.lookahead = nextToken;
                    }
                }
            }
            return token;
        }
    }
}

