/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.invoker;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.invoker.BeanShellScriptInterpreter;
import org.apache.maven.plugin.invoker.BuildFailureException;
import org.apache.maven.plugin.invoker.CompositeMap;
import org.apache.maven.plugin.invoker.FileLogger;
import org.apache.maven.plugin.invoker.GroovyScriptInterpreter;
import org.apache.maven.plugin.invoker.InvokerProperties;
import org.apache.maven.plugin.invoker.ScriptEvaluationException;
import org.apache.maven.plugin.invoker.ScriptInterpreter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.apache.maven.shared.invoker.CommandLineConfigurationException;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.InvocationOutputHandler;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.Invoker;
import org.apache.maven.shared.invoker.MavenCommandLineBuilder;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.maven.shared.model.fileset.util.FileSetManager;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.interpolation.MapBasedValueSource;
import org.codehaus.plexus.interpolation.RegexBasedInterpolator;
import org.codehaus.plexus.interpolation.ValueSource;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.InterpolationFilterReader;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.XmlStreamWriter;

public class InvokerMojo
extends AbstractMojo {
    private boolean skipInvocation;
    private boolean suppressSummaries;
    private boolean streamLogs;
    private File localRepositoryPath;
    private File projectsDirectory;
    private File cloneProjectsTo;
    private boolean cloneAllFiles;
    private File pom;
    private List pomIncludes = Collections.singletonList("*/pom.xml");
    private List pomExcludes = Collections.EMPTY_LIST;
    private List setupIncludes = Collections.singletonList("setup*/pom.xml");
    private List goals = Collections.singletonList("package");
    private String goalsFile;
    private Invoker invoker;
    private String preBuildHookScript;
    private String postBuildHookScript;
    private String testPropertiesFile;
    private Properties testProperties;
    private Map properties;
    private boolean showErrors;
    private boolean debug;
    private boolean noLog;
    private List profiles;
    private Properties interpolationsProperties;
    private Map filterProperties;
    private MavenProject project;
    private String invokerTest;
    private String profilesFile;
    private File settingsFile;
    private String mavenOpts;
    private File mavenHome;
    private File javaHome;
    private String encoding;
    private Settings settings;
    private boolean addTestClassPath;
    private List testClassPath;
    private String invokerPropertiesFile;
    private boolean ignoreFailures;
    private Map scriptInterpreters;
    private String filteredPomPrefix = "interpolated-";

    /*
     * WARNING - void declaration
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        void var1_4;
        String[] includedPoms;
        if (this.skipInvocation) {
            this.getLog().info((CharSequence)"Skipping invocation per configuration. If this is incorrect, ensure the skipInvocation parameter is not set to true.");
            return;
        }
        if (this.pom != null) {
            try {
                this.projectsDirectory = this.pom.getCanonicalFile().getParentFile();
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to discover projectsDirectory from pom File parameter. Reason: " + e.getMessage(), (Exception)e);
            }
            includedPoms = new String[]{this.pom.getName()};
        } else {
            try {
                includedPoms = this.getPoms();
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error retrieving POM list from includes, excludes, and projects directory. Reason: " + e.getMessage(), (Exception)e);
            }
        }
        if (var1_4 == null || ((void)var1_4).length < 1) {
            this.getLog().info((CharSequence)"No test projects were selected for execution.");
            return;
        }
        if (StringUtils.isEmpty((String)this.encoding)) {
            this.getLog().warn((CharSequence)("File encoding has not been set, using platform encoding " + ReaderFactory.FILE_ENCODING + ", i.e. build is platform dependent!"));
        }
        this.scriptInterpreters = new LinkedHashMap();
        this.scriptInterpreters.put("bsh", new BeanShellScriptInterpreter());
        this.scriptInterpreters.put("groovy", new GroovyScriptInterpreter());
        LinkedHashSet collectedProjects = new LinkedHashSet();
        for (int i = 0; i < ((void)var1_4).length; ++i) {
            this.collectProjects(this.projectsDirectory, (String)var1_4[i], collectedProjects, true);
        }
        File projectsDir = this.projectsDirectory;
        if (this.cloneProjectsTo != null) {
            this.cloneProjects(collectedProjects);
            projectsDir = this.cloneProjectsTo;
        } else {
            this.getLog().warn((CharSequence)"Filtering of parent/child POMs is not supported without cloning the projects");
        }
        List failures = this.runBuilds(projectsDir, (String[])var1_4);
        if (!this.suppressSummaries) {
            this.getLog().info((CharSequence)"---------------------------------------");
            this.getLog().info((CharSequence)"Execution Summary:");
            this.getLog().info((CharSequence)("  Builds Passing: " + (((void)var1_4).length - failures.size())));
            this.getLog().info((CharSequence)("  Builds Failing: " + failures.size()));
            this.getLog().info((CharSequence)"---------------------------------------");
            if (!failures.isEmpty()) {
                String heading = "The following builds failed:";
                if (this.ignoreFailures) {
                    this.getLog().warn((CharSequence)heading);
                } else {
                    this.getLog().error((CharSequence)heading);
                }
                Iterator it = failures.iterator();
                while (it.hasNext()) {
                    String item = "*  " + (String)it.next();
                    if (this.ignoreFailures) {
                        this.getLog().warn((CharSequence)item);
                        continue;
                    }
                    this.getLog().error((CharSequence)item);
                }
                this.getLog().info((CharSequence)"---------------------------------------");
            }
        }
        if (!failures.isEmpty()) {
            String message = failures.size() + " build" + (failures.size() == 1 ? "" : "s") + " failed.";
            if (this.ignoreFailures) {
                this.getLog().warn((CharSequence)("Ignoring that " + message));
            } else {
                throw new MojoFailureException((Object)this, message, message);
            }
        }
    }

    private Reader newReader(File file) throws IOException {
        if (StringUtils.isNotEmpty((String)this.encoding)) {
            return ReaderFactory.newReader((File)file, (String)this.encoding);
        }
        return ReaderFactory.newPlatformReader((File)file);
    }

    private void collectProjects(File projectsDir, String projectPath, Collection projectPaths, boolean included) throws MojoExecutionException {
        Model model;
        File pomFile = new File(projectsDir, projectPath = projectPath.replace('\\', '/'));
        if (pomFile.isDirectory()) {
            if (!(pomFile = new File(pomFile, "pom.xml")).exists()) {
                if (included) {
                    projectPaths.add(projectPath);
                }
                return;
            }
            if (!projectPath.endsWith("/")) {
                projectPath = projectPath + '/';
            }
            projectPath = projectPath + "pom.xml";
        } else if (!pomFile.isFile()) {
            return;
        }
        if (!projectPaths.add(projectPath)) {
            return;
        }
        this.getLog().debug((CharSequence)("Collecting parent/child projects of " + projectPath));
        XmlStreamReader reader = null;
        try {
            reader = ReaderFactory.newXmlReader((File)pomFile);
            model = new MavenXpp3Reader().read((Reader)reader);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to parse POM: " + pomFile, e);
        }
        finally {
            IOUtil.close((Reader)reader);
        }
        try {
            String parent;
            String projectsRoot = projectsDir.getCanonicalPath();
            String projectDir = pomFile.getParent();
            String parentPath = "../pom.xml";
            if (model.getParent() != null && StringUtils.isNotEmpty((String)model.getParent().getRelativePath())) {
                parentPath = model.getParent().getRelativePath();
            }
            if ((parent = this.relativizePath(new File(projectDir, parentPath), projectsRoot)) != null) {
                this.collectProjects(projectsDir, parent, projectPaths, false);
            }
            if (model.getModules() != null) {
                Iterator it = model.getModules().iterator();
                while (it.hasNext()) {
                    String modulePath = (String)it.next();
                    String module = this.relativizePath(new File(projectDir, modulePath), projectsRoot);
                    if (module == null) continue;
                    this.collectProjects(projectsDir, module, projectPaths, false);
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to analyze POM: " + pomFile, (Exception)e);
        }
    }

    private void cloneProjects(Collection projectPaths) throws MojoExecutionException {
        this.cloneProjectsTo.mkdirs();
        LinkedHashSet<String> dirs = new LinkedHashSet<String>();
        Iterator it = projectPaths.iterator();
        while (it.hasNext()) {
            String projectPath = (String)it.next();
            if (!new File(this.projectsDirectory, projectPath).isDirectory()) {
                projectPath = this.getParentPath(projectPath);
            }
            dirs.add(projectPath);
        }
        boolean filter = false;
        try {
            filter = !this.cloneProjectsTo.getCanonicalFile().equals(this.projectsDirectory.getCanonicalFile());
            ArrayList<String> clonedSubpaths = new ArrayList<String>();
            Iterator it2 = dirs.iterator();
            while (it2.hasNext()) {
                String subpath = (String)it2.next();
                if (!".".equals(subpath) && dirs.contains(this.getParentPath(subpath)) || InvokerMojo.alreadyCloned(subpath, clonedSubpaths)) continue;
                if (".".equals(subpath)) {
                    String cloneSubdir = this.relativizePath(this.cloneProjectsTo, this.projectsDirectory.getCanonicalPath());
                    if (cloneSubdir != null) {
                        File temp = File.createTempFile("pre-invocation-clone.", "");
                        temp.delete();
                        temp.mkdirs();
                        this.copyDirectoryStructure(this.projectsDirectory, temp);
                        FileUtils.deleteDirectory((File)new File(temp, cloneSubdir));
                        this.copyDirectoryStructure(temp, this.cloneProjectsTo);
                    } else {
                        this.copyDirectoryStructure(this.projectsDirectory, this.cloneProjectsTo);
                    }
                } else {
                    File srcDir = new File(this.projectsDirectory, subpath);
                    File dstDir = new File(this.cloneProjectsTo, subpath);
                    this.copyDirectoryStructure(srcDir, dstDir);
                }
                clonedSubpaths.add(subpath);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to clone projects from: " + this.projectsDirectory + " to: " + this.cloneProjectsTo + ". Reason: " + e.getMessage(), (Exception)e);
        }
        if (filter) {
            Iterator it3 = projectPaths.iterator();
            while (it3.hasNext()) {
                String projectPath = (String)it3.next();
                File pomFile = new File(this.cloneProjectsTo, projectPath);
                if (!pomFile.isFile()) continue;
                this.buildInterpolatedFile(pomFile, pomFile);
            }
            this.filteredPomPrefix = null;
        }
    }

    private String getParentPath(String path) {
        int lastSep = Math.max(path.lastIndexOf(47), path.lastIndexOf(92));
        return lastSep < 0 ? "." : path.substring(0, lastSep);
    }

    private void copyDirectoryStructure(File sourceDir, File destDir) throws IOException {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(sourceDir);
        if (!this.cloneAllFiles) {
            scanner.addDefaultExcludes();
        }
        scanner.scan();
        destDir.mkdirs();
        String[] includedDirs = scanner.getIncludedDirectories();
        for (int i = 0; i < includedDirs.length; ++i) {
            File clonedDir = new File(destDir, includedDirs[i]);
            clonedDir.mkdirs();
        }
        String[] includedFiles = scanner.getIncludedFiles();
        for (int i = 0; i < includedFiles.length; ++i) {
            File sourceFile = new File(sourceDir, includedFiles[i]);
            File destFile = new File(destDir, includedFiles[i]);
            FileUtils.copyFile((File)sourceFile, (File)destFile);
        }
    }

    static boolean alreadyCloned(String subpath, List clonedSubpaths) {
        Iterator iter = clonedSubpaths.iterator();
        while (iter.hasNext()) {
            String path = (String)iter.next();
            if (!".".equals(path) && !subpath.equals(path) && !subpath.startsWith(path + File.separator)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List runBuilds(File projectsDir, String[] projects) throws MojoExecutionException {
        ArrayList<String> failures;
        block8: {
            failures = new ArrayList<String>();
            if (!this.localRepositoryPath.exists()) {
                this.localRepositoryPath.mkdirs();
            }
            File interpolatedSettingsFile = null;
            if (this.settingsFile != null) {
                interpolatedSettingsFile = this.cloneProjectsTo != null ? new File(this.cloneProjectsTo, "interpolated-" + this.settingsFile.getName()) : new File(this.settingsFile.getParentFile(), "interpolated-" + this.settingsFile.getName());
                this.buildInterpolatedFile(this.settingsFile, interpolatedSettingsFile);
            }
            try {
                for (int i = 0; i < projects.length; ++i) {
                    String project = projects[i];
                    try {
                        this.runBuild(projectsDir, project, interpolatedSettingsFile);
                        continue;
                    }
                    catch (BuildFailureException e) {
                        failures.add(project);
                    }
                }
                Object var9_8 = null;
                if (interpolatedSettingsFile == null || this.cloneProjectsTo != null) break block8;
                interpolatedSettingsFile.delete();
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                if (interpolatedSettingsFile != null && this.cloneProjectsTo == null) {
                    interpolatedSettingsFile.delete();
                }
                throw throwable;
            }
            {
            }
        }
        return failures;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void runBuild(File projectsDir, String project, File settingsFile) throws MojoExecutionException, BuildFailureException {
        File basedir;
        File pomFile = new File(projectsDir, project);
        if (pomFile.isDirectory()) {
            basedir = pomFile;
            if (!(pomFile = new File(basedir, "pom.xml")).exists()) {
                pomFile = null;
            } else {
                project = project + File.separator + "pom.xml";
            }
        } else {
            basedir = pomFile.getParentFile();
        }
        this.getLog().info((CharSequence)("Building: " + project));
        File interpolatedPomFile = null;
        if (pomFile != null) {
            if (this.filteredPomPrefix != null) {
                interpolatedPomFile = new File(basedir, this.filteredPomPrefix + pomFile.getName());
                this.buildInterpolatedFile(pomFile, interpolatedPomFile);
            } else {
                interpolatedPomFile = pomFile;
            }
        }
        try {
            block12: {
                try {
                    this.runBuild(basedir, interpolatedPomFile, settingsFile);
                    if (this.suppressSummaries) break block12;
                    this.getLog().info((CharSequence)"...SUCCESS.");
                }
                catch (BuildFailureException e) {
                    if (this.suppressSummaries) throw e;
                    this.getLog().info((CharSequence)("...FAILED. " + e.getMessage()));
                    throw e;
                }
            }
            Object var9_7 = null;
            if (interpolatedPomFile == null) return;
            if (!StringUtils.isNotEmpty((String)this.filteredPomPrefix)) return;
            interpolatedPomFile.delete();
            return;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            if (interpolatedPomFile == null) throw throwable;
            if (!StringUtils.isNotEmpty((String)this.filteredPomPrefix)) throw throwable;
            interpolatedPomFile.delete();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runBuild(File basedir, File pomFile, File settingsFile) throws MojoExecutionException, BuildFailureException {
        InvokerProperties invokerProperties = this.getInvokerProperties(basedir);
        if (this.getLog().isDebugEnabled() && !invokerProperties.getProperties().isEmpty()) {
            Properties props = invokerProperties.getProperties();
            this.getLog().debug((CharSequence)"Using invoker properties:");
            Iterator<Object> it = new TreeSet<Object>(props.keySet()).iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                String value = props.getProperty(key);
                this.getLog().debug((CharSequence)("  " + key + " = " + value));
            }
        }
        List goals = this.getGoals(basedir);
        List profiles = this.getProfiles(basedir);
        Properties systemProperties = this.getTestProperties(basedir);
        FileLogger logger = this.setupLogger(basedir);
        try {
            this.runScript("pre-build script", basedir, this.preBuildHookScript, logger);
            DefaultInvocationRequest request = new DefaultInvocationRequest();
            request.setLocalRepositoryDirectory(this.localRepositoryPath);
            request.setUserSettingsFile(settingsFile);
            request.setProperties(systemProperties);
            request.setInteractive(false);
            request.setShowErrors(this.showErrors);
            request.setDebug(this.debug);
            if (logger != null) {
                request.setErrorHandler((InvocationOutputHandler)logger);
                request.setOutputHandler((InvocationOutputHandler)logger);
            }
            request.setBaseDirectory(basedir);
            if (pomFile != null) {
                request.setPomFile(pomFile);
            }
            if (this.mavenHome != null) {
                this.invoker.setMavenHome(this.mavenHome);
                request.addShellEnvironment("M2_HOME", this.mavenHome.getAbsolutePath());
            }
            if (this.javaHome != null) {
                request.setJavaHome(this.javaHome);
            }
            for (int invocationIndex = 1; invocationIndex <= 1 || invokerProperties.isInvocationDefined(invocationIndex); ++invocationIndex) {
                InvocationResult result;
                request.setGoals(goals);
                request.setProfiles(profiles);
                request.setMavenOpts(this.mavenOpts);
                invokerProperties.configureInvocation((InvocationRequest)request, invocationIndex);
                try {
                    this.getLog().debug((CharSequence)("Using MAVEN_OPTS: " + request.getMavenOpts()));
                    this.getLog().debug((CharSequence)("Executing: " + new MavenCommandLineBuilder().build((InvocationRequest)request)));
                }
                catch (CommandLineConfigurationException e) {
                    this.getLog().debug((CharSequence)("Failed to display command line: " + e.getMessage()));
                }
                try {
                    result = this.invoker.execute((InvocationRequest)request);
                }
                catch (MavenInvocationException e) {
                    this.getLog().debug((CharSequence)("Error invoking Maven: " + e.getMessage()), (Throwable)e);
                    throw new BuildFailureException("Maven invocation failed. " + e.getMessage());
                }
                this.verify(result, invocationIndex, invokerProperties, logger);
            }
            this.runScript("post-build script", basedir, this.postBuildHookScript, logger);
        }
        finally {
            if (logger != null) {
                logger.close();
            }
        }
    }

    private FileLogger setupLogger(File basedir) throws MojoExecutionException {
        FileLogger logger = null;
        if (!this.noLog) {
            File outputLog = new File(basedir, "build.log");
            try {
                logger = this.streamLogs ? new FileLogger(outputLog, this.getLog()) : new FileLogger(outputLog);
                this.getLog().debug((CharSequence)("build log initialized in: " + outputLog));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error initializing build logfile in: " + outputLog, (Exception)e);
            }
        }
        return logger;
    }

    private Properties getTestProperties(File basedir) throws MojoExecutionException {
        File testProperties;
        Properties collectedTestProperties = new Properties();
        if (this.testProperties != null) {
            collectedTestProperties.putAll((Map<?, ?>)this.testProperties);
        }
        if (this.properties != null) {
            collectedTestProperties.putAll((Map<?, ?>)this.properties);
        }
        if (this.testPropertiesFile != null && (testProperties = new File(basedir, this.testPropertiesFile)).exists()) {
            FileInputStream fin = null;
            try {
                fin = new FileInputStream(testProperties);
                Properties loadedProperties = new Properties();
                loadedProperties.load(fin);
                collectedTestProperties.putAll((Map<?, ?>)loadedProperties);
            }
            catch (IOException e) {
                try {
                    throw new MojoExecutionException("Error reading system properties for test: " + this.testPropertiesFile);
                }
                catch (Throwable throwable) {
                    IOUtil.close(fin);
                    throw throwable;
                }
            }
            IOUtil.close((InputStream)fin);
        }
        return collectedTestProperties;
    }

    private void verify(InvocationResult result, int invocationIndex, InvokerProperties invokerProperties, FileLogger logger) throws BuildFailureException {
        if (result.getExecutionException() != null) {
            throw new BuildFailureException("The Maven invocation failed. " + result.getExecutionException().getMessage());
        }
        if (!invokerProperties.isExpectedResult(result.getExitCode(), invocationIndex)) {
            StringBuffer buffer = new StringBuffer(256);
            buffer.append("The build exited with code ").append(result.getExitCode()).append(". ");
            if (logger != null) {
                buffer.append("See ");
                buffer.append(logger.getOutputFile().getAbsolutePath());
                buffer.append(" for details.");
            } else {
                buffer.append("See console output for details.");
            }
            throw new BuildFailureException(buffer.toString());
        }
    }

    private void runScript(String scriptDescription, File basedir, String relativeScriptPath, FileLogger logger) throws MojoExecutionException, BuildFailureException {
        if (relativeScriptPath == null) {
            return;
        }
        File scriptFile = this.resolveScript(new File(basedir, relativeScriptPath));
        if (scriptFile.exists()) {
            Object result;
            String script;
            List classPath = this.addTestClassPath ? this.testClassPath : Collections.EMPTY_LIST;
            HashMap<String, File> globalVariables = new HashMap<String, File>();
            globalVariables.put("basedir", basedir);
            globalVariables.put("localRepositoryPath", this.localRepositoryPath);
            PrintStream out = logger != null ? logger.getPrintStream() : null;
            ScriptInterpreter interpreter = this.getInterpreter(scriptFile);
            if (this.getLog().isDebugEnabled()) {
                String name = interpreter.getClass().getName();
                name = name.substring(name.lastIndexOf(46) + 1);
                this.getLog().debug((CharSequence)("Running script with " + name + ": " + scriptFile));
            }
            try {
                script = FileUtils.fileRead((File)scriptFile, (String)this.encoding);
            }
            catch (IOException e) {
                String errorMessage = "error reading " + scriptDescription + " " + scriptFile.getPath() + ", " + e.getMessage();
                throw new MojoExecutionException(errorMessage, (Exception)e);
            }
            try {
                if (logger != null) {
                    logger.consumeLine("Running " + scriptDescription + " in: " + scriptFile);
                }
                result = interpreter.evaluateScript(script, classPath, globalVariables, out);
                if (logger != null) {
                    logger.consumeLine("Finished " + scriptDescription + " in: " + scriptFile);
                }
            }
            catch (ScriptEvaluationException e) {
                Throwable t = e.getCause() != null ? e.getCause() : e;
                String errorMessage = "error evaluating " + scriptDescription + " " + scriptFile.getPath() + ", " + t.getMessage();
                this.getLog().debug((CharSequence)errorMessage, t);
                if (logger != null) {
                    t.printStackTrace(logger.getPrintStream());
                }
                throw new BuildFailureException("The " + scriptDescription + " did not succeed. " + t.getMessage());
            }
            if (!Boolean.TRUE.equals(result) && !"true".equals(result)) {
                throw new BuildFailureException("The " + scriptDescription + " returned " + result + ".");
            }
        }
    }

    private File resolveScript(File scriptFile) {
        if (scriptFile != null && !scriptFile.exists()) {
            Iterator it = this.scriptInterpreters.keySet().iterator();
            while (it.hasNext()) {
                String ext = (String)it.next();
                File candidateFile = new File(scriptFile.getPath() + '.' + ext);
                if (!candidateFile.exists()) continue;
                scriptFile = candidateFile;
                break;
            }
        }
        return scriptFile;
    }

    private ScriptInterpreter getInterpreter(File scriptFile) {
        String ext = FileUtils.extension((String)scriptFile.getName()).toLowerCase(Locale.ENGLISH);
        ScriptInterpreter interpreter = (ScriptInterpreter)this.scriptInterpreters.get(ext);
        if (interpreter == null) {
            interpreter = (ScriptInterpreter)this.scriptInterpreters.get("bsh");
        }
        return interpreter;
    }

    List getGoals(File basedir) throws MojoExecutionException {
        try {
            return this.getTokens(basedir, this.goalsFile, this.goals);
        }
        catch (IOException e) {
            throw new MojoExecutionException("error reading goals", (Exception)e);
        }
    }

    List getProfiles(File basedir) throws MojoExecutionException {
        try {
            return this.getTokens(basedir, this.profilesFile, this.profiles);
        }
        catch (IOException e) {
            throw new MojoExecutionException("error reading profiles", (Exception)e);
        }
    }

    String[] getPoms() throws IOException {
        String[] poms;
        if (this.pom != null && this.pom.exists()) {
            poms = new String[]{this.pom.getAbsolutePath()};
        } else if (this.invokerTest != null) {
            String[] testRegexes = StringUtils.split((String)this.invokerTest, (String)",");
            ArrayList<String> includes = new ArrayList<String>(testRegexes.length);
            int size = testRegexes.length;
            for (int i = 0; i < size; ++i) {
                includes.add(testRegexes[i]);
            }
            poms = this.scanProjectsDirectory(includes, null);
        } else {
            String exclude;
            ArrayList<String> excludes;
            ArrayList<String> arrayList = excludes = this.pomExcludes != null ? new ArrayList<String>(this.pomExcludes) : new ArrayList();
            if (this.settingsFile != null && (exclude = this.relativizePath(this.settingsFile, this.projectsDirectory.getCanonicalPath())) != null) {
                excludes.add(exclude.replace('\\', '/'));
                this.getLog().debug((CharSequence)("Automatically excluded " + exclude + " from project scanning"));
            }
            String[] setupPoms = this.scanProjectsDirectory(this.setupIncludes, excludes);
            excludes.addAll(this.setupIncludes);
            String[] normalPoms = this.scanProjectsDirectory(this.pomIncludes, excludes);
            poms = new String[setupPoms.length + normalPoms.length];
            System.arraycopy(setupPoms, 0, poms, 0, setupPoms.length);
            System.arraycopy(normalPoms, 0, poms, setupPoms.length, normalPoms.length);
        }
        poms = this.relativizeProjectPaths(poms);
        return poms;
    }

    private String[] scanProjectsDirectory(List includes, List excludes) throws IOException {
        FileSet fs = new FileSet();
        fs.setIncludes(includes);
        fs.setExcludes(excludes);
        fs.setDirectory(this.projectsDirectory.getCanonicalPath());
        fs.setFollowSymlinks(false);
        fs.setUseDefaultExcludes(true);
        FileSetManager fsm = new FileSetManager(this.getLog());
        ArrayList<String> included = new ArrayList<String>();
        included.addAll(Arrays.asList(fsm.getIncludedFiles(fs)));
        included.addAll(Arrays.asList(fsm.getIncludedDirectories(fs)));
        return included.toArray(new String[included.size()]);
    }

    private String[] relativizeProjectPaths(String[] projectPaths) throws IOException {
        String projectsDirPath = this.projectsDirectory.getCanonicalPath();
        String[] results = new String[projectPaths.length];
        for (int i = 0; i < projectPaths.length; ++i) {
            String relativizedPath;
            String projectPath = projectPaths[i];
            File file = new File(projectPath);
            if (!file.isAbsolute()) {
                file = new File(this.projectsDirectory, projectPath);
            }
            if ((relativizedPath = this.relativizePath(file, projectsDirPath)) == null) {
                relativizedPath = projectPath;
            }
            results[i] = relativizedPath;
        }
        return results;
    }

    private String relativizePath(File path, String basedir) throws IOException {
        String relativizedPath = path.getCanonicalPath();
        if (relativizedPath.startsWith(basedir)) {
            if ((relativizedPath = relativizedPath.substring(basedir.length())).startsWith(File.separator)) {
                relativizedPath = relativizedPath.substring(File.separator.length());
            }
            return relativizedPath;
        }
        return null;
    }

    private Map getInterpolationValueSource() {
        HashMap<Object, Object> props = new HashMap<Object, Object>();
        if (this.interpolationsProperties != null) {
            props.putAll(this.interpolationsProperties);
        }
        if (this.filterProperties != null) {
            props.putAll(this.filterProperties);
        }
        if (this.settings.getLocalRepository() != null) {
            props.put("localRepository", this.settings.getLocalRepository());
            String url = this.settings.getLocalRepository();
            if (!url.startsWith("/")) {
                url = '/' + url;
            }
            url = "file://" + url.replace('\\', '/');
            props.put("localRepositoryUrl", url);
        }
        return new CompositeMap(this.project, props);
    }

    private List getTokens(File basedir, String filename, List defaultTokens) throws IOException {
        File tokenFile;
        List tokens;
        List list = tokens = defaultTokens != null ? defaultTokens : new ArrayList();
        if (StringUtils.isNotEmpty((String)filename) && (tokenFile = new File(basedir, filename)).exists()) {
            tokens = this.readTokens(tokenFile);
        }
        return tokens;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List readTokens(File tokenFile) throws IOException {
        ArrayList result = new ArrayList();
        BufferedReader reader = null;
        try {
            Map composite = this.getInterpolationValueSource();
            reader = new BufferedReader((Reader)new InterpolationFilterReader(this.newReader(tokenFile), composite));
            String line = null;
            while ((line = reader.readLine()) != null) {
                result.addAll(this.collectListFromCSV(line));
            }
        }
        catch (Throwable throwable) {
            IOUtil.close(reader);
            throw throwable;
        }
        IOUtil.close((Reader)reader);
        return result;
    }

    private List collectListFromCSV(String csv) {
        ArrayList<String> result = new ArrayList<String>();
        if (csv != null && csv.trim().length() > 0) {
            StringTokenizer st = new StringTokenizer(csv, ",");
            while (st.hasMoreTokens()) {
                result.add(st.nextToken().trim());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void buildInterpolatedFile(File originalFile, File interpolatedFile) throws MojoExecutionException {
        this.getLog().debug((CharSequence)("Interpolate " + originalFile.getPath() + " to " + interpolatedFile.getPath()));
        try {
            String xml;
            XmlStreamReader reader = null;
            try {
                Map composite = this.getInterpolationValueSource();
                reader = ReaderFactory.newXmlReader((File)originalFile);
                reader = new InterpolationFilterReader((Reader)reader, composite, "@", "@");
                xml = IOUtil.toString((Reader)reader);
            }
            catch (Throwable throwable) {
                IOUtil.close(reader);
                throw throwable;
            }
            IOUtil.close((Reader)reader);
            XmlStreamWriter writer = null;
            try {
                interpolatedFile.getParentFile().mkdirs();
                writer = WriterFactory.newXmlWriter((File)interpolatedFile);
                writer.write(xml);
                writer.flush();
            }
            catch (Throwable throwable) {
                IOUtil.close(writer);
                throw throwable;
            }
            IOUtil.close((Writer)writer);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to interpolate file " + originalFile.getPath(), (Exception)e);
        }
    }

    private InvokerProperties getInvokerProperties(File projectDirectory) throws MojoExecutionException {
        Properties props = new Properties();
        if (this.invokerPropertiesFile != null) {
            File propertiesFile = new File(projectDirectory, this.invokerPropertiesFile);
            if (propertiesFile.isFile()) {
                FileInputStream in = null;
                try {
                    in = new FileInputStream(propertiesFile);
                    props.load(in);
                }
                catch (IOException e) {
                    try {
                        throw new MojoExecutionException("Failed to read invoker properties: " + propertiesFile, (Exception)e);
                    }
                    catch (Throwable throwable) {
                        IOUtil.close(in);
                        throw throwable;
                    }
                }
                IOUtil.close((InputStream)in);
            }
            RegexBasedInterpolator interpolator = new RegexBasedInterpolator();
            interpolator.addValueSource((ValueSource)new MapBasedValueSource(this.getInterpolationValueSource()));
            Iterator<Object> it = props.keySet().iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                String value = props.getProperty(key);
                try {
                    value = interpolator.interpolate(value, "");
                }
                catch (InterpolationException e) {
                    throw new MojoExecutionException("Failed to interpolate invoker properties: " + propertiesFile, (Exception)((Object)e));
                }
                props.setProperty(key, value);
            }
        }
        return new InvokerProperties(props);
    }
}

