/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.gpg;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.gpg.GpgSigner;
import org.apache.maven.project.MavenProject;

public abstract class AbstractGpgMojo
extends AbstractMojo {
    private File homedir;
    private String passphrase;
    private String keyname;
    private boolean useAgent;
    private boolean interactive;
    private String executable;

    GpgSigner newSigner(MavenProject project) throws MojoExecutionException, MojoFailureException {
        GpgSigner signer = new GpgSigner();
        signer.setExecutable(this.executable);
        signer.setInteractive(this.interactive);
        signer.setKeyName(this.keyname);
        signer.setUseAgent(this.useAgent);
        signer.setHomeDirectory(this.homedir);
        signer.setPassPhrase(this.passphrase);
        if (null == this.passphrase && !this.useAgent) {
            if (!this.interactive) {
                throw new MojoFailureException("Cannot obtain passphrase in batch mode");
            }
            try {
                signer.setPassPhrase(signer.getPassphrase(project));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Exception reading passphrase", (Exception)e);
            }
        }
        return signer;
    }
}

