/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.ear.util;

import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.ear.util.ArtifactTypeMappingService;

public class ArtifactRepository {
    private final Set artifacts;
    private final String mainArtifactId;
    private final ArtifactTypeMappingService artifactTypeMappingService;

    public ArtifactRepository(Set artifacts, String mainArtifactId) {
        this.artifacts = artifacts;
        this.mainArtifactId = mainArtifactId;
        this.artifactTypeMappingService = ArtifactTypeMappingService.getInstance();
    }

    public Artifact getUniqueArtifact(String groupId, String artifactId, String type, String classifier) {
        Set candidates = this.getArtifacts(groupId, artifactId, type);
        if (candidates.size() == 0) {
            return null;
        }
        if (candidates.size() == 1 && classifier == null) {
            return (Artifact)candidates.iterator().next();
        }
        if (classifier != null) {
            Iterator it = candidates.iterator();
            while (it.hasNext()) {
                Artifact a = (Artifact)it.next();
                if (a.getClassifier() == null && classifier.equals(this.mainArtifactId)) {
                    return a;
                }
                if (!classifier.equals(a.getClassifier())) continue;
                return a;
            }
        }
        return null;
    }

    public Artifact getUniqueArtifact(String groupId, String artifactId, String type) {
        return this.getUniqueArtifact(groupId, artifactId, type, null);
    }

    public Set getArtifacts(String groupId, String artifactId, String type) {
        TreeSet<Artifact> result = new TreeSet<Artifact>();
        Iterator it = this.artifacts.iterator();
        while (it.hasNext()) {
            Artifact a = (Artifact)it.next();
            if (!a.getGroupId().equals(groupId) || !a.getArtifactId().equals(artifactId) || !this.artifactTypeMappingService.isMappedToType(type, a.getType())) continue;
            result.add(a);
        }
        return result;
    }
}

