/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.ear;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.ear.AbstractEarMojo;
import org.apache.maven.plugin.ear.EarModule;
import org.apache.maven.plugin.ear.EarModuleFactory;
import org.apache.maven.plugin.ear.Ejb3Module;
import org.apache.maven.plugin.ear.JavaModule;
import org.apache.maven.plugin.ear.util.EarMavenArchiver;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.shared.filtering.MavenFileFilter;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.apache.maven.shared.filtering.MavenResourcesExecution;
import org.apache.maven.shared.filtering.MavenResourcesFiltering;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

public class EarMojo
extends AbstractEarMojo {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private File earSourceDirectory;
    private String earSourceIncludes;
    private String earSourceExcludes;
    private boolean filtering;
    private List filters;
    private List nonFilteredFileExtensions;
    private boolean escapedBackslashesInFilePath;
    protected String escapeString;
    private File manifestFile;
    private String applicationXml;
    private String outputDirectory;
    private String finalName;
    private String unpackTypes;
    private String classifier;
    private File resourcesDir;
    private JarArchiver jarArchiver;
    private MavenArchiveConfiguration archive = new MavenArchiveConfiguration();
    private MavenProjectHelper projectHelper;
    private ArchiverManager archiverManager;
    private MavenFileFilter mavenFileFilter;
    private MavenResourcesFiltering mavenResourcesFiltering;
    private MavenSession session;
    private List filterWrappers;

    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();
        List<Object> unpackTypesList = new ArrayList();
        if (this.unpackTypes != null) {
            unpackTypesList = Arrays.asList(this.unpackTypes.split(","));
            Iterator<Object> it = unpackTypesList.iterator();
            while (it.hasNext()) {
                String type = (String)it.next();
                if (EarModuleFactory.standardArtifactTypes.contains(type)) continue;
                throw new MojoExecutionException("Invalid type[" + type + "] supported types are " + EarModuleFactory.standardArtifactTypes);
            }
            this.getLog().debug((CharSequence)("Initialized unpack types " + unpackTypesList));
        }
        try {
            Iterator iter = this.getModules().iterator();
            while (iter.hasNext()) {
                EarModule module = (EarModule)iter.next();
                if (module instanceof JavaModule) {
                    this.getLog().warn((CharSequence)("JavaModule is deprecated (" + module + "), please use JarModule instead."));
                }
                if (module instanceof Ejb3Module) {
                    this.getLog().warn((CharSequence)("Ejb3Module is deprecated (" + module + "), please use EjbModule instead."));
                }
                File sourceFile = module.getArtifact().getFile();
                File destinationFile = EarMojo.buildDestinationFile(this.getWorkDirectory(), module.getUri());
                if (!sourceFile.isFile()) {
                    throw new MojoExecutionException("Cannot copy a directory: " + sourceFile.getAbsolutePath() + "; Did you package/install " + module.getArtifact() + "?");
                }
                if (destinationFile.getCanonicalPath().equals(sourceFile.getCanonicalPath())) {
                    this.getLog().info((CharSequence)("Skipping artifact[" + module + "], as it already exists at[" + module.getUri() + "]"));
                    continue;
                }
                if (unpackTypesList.contains(module.getType()) && (module.shouldUnpack() == null || module.shouldUnpack().booleanValue()) || module.shouldUnpack() != null && module.shouldUnpack().booleanValue()) {
                    this.getLog().info((CharSequence)("Copying artifact[" + module + "] to[" + module.getUri() + "] (unpacked)"));
                    destinationFile.mkdirs();
                    this.unpack(sourceFile, destinationFile);
                    continue;
                }
                if (sourceFile.lastModified() > destinationFile.lastModified()) {
                    this.getLog().info((CharSequence)("Copying artifact[" + module + "] to[" + module.getUri() + "]"));
                    FileUtils.copyFile((File)sourceFile, (File)destinationFile);
                    continue;
                }
                this.getLog().debug((CharSequence)("Skipping artifact[" + module + "], as it is already up to date at[" + module.getUri() + "]"));
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error copying EAR modules", (Exception)e);
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Error unpacking EAR modules", (Exception)((Object)e));
        }
        catch (NoSuchArchiverException e) {
            throw new MojoExecutionException("No Archiver found for EAR modules", (Exception)((Object)e));
        }
        try {
            File earSourceDir = this.earSourceDirectory;
            if (earSourceDir.exists()) {
                this.getLog().info((CharSequence)("Copy ear sources to " + this.getWorkDirectory().getAbsolutePath()));
                String[] fileNames = this.getEarFiles(earSourceDir);
                for (int i = 0; i < fileNames.length; ++i) {
                    this.copyFile(new File(earSourceDir, fileNames[i]), new File(this.getWorkDirectory(), fileNames[i]));
                }
            }
            if (this.applicationXml != null && !"".equals(this.applicationXml)) {
                this.getLog().info((CharSequence)("Including custom application.xml[" + this.applicationXml + "]"));
                File metaInfDir = new File(this.getWorkDirectory(), "META-INF");
                this.copyFile(new File(this.applicationXml), new File(metaInfDir, "/application.xml"));
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error copying EAR sources", (Exception)e);
        }
        catch (MavenFilteringException e) {
            throw new MojoExecutionException("Error filetering EAR sources", (Exception)((Object)e));
        }
        try {
            if (this.resourcesDir != null && this.resourcesDir.exists()) {
                this.getLog().warn((CharSequence)"resourcesDir is deprecated. Please use the earSourceDirectory property instead.");
                this.getLog().info((CharSequence)("Copy ear resources to " + this.getWorkDirectory().getAbsolutePath()));
                String[] fileNames = this.getEarFiles(this.resourcesDir);
                for (int i = 0; i < fileNames.length; ++i) {
                    FileUtils.copyFile((File)new File(this.resourcesDir, fileNames[i]), (File)new File(this.getWorkDirectory(), fileNames[i]));
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error copying EAR resources", (Exception)e);
        }
        File ddFile = new File(this.getWorkDirectory(), "META-INF/application.xml");
        if (!(ddFile.exists() || this.version.equals("5") || this.version.equals("6"))) {
            throw new MojoExecutionException("Deployment descriptor: " + ddFile.getAbsolutePath() + " does not exist.");
        }
        try {
            File earFile = EarMojo.getEarFile(this.outputDirectory, this.finalName, this.classifier);
            EarMavenArchiver archiver = new EarMavenArchiver(this.getModules());
            JarArchiver jarArchiver = this.getJarArchiver();
            this.getLog().debug((CharSequence)("Jar archiver implementation[" + jarArchiver.getClass().getName() + "]"));
            archiver.setArchiver(jarArchiver);
            archiver.setOutputFile(earFile);
            this.includeCustomManifestFile();
            archiver.getArchiver().addDirectory(this.getWorkDirectory());
            archiver.createArchive(this.getProject(), this.archive);
            if (this.classifier != null) {
                this.projectHelper.attachArtifact(this.getProject(), "ear", this.classifier, earFile);
            } else {
                this.getProject().getArtifact().setFile(earFile);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error assembling EAR", e);
        }
    }

    public String getApplicationXml() {
        return this.applicationXml;
    }

    public void setApplicationXml(String applicationXml) {
        this.applicationXml = applicationXml;
    }

    protected String[] getExcludes() {
        ArrayList<String> excludeList = new ArrayList<String>(FileUtils.getDefaultExcludesAsList());
        if (this.earSourceExcludes != null && !"".equals(this.earSourceExcludes)) {
            excludeList.addAll(Arrays.asList(StringUtils.split((String)this.earSourceExcludes, (String)",")));
        }
        if (this.getApplicationXml() != null && !"".equals(this.getApplicationXml())) {
            excludeList.add("**/META-INF/application.xml");
        }
        return excludeList.toArray(EMPTY_STRING_ARRAY);
    }

    protected String[] getIncludes() {
        return StringUtils.split((String)StringUtils.defaultString((Object)this.earSourceIncludes), (String)",");
    }

    private static File buildDestinationFile(File buildDir, String uri) {
        return new File(buildDir, uri);
    }

    private void includeCustomManifestFile() {
        if (this.manifestFile == null) {
            this.manifestFile = new File(this.getWorkDirectory(), "META-INF/MANIFEST.MF");
        }
        if (!this.manifestFile.exists()) {
            this.getLog().info((CharSequence)("Could not find manifest file: " + this.manifestFile + " - Generating one"));
        } else {
            this.getLog().info((CharSequence)("Including custom manifest file[" + this.manifestFile + "]"));
            this.archive.setManifestFile(this.manifestFile);
        }
    }

    private static File getEarFile(String basedir, String finalName, String classifier) {
        if (classifier == null) {
            classifier = "";
        } else if (classifier.trim().length() > 0 && !classifier.startsWith("-")) {
            classifier = "-" + classifier;
        }
        return new File(basedir, finalName + classifier + ".ear");
    }

    private String[] getEarFiles(File sourceDir) {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(sourceDir);
        scanner.setExcludes(this.getExcludes());
        scanner.addDefaultExcludes();
        scanner.setIncludes(this.getIncludes());
        scanner.scan();
        return scanner.getIncludedFiles();
    }

    public void unpack(File source, File destDir) throws NoSuchArchiverException, IOException, ArchiverException {
        UnArchiver unArchiver = this.archiverManager.getUnArchiver("zip");
        unArchiver.setSourceFile(source);
        unArchiver.setDestDirectory(destDir);
        unArchiver.extract();
    }

    protected JarArchiver getJarArchiver() {
        return this.jarArchiver;
    }

    private void copyFile(File source, File target) throws MavenFilteringException, IOException, MojoExecutionException {
        if (this.filtering && !this.isNonFilteredExtension(source.getName())) {
            this.mavenFileFilter.copyFile(source, target, true, this.getFilterWrappers(), null);
        } else {
            FileUtils.copyFile((File)source, (File)target);
        }
    }

    public boolean isNonFilteredExtension(String fileName) {
        return !this.mavenResourcesFiltering.filteredFileExtension(fileName, this.nonFilteredFileExtensions);
    }

    private List getFilterWrappers() throws MojoExecutionException {
        if (this.filterWrappers == null) {
            try {
                MavenResourcesExecution mavenResourcesExecution = new MavenResourcesExecution();
                mavenResourcesExecution.setEscapeString(this.escapeString);
                this.filterWrappers = this.mavenFileFilter.getDefaultFilterWrappers(this.project, this.filters, this.escapedBackslashesInFilePath, this.session, mavenResourcesExecution);
            }
            catch (MavenFilteringException e) {
                this.getLog().error((CharSequence)("fail to build filering wrappers " + e.getMessage()));
                throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
            }
        }
        return this.filterWrappers;
    }
}

