/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.assembly.archive.phase;

import java.util.List;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.plugins.assembly.AssemblerConfigurationSource;
import org.apache.maven.plugins.assembly.archive.ArchiveCreationException;
import org.apache.maven.plugins.assembly.archive.phase.AssemblyArchiverPhase;
import org.apache.maven.plugins.assembly.archive.phase.PhaseOrder;
import org.apache.maven.plugins.assembly.archive.task.AddFileSetsTask;
import org.apache.maven.plugins.assembly.format.AssemblyFormattingException;
import org.apache.maven.plugins.assembly.model.Assembly;
import org.apache.maven.plugins.assembly.model.FileSet;
import org.codehaus.plexus.archiver.Archiver;

@Singleton
@Named(value="file-sets")
public class FileSetAssemblyPhase
implements AssemblyArchiverPhase,
PhaseOrder {
    @Override
    public void execute(Assembly assembly, Archiver archiver, AssemblerConfigurationSource configSource) throws ArchiveCreationException, AssemblyFormattingException {
        List<FileSet> fileSets = assembly.getFileSets();
        if (fileSets != null && !fileSets.isEmpty()) {
            AddFileSetsTask task = new AddFileSetsTask(fileSets);
            task.execute(archiver, configSource);
        }
    }

    @Override
    public int order() {
        return 20;
    }
}

