/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.ant;

import java.io.IOException;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;

public class ArtifactResolverWrapper {
    private ArtifactResolver resolver;
    private ArtifactFactory factory;
    private ArtifactRepository localRepository;
    private List remoteRepositories;

    private ArtifactResolverWrapper(ArtifactResolver resolver, ArtifactFactory factory, ArtifactRepository localRepository, List remoteRepositories) {
        this.resolver = resolver;
        this.factory = factory;
        this.localRepository = localRepository;
        this.remoteRepositories = remoteRepositories;
    }

    public static ArtifactResolverWrapper getInstance(ArtifactResolver resolver, ArtifactFactory factory, ArtifactRepository localRepository, List remoteRepositories) {
        return new ArtifactResolverWrapper(resolver, factory, localRepository, remoteRepositories);
    }

    protected ArtifactFactory getFactory() {
        return this.factory;
    }

    protected void setFactory(ArtifactFactory factory) {
        this.factory = factory;
    }

    protected ArtifactRepository getLocalRepository() {
        return this.localRepository;
    }

    protected void setLocalRepository(ArtifactRepository localRepository) {
        this.localRepository = localRepository;
    }

    protected List getRemoteRepositories() {
        return this.remoteRepositories;
    }

    protected void setRemoteRepositories(List remoteRepositories) {
        this.remoteRepositories = remoteRepositories;
    }

    protected ArtifactResolver getResolver() {
        return this.resolver;
    }

    protected void setResolver(ArtifactResolver resolver) {
        this.resolver = resolver;
    }

    public String getArtifactAbsolutePath(String groupId, String artifactId, String version) throws IOException {
        Artifact artifact = this.factory.createArtifact(groupId, artifactId, version, "compile", "jar");
        try {
            this.resolver.resolve(artifact, this.remoteRepositories, this.localRepository);
            return artifact.getFile().getAbsolutePath();
        }
        catch (ArtifactResolutionException e) {
            throw new IOException("Unable to resolve artifact: " + groupId + ":" + artifactId + ":" + version);
        }
        catch (ArtifactNotFoundException e) {
            throw new IOException("Unable to find artifact: " + groupId + ":" + artifactId + ":" + version);
        }
    }

    public String getLocalArtifactPath(Artifact artifact) {
        return this.localRepository.pathOf(artifact);
    }
}

