/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.tools.plugin.extractor;

import java.util.Objects;

public final class GroupKey
implements Comparable<GroupKey> {
    public static final String JAVA_GROUP = "java";
    private final String group;
    private final int order;

    public GroupKey(String group, int order) {
        if (group == null) {
            throw new NullPointerException("GroupKey.group null");
        }
        this.group = group;
        this.order = order;
    }

    public String getGroup() {
        return this.group;
    }

    public int getOrder() {
        return this.order;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroupKey groupKey = (GroupKey)o;
        return this.order == groupKey.order && this.group.equals(groupKey.group);
    }

    public int hashCode() {
        return Objects.hash(this.group, this.order);
    }

    @Override
    public int compareTo(GroupKey o) {
        if (JAVA_GROUP.equals(this.group) && !JAVA_GROUP.equals(o.group)) {
            return -1;
        }
        if (!JAVA_GROUP.equals(this.group) && JAVA_GROUP.equals(o.group)) {
            return 1;
        }
        int result = this.group.compareTo(o.group);
        if (result != 0) {
            return result;
        }
        return Integer.compare(this.order, o.order);
    }

    public String toString() {
        return this.group + ":" + this.order;
    }
}

