/*
 * $Id$
 */

package org.apache.maven.settings;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.*;
import java.util.List;

/**
 * Class Settings.
 * 
 * @version $Revision$ $Date$
 */
public class Settings extends TrackableBase 
implements java.io.Serializable
{


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field localRepository
     */
    private String localRepository;

    /**
     * Field interactiveMode
     */
    private boolean interactiveMode = true;

    /**
     * Field usePluginRegistry
     */
    private boolean usePluginRegistry = false;

    /**
     * Field offline
     */
    private boolean offline = false;

    /**
     * Field proxies
     */
    private java.util.List proxies;

    /**
     * Field servers
     */
    private java.util.List servers;

    /**
     * Field mirrors
     */
    private java.util.List mirrors;

    /**
     * Field profiles
     */
    private java.util.List profiles;

    /**
     * Field activeProfiles
     */
    private java.util.List activeProfiles;

    /**
     * Field pluginGroups
     */
    private java.util.List pluginGroups;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addActiveProfile
     * 
     * @param string
     */
    public void addActiveProfile(String string)
    {
        getActiveProfiles().add( string );
    } //-- void addActiveProfile(String) 

    /**
     * Method addMirror
     * 
     * @param mirror
     */
    public void addMirror(Mirror mirror)
    {
        getMirrors().add( mirror );
    } //-- void addMirror(Mirror) 

    /**
     * Method addPluginGroup
     * 
     * @param string
     */
    public void addPluginGroup(String string)
    {
        getPluginGroups().add( string );
    } //-- void addPluginGroup(String) 

    /**
     * Method addProfile
     * 
     * @param profile
     */
    public void addProfile(Profile profile)
    {
        getProfiles().add( profile );
    } //-- void addProfile(Profile) 

    /**
     * Method addProxy
     * 
     * @param proxy
     */
    public void addProxy(Proxy proxy)
    {
        getProxies().add( proxy );
    } //-- void addProxy(Proxy) 

    /**
     * Method addServer
     * 
     * @param server
     */
    public void addServer(Server server)
    {
        getServers().add( server );
    } //-- void addServer(Server) 

    /**
     * Method getActiveProfiles
     */
    public java.util.List getActiveProfiles()
    {
        if ( this.activeProfiles == null )
        {
            this.activeProfiles = new java.util.ArrayList();
        }
        
        return this.activeProfiles;
    } //-- java.util.List getActiveProfiles() 

    /**
     * Method getLocalRepository
     */
    public String getLocalRepository()
    {
        return this.localRepository;
    } //-- String getLocalRepository() 

    /**
     * Method getMirrors
     */
    public java.util.List getMirrors()
    {
        if ( this.mirrors == null )
        {
            this.mirrors = new java.util.ArrayList();
        }
        
        return this.mirrors;
    } //-- java.util.List getMirrors() 

    /**
     * Method getPluginGroups
     */
    public java.util.List getPluginGroups()
    {
        if ( this.pluginGroups == null )
        {
            this.pluginGroups = new java.util.ArrayList();
        }
        
        return this.pluginGroups;
    } //-- java.util.List getPluginGroups() 

    /**
     * Method getProfiles
     */
    public java.util.List getProfiles()
    {
        if ( this.profiles == null )
        {
            this.profiles = new java.util.ArrayList();
        }
        
        return this.profiles;
    } //-- java.util.List getProfiles() 

    /**
     * Method getProxies
     */
    public java.util.List getProxies()
    {
        if ( this.proxies == null )
        {
            this.proxies = new java.util.ArrayList();
        }
        
        return this.proxies;
    } //-- java.util.List getProxies() 

    /**
     * Method getServers
     */
    public java.util.List getServers()
    {
        if ( this.servers == null )
        {
            this.servers = new java.util.ArrayList();
        }
        
        return this.servers;
    } //-- java.util.List getServers() 

    /**
     * Method isInteractiveMode
     */
    public boolean isInteractiveMode()
    {
        return this.interactiveMode;
    } //-- boolean isInteractiveMode() 

    /**
     * Method isOffline
     */
    public boolean isOffline()
    {
        return this.offline;
    } //-- boolean isOffline() 

    /**
     * Method isUsePluginRegistry
     */
    public boolean isUsePluginRegistry()
    {
        return this.usePluginRegistry;
    } //-- boolean isUsePluginRegistry() 

    /**
     * Method removeActiveProfile
     * 
     * @param string
     */
    public void removeActiveProfile(String string)
    {
        getActiveProfiles().remove( string );
    } //-- void removeActiveProfile(String) 

    /**
     * Method removeMirror
     * 
     * @param mirror
     */
    public void removeMirror(Mirror mirror)
    {
        getMirrors().remove( mirror );
    } //-- void removeMirror(Mirror) 

    /**
     * Method removePluginGroup
     * 
     * @param string
     */
    public void removePluginGroup(String string)
    {
        getPluginGroups().remove( string );
    } //-- void removePluginGroup(String) 

    /**
     * Method removeProfile
     * 
     * @param profile
     */
    public void removeProfile(Profile profile)
    {
        getProfiles().remove( profile );
    } //-- void removeProfile(Profile) 

    /**
     * Method removeProxy
     * 
     * @param proxy
     */
    public void removeProxy(Proxy proxy)
    {
        getProxies().remove( proxy );
    } //-- void removeProxy(Proxy) 

    /**
     * Method removeServer
     * 
     * @param server
     */
    public void removeServer(Server server)
    {
        getServers().remove( server );
    } //-- void removeServer(Server) 

    /**
     * Method setActiveProfiles
     * 
     * @param activeProfiles
     */
    public void setActiveProfiles(java.util.List activeProfiles)
    {
        this.activeProfiles = activeProfiles;
    } //-- void setActiveProfiles(java.util.List) 

    /**
     * Method setInteractiveMode
     * 
     * @param interactiveMode
     */
    public void setInteractiveMode(boolean interactiveMode)
    {
        this.interactiveMode = interactiveMode;
    } //-- void setInteractiveMode(boolean) 

    /**
     * Method setLocalRepository
     * 
     * @param localRepository
     */
    public void setLocalRepository(String localRepository)
    {
        this.localRepository = localRepository;
    } //-- void setLocalRepository(String) 

    /**
     * Method setMirrors
     * 
     * @param mirrors
     */
    public void setMirrors(java.util.List mirrors)
    {
        this.mirrors = mirrors;
    } //-- void setMirrors(java.util.List) 

    /**
     * Method setOffline
     * 
     * @param offline
     */
    public void setOffline(boolean offline)
    {
        this.offline = offline;
    } //-- void setOffline(boolean) 

    /**
     * Method setPluginGroups
     * 
     * @param pluginGroups
     */
    public void setPluginGroups(java.util.List pluginGroups)
    {
        this.pluginGroups = pluginGroups;
    } //-- void setPluginGroups(java.util.List) 

    /**
     * Method setProfiles
     * 
     * @param profiles
     */
    public void setProfiles(java.util.List profiles)
    {
        this.profiles = profiles;
    } //-- void setProfiles(java.util.List) 

    /**
     * Method setProxies
     * 
     * @param proxies
     */
    public void setProxies(java.util.List proxies)
    {
        this.proxies = proxies;
    } //-- void setProxies(java.util.List) 

    /**
     * Method setServers
     * 
     * @param servers
     */
    public void setServers(java.util.List servers)
    {
        this.servers = servers;
    } //-- void setServers(java.util.List) 

    /**
     * Method setUsePluginRegistry
     * 
     * @param usePluginRegistry
     */
    public void setUsePluginRegistry(boolean usePluginRegistry)
    {
        this.usePluginRegistry = usePluginRegistry;
    } //-- void setUsePluginRegistry(boolean) 


    public Boolean getInteractiveMode()
    {
        return Boolean.valueOf( isInteractiveMode() );
    }
          
    private Proxy activeProxy;
    
    public void flushActiveProxy()
    {
        this.activeProxy = null;
    }

    public synchronized Proxy getActiveProxy()
    {
        if(activeProxy == null)
        {
            java.util.List proxies = getProxies();
            if ( proxies != null && !proxies.isEmpty() )
            {
                if ( proxies.size() > 1 )
                {
                    for ( java.util.Iterator it = proxies.iterator(); it.hasNext(); )
                    {
                        Proxy proxy = (Proxy) it.next();
                        if ( proxy.isActive() )
                        {
                            activeProxy = proxy;
                            break;
                        }
                    }
                }
                else
                {
                    // If we only have one proxy, use it as the active one.
                    activeProxy = (Proxy) proxies.get( 0 );
                }
            }
        }

        return activeProxy;
    }
    
    public Server getServer( String serverId )
    {
        Server match = null;

        java.util.List servers = getServers();
        if ( servers != null && serverId != null )
        {
            for ( java.util.Iterator it = servers.iterator(); it.hasNext(); )
            {
                Server server = (Server) it.next();
                if ( serverId.equals( server.getId() ) )
                {
                    match = server;
                    break;
                }
            }
        }

        return match;
    }
    
    public Mirror getMirrorOf( String repositoryId )
    {
        Mirror match = null;

        java.util.List mirrors = getMirrors();
        if ( mirrors != null && repositoryId != null )
        {
            for ( java.util.Iterator it = mirrors.iterator(); it.hasNext(); )
            {
                Mirror mirror = (Mirror) it.next();
                if ( repositoryId.equals( mirror.getMirrorOf() ) )
                {
                    match = mirror;
                    break;
                }
            }
        }

        return match;
    }
    
    private java.util.Map profileMap;
    
    public void flushProfileMap()
    {
        this.profileMap = null;
    }
    
    public java.util.Map getProfilesAsMap()
    {
        if ( profileMap == null )
        {
            profileMap = new java.util.HashMap();
            
            if ( getProfiles() != null )
            {
                for ( java.util.Iterator it = getProfiles().iterator(); it.hasNext(); )
                {
                    Profile profile = (Profile) it.next();
                    
                    profileMap.put( profile.getId(), profile );
                }
            }
        }
        
        return profileMap;
    }
    
    private RuntimeInfo runtimeInfo;
    
    public void setRuntimeInfo( RuntimeInfo runtimeInfo )
    {
        this.runtimeInfo = runtimeInfo;
    }
    
    public RuntimeInfo getRuntimeInfo()
    {
        return runtimeInfo;
    }
        }
