/*
 * $Id$
 */

package org.apache.maven.usability.plugin;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.*;
import java.util.Properties;

/**
 * Class Expression.
 * 
 * @version $Revision$ $Date$
 */
public class Expression implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field syntax
     */
    private String syntax;

    /**
     * Field description
     */
    private String description;

    /**
     * Field configuration
     */
    private String configuration;

    /**
     * Field cliOptions
     */
    private java.util.Properties cliOptions;

    /**
     * Field apiMethods
     */
    private java.util.Properties apiMethods;

    /**
     * Field deprecation
     */
    private String deprecation;

    /**
     * Field ban
     */
    private String ban;

    /**
     * Field editable
     */
    private boolean editable = true;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addApiMethod
     * 
     * @param key
     * @param value
     */
    public void addApiMethod(String key, String value)
    {
        getApiMethods().put( key, value );
    } //-- void addApiMethod(String, String) 

    /**
     * Method addCliOption
     * 
     * @param key
     * @param value
     */
    public void addCliOption(String key, String value)
    {
        getCliOptions().put( key, value );
    } //-- void addCliOption(String, String) 

    /**
     * Method getApiMethods
     */
    public java.util.Properties getApiMethods()
    {
        if ( this.apiMethods == null )
        {
            this.apiMethods = new java.util.Properties();
        }
        
        return this.apiMethods;
    } //-- java.util.Properties getApiMethods() 

    /**
     * Method getBan
     */
    public String getBan()
    {
        return this.ban;
    } //-- String getBan() 

    /**
     * Method getCliOptions
     */
    public java.util.Properties getCliOptions()
    {
        if ( this.cliOptions == null )
        {
            this.cliOptions = new java.util.Properties();
        }
        
        return this.cliOptions;
    } //-- java.util.Properties getCliOptions() 

    /**
     * Method getConfiguration
     */
    public String getConfiguration()
    {
        return this.configuration;
    } //-- String getConfiguration() 

    /**
     * Method getDeprecation
     */
    public String getDeprecation()
    {
        return this.deprecation;
    } //-- String getDeprecation() 

    /**
     * Method getDescription
     */
    public String getDescription()
    {
        return this.description;
    } //-- String getDescription() 

    /**
     * Method getSyntax
     */
    public String getSyntax()
    {
        return this.syntax;
    } //-- String getSyntax() 

    /**
     * Method isEditable
     */
    public boolean isEditable()
    {
        return this.editable;
    } //-- boolean isEditable() 

    /**
     * Method setApiMethods
     * 
     * @param apiMethods
     */
    public void setApiMethods(java.util.Properties apiMethods)
    {
        this.apiMethods = apiMethods;
    } //-- void setApiMethods(java.util.Properties) 

    /**
     * Method setBan
     * 
     * @param ban
     */
    public void setBan(String ban)
    {
        this.ban = ban;
    } //-- void setBan(String) 

    /**
     * Method setCliOptions
     * 
     * @param cliOptions
     */
    public void setCliOptions(java.util.Properties cliOptions)
    {
        this.cliOptions = cliOptions;
    } //-- void setCliOptions(java.util.Properties) 

    /**
     * Method setConfiguration
     * 
     * @param configuration
     */
    public void setConfiguration(String configuration)
    {
        this.configuration = configuration;
    } //-- void setConfiguration(String) 

    /**
     * Method setDeprecation
     * 
     * @param deprecation
     */
    public void setDeprecation(String deprecation)
    {
        this.deprecation = deprecation;
    } //-- void setDeprecation(String) 

    /**
     * Method setDescription
     * 
     * @param description
     */
    public void setDescription(String description)
    {
        this.description = description;
    } //-- void setDescription(String) 

    /**
     * Method setEditable
     * 
     * @param editable
     */
    public void setEditable(boolean editable)
    {
        this.editable = editable;
    } //-- void setEditable(boolean) 

    /**
     * Method setSyntax
     * 
     * @param syntax
     */
    public void setSyntax(String syntax)
    {
        this.syntax = syntax;
    } //-- void setSyntax(String) 

}
