/*
 =================== DO NOT EDIT THIS FILE ====================
 Generated by Modello 1.0.1 on 2009-08-06 15:13:09,
 any modifications will be overwritten.
 ==============================================================
 */

package org.apache.maven.model;

/**
 * 
 *         
 *         The <code>&lt;dependency&gt;</code> element contains
 * information about a dependency
 *         of the project.
 *         
 *       
 * 
 * @version $Revision$ $Date$
 */
public class Dependency
    implements java.io.Serializable
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * 
     *             
     *             The project group that produced the dependency,
     * e.g.
     *             <code>org.apache.maven</code>.
     *             
     *           
     */
    private String groupId;

    /**
     * 
     *             
     *             The unique id for an artifact produced by the
     * project group, e.g.
     *             <code>maven-artifact</code>.
     *             
     *           
     */
    private String artifactId;

    /**
     * 
     *             
     *             The version of the dependency, e.g.
     * <code>3.2.1</code>. In Maven 2, this can also be
     *             specified as a range of versions.
     *             
     *           
     */
    private String version;

    /**
     * 
     *             
     *             The type of dependency. This defaults to
     * <code>jar</code>. While it
     *             usually represents the extension on the filename
     * of the dependency,
     *             that is not always the case. A type can be
     * mapped to a different
     *             extension and a classifier.
     *             The type often correspongs to the packaging
     * used, though this is also
     *             not always the case.
     *             Some examples are <code>jar</code>,
     * <code>war</code>, <code>ejb-client</code>
     *             and <code>test-jar</code>.
     *             New types can be defined by plugins that set
     *             <code>extensions</code> to <code>true</code>, so
     * this is not a complete list.
     *             
     *           
     */
    private String type = "jar";

    /**
     * 
     *             
     *             The classifier of the dependency. This allows
     * distinguishing two artifacts
     *             that belong to the same POM but were built
     * differently, and is appended to
     *             the filename after the version. For example,
     * <code>jdk14</code> and <code>jdk15</code>.
     *             
     *           
     */
    private String classifier;

    /**
     * 
     *             
     *             The scope of the dependency -
     * <code>compile</code>, <code>runtime</code>,
     *             <code>test</code>, <code>system</code>, and
     * <code>provided</code>. Used to
     *             calculate the various classpaths used for
     * compilation, testing, and so on.
     *             It also assists in determining which artifacts
     * to include in a distribution of
     *             this project. For more information, see
     *             <a
     * href="http://maven.apache.org/guides/introduction/introduction-to-dependency-mechanism.html">the
     *             dependency mechanism</a>.
     *             
     *           
     */
    private String scope;

    /**
     * 
     *             
     *             FOR SYSTEM SCOPE ONLY. Note that use of this
     * property is <b>discouraged</b>
     *             and may be replaced in later versions. This
     * specifies the path on the filesystem
     *             for this dependency.
     *             Requires an absolute path for the value, not
     * relative.
     *             Use a property that gives the machine specific
     * absolute path,
     *             e.g. <code>${java.home}</code>.
     *             
     *           
     */
    private String systemPath;

    /**
     * Field exclusions.
     */
    private java.util.List<Exclusion> exclusions;

    /**
     * Indicates the dependency is optional for use of this
     * library. While the
     *             version of the dependency will be taken into
     * account for dependency calculation if the
     *             library is used elsewhere, it will not be passed
     * on transitively.
     */
    private boolean optional = false;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addExclusion.
     * 
     * @param exclusion
     */
    public void addExclusion( Exclusion exclusion )
    {
        if ( !(exclusion instanceof Exclusion) )
        {
            throw new ClassCastException( "Dependency.addExclusions(exclusion) parameter must be instanceof " + Exclusion.class.getName() );
        }
        getExclusions().add( exclusion );
    } //-- void addExclusion( Exclusion )

    /**
     * Get the unique id for an artifact produced by the project
     * group, e.g.
     *             <code>maven-artifact</code>.
     * 
     * @return String
     */
    public String getArtifactId()
    {
        return this.artifactId;
    } //-- String getArtifactId()

    /**
     * Get the classifier of the dependency. This allows
     * distinguishing two artifacts
     *             that belong to the same POM but were built
     * differently, and is appended to
     *             the filename after the version. For example,
     * <code>jdk14</code> and <code>jdk15</code>.
     * 
     * @return String
     */
    public String getClassifier()
    {
        return this.classifier;
    } //-- String getClassifier()

    /**
     * Method getExclusions.
     * 
     * @return List
     */
    public java.util.List<Exclusion> getExclusions()
    {
        if ( this.exclusions == null )
        {
            this.exclusions = new java.util.ArrayList<Exclusion>();
        }

        return this.exclusions;
    } //-- java.util.List<Exclusion> getExclusions()

    /**
     * Get the project group that produced the dependency, e.g.
     *             <code>org.apache.maven</code>.
     * 
     * @return String
     */
    public String getGroupId()
    {
        return this.groupId;
    } //-- String getGroupId()

    /**
     * Get the scope of the dependency - <code>compile</code>,
     * <code>runtime</code>,
     *             <code>test</code>, <code>system</code>, and
     * <code>provided</code>. Used to
     *             calculate the various classpaths used for
     * compilation, testing, and so on.
     *             It also assists in determining which artifacts
     * to include in a distribution of
     *             this project. For more information, see
     *             <a
     * href="http://maven.apache.org/guides/introduction/introduction-to-dependency-mechanism.html">the
     *             dependency mechanism</a>.
     * 
     * @return String
     */
    public String getScope()
    {
        return this.scope;
    } //-- String getScope()

    /**
     * Get fOR SYSTEM SCOPE ONLY. Note that use of this property is
     * <b>discouraged</b>
     *             and may be replaced in later versions. This
     * specifies the path on the filesystem
     *             for this dependency.
     *             Requires an absolute path for the value, not
     * relative.
     *             Use a property that gives the machine specific
     * absolute path,
     *             e.g. <code>${java.home}</code>.
     * 
     * @return String
     */
    public String getSystemPath()
    {
        return this.systemPath;
    } //-- String getSystemPath()

    /**
     * Get the type of dependency. This defaults to
     * <code>jar</code>. While it
     *             usually represents the extension on the filename
     * of the dependency,
     *             that is not always the case. A type can be
     * mapped to a different
     *             extension and a classifier.
     *             The type often correspongs to the packaging
     * used, though this is also
     *             not always the case.
     *             Some examples are <code>jar</code>,
     * <code>war</code>, <code>ejb-client</code>
     *             and <code>test-jar</code>.
     *             New types can be defined by plugins that set
     *             <code>extensions</code> to <code>true</code>, so
     * this is not a complete list.
     * 
     * @return String
     */
    public String getType()
    {
        return this.type;
    } //-- String getType()

    /**
     * Get the version of the dependency, e.g. <code>3.2.1</code>.
     * In Maven 2, this can also be
     *             specified as a range of versions.
     * 
     * @return String
     */
    public String getVersion()
    {
        return this.version;
    } //-- String getVersion()

    /**
     * Get indicates the dependency is optional for use of this
     * library. While the
     *             version of the dependency will be taken into
     * account for dependency calculation if the
     *             library is used elsewhere, it will not be passed
     * on transitively.
     * 
     * @return boolean
     */
    public boolean isOptional()
    {
        return this.optional;
    } //-- boolean isOptional()

    /**
     * Method removeExclusion.
     * 
     * @param exclusion
     */
    public void removeExclusion( Exclusion exclusion )
    {
        if ( !(exclusion instanceof Exclusion) )
        {
            throw new ClassCastException( "Dependency.removeExclusions(exclusion) parameter must be instanceof " + Exclusion.class.getName() );
        }
        getExclusions().remove( exclusion );
    } //-- void removeExclusion( Exclusion )

    /**
     * Set the unique id for an artifact produced by the project
     * group, e.g.
     *             <code>maven-artifact</code>.
     * 
     * @param artifactId
     */
    public void setArtifactId( String artifactId )
    {
        this.artifactId = artifactId;
    } //-- void setArtifactId( String )

    /**
     * Set the classifier of the dependency. This allows
     * distinguishing two artifacts
     *             that belong to the same POM but were built
     * differently, and is appended to
     *             the filename after the version. For example,
     * <code>jdk14</code> and <code>jdk15</code>.
     * 
     * @param classifier
     */
    public void setClassifier( String classifier )
    {
        this.classifier = classifier;
    } //-- void setClassifier( String )

    /**
     * Set lists a set of artifacts that should be excluded from
     * this dependency's
     *             artifact list when it comes to calculating
     * transitive dependencies.
     * 
     * @param exclusions
     */
    public void setExclusions( java.util.List<Exclusion> exclusions )
    {
        this.exclusions = exclusions;
    } //-- void setExclusions( java.util.List )

    /**
     * Set the project group that produced the dependency, e.g.
     *             <code>org.apache.maven</code>.
     * 
     * @param groupId
     */
    public void setGroupId( String groupId )
    {
        this.groupId = groupId;
    } //-- void setGroupId( String )

    /**
     * Set indicates the dependency is optional for use of this
     * library. While the
     *             version of the dependency will be taken into
     * account for dependency calculation if the
     *             library is used elsewhere, it will not be passed
     * on transitively.
     * 
     * @param optional
     */
    public void setOptional( boolean optional )
    {
        this.optional = optional;
    } //-- void setOptional( boolean )

    /**
     * Set the scope of the dependency - <code>compile</code>,
     * <code>runtime</code>,
     *             <code>test</code>, <code>system</code>, and
     * <code>provided</code>. Used to
     *             calculate the various classpaths used for
     * compilation, testing, and so on.
     *             It also assists in determining which artifacts
     * to include in a distribution of
     *             this project. For more information, see
     *             <a
     * href="http://maven.apache.org/guides/introduction/introduction-to-dependency-mechanism.html">the
     *             dependency mechanism</a>.
     * 
     * @param scope
     */
    public void setScope( String scope )
    {
        this.scope = scope;
    } //-- void setScope( String )

    /**
     * Set fOR SYSTEM SCOPE ONLY. Note that use of this property is
     * <b>discouraged</b>
     *             and may be replaced in later versions. This
     * specifies the path on the filesystem
     *             for this dependency.
     *             Requires an absolute path for the value, not
     * relative.
     *             Use a property that gives the machine specific
     * absolute path,
     *             e.g. <code>${java.home}</code>.
     * 
     * @param systemPath
     */
    public void setSystemPath( String systemPath )
    {
        this.systemPath = systemPath;
    } //-- void setSystemPath( String )

    /**
     * Set the type of dependency. This defaults to
     * <code>jar</code>. While it
     *             usually represents the extension on the filename
     * of the dependency,
     *             that is not always the case. A type can be
     * mapped to a different
     *             extension and a classifier.
     *             The type often correspongs to the packaging
     * used, though this is also
     *             not always the case.
     *             Some examples are <code>jar</code>,
     * <code>war</code>, <code>ejb-client</code>
     *             and <code>test-jar</code>.
     *             New types can be defined by plugins that set
     *             <code>extensions</code> to <code>true</code>, so
     * this is not a complete list.
     * 
     * @param type
     */
    public void setType( String type )
    {
        this.type = type;
    } //-- void setType( String )

    /**
     * Set the version of the dependency, e.g. <code>3.2.1</code>.
     * In Maven 2, this can also be
     *             specified as a range of versions.
     * 
     * @param version
     */
    public void setVersion( String version )
    {
        this.version = version;
    } //-- void setVersion( String )


            
    /**
     * @see java.lang.Object#toString()
     */
    public String toString()
    {
        return "Dependency {groupId=" + groupId + ", artifactId=" + artifactId + ", version=" + version + ", type=" + type + "}";
    }
            
          
            
    /**
     * @return the management key as <code>groupId:artifactId:type</code>
     */
    public String getManagementKey()
    {
        return groupId + ":" + artifactId + ":" + type + ( classifier != null ? ":" + classifier : "" );
    }
            
          
}
