/*
 * $Id$
 */

package org.apache.maven.model;

/**
 * 
 *         Describes where an artifact has moved to. If any of the
 * values
 *         are omitted, it is assumed to be the same as it was
 * before.
 *       
 * 
 * @version $Revision$ $Date$
 */
public class Relocation implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field groupId
     */
    private String groupId;

    /**
     * Field artifactId
     */
    private String artifactId;

    /**
     * Field version
     */
    private String version;

    /**
     * Field message
     */
    private String message;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Get 
     *             The new artifact ID of the artifact.
     *           
     */
    public String getArtifactId()
    {
        return this.artifactId;
    } //-- String getArtifactId() 

    /**
     * Get 
     *             The group ID the artifact has moved to.
     *           
     */
    public String getGroupId()
    {
        return this.groupId;
    } //-- String getGroupId() 

    /**
     * Get 
     *             An additional message to show the user about the
     * move, such
     *             as the reason.
     *           
     */
    public String getMessage()
    {
        return this.message;
    } //-- String getMessage() 

    /**
     * Get The new version of the artifact.
     */
    public String getVersion()
    {
        return this.version;
    } //-- String getVersion() 

    /**
     * Set 
     *             The new artifact ID of the artifact.
     *           
     * 
     * @param artifactId
     */
    public void setArtifactId(String artifactId)
    {
        this.artifactId = artifactId;
    } //-- void setArtifactId(String) 

    /**
     * Set 
     *             The group ID the artifact has moved to.
     *           
     * 
     * @param groupId
     */
    public void setGroupId(String groupId)
    {
        this.groupId = groupId;
    } //-- void setGroupId(String) 

    /**
     * Set 
     *             An additional message to show the user about the
     * move, such
     *             as the reason.
     *           
     * 
     * @param message
     */
    public void setMessage(String message)
    {
        this.message = message;
    } //-- void setMessage(String) 

    /**
     * Set The new version of the artifact.
     * 
     * @param version
     */
    public void setVersion(String version)
    {
        this.version = version;
    } //-- void setVersion(String) 


    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }}
