/*
 * $Id$
 */

package org.apache.maven.model;

/**
 * 
 *          A repository contains the information needed
 *          for establishing connections with remote repository.
 *       
 * 
 * @version $Revision$ $Date$
 */
public class RepositoryBase implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field id
     */
    private String id;

    /**
     * Field name
     */
    private String name;

    /**
     * Field url
     */
    private String url;

    /**
     * Field layout
     */
    private String layout = "default";


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Get 
     *             A unique identifier for a repository. This is
     * used to match the repository to configuration in
     *             the <code>settings.xml</code> file, for example.
     *           
     */
    public String getId()
    {
        return this.id;
    } //-- String getId() 

    /**
     * Get 
     *             The type of layout this repository uses for
     * locating and storing artifacts - can be <code>legacy</code>
     * or
     *             <code>default</code>.
     *           
     */
    public String getLayout()
    {
        return this.layout;
    } //-- String getLayout() 

    /**
     * Get 
     *             Human readable name of the repository.
     *           
     */
    public String getName()
    {
        return this.name;
    } //-- String getName() 

    /**
     * Get 
     *              The url of the repository, in the form
     * <code>protocol://hostname/path</code>.
     *           
     */
    public String getUrl()
    {
        return this.url;
    } //-- String getUrl() 

    /**
     * Set 
     *             A unique identifier for a repository. This is
     * used to match the repository to configuration in
     *             the <code>settings.xml</code> file, for example.
     *           
     * 
     * @param id
     */
    public void setId(String id)
    {
        this.id = id;
    } //-- void setId(String) 

    /**
     * Set 
     *             The type of layout this repository uses for
     * locating and storing artifacts - can be <code>legacy</code>
     * or
     *             <code>default</code>.
     *           
     * 
     * @param layout
     */
    public void setLayout(String layout)
    {
        this.layout = layout;
    } //-- void setLayout(String) 

    /**
     * Set 
     *             Human readable name of the repository.
     *           
     * 
     * @param name
     */
    public void setName(String name)
    {
        this.name = name;
    } //-- void setName(String) 

    /**
     * Set 
     *              The url of the repository, in the form
     * <code>protocol://hostname/path</code>.
     *           
     * 
     * @param url
     */
    public void setUrl(String url)
    {
        this.url = url;
    } //-- void setUrl(String) 


            public boolean equals( Object obj )
            {
                RepositoryBase other =  (RepositoryBase) obj;

                boolean retValue = false;

                if ( id != null )
                {
                    retValue = id.equals( other.id );
                }

                return retValue;
            }
          
    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }}
