/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.composite;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;

public class CompositeVerifyQuery
extends Query {
    final Query indexQuery;
    final ValueSource predicateValueSource;

    public CompositeVerifyQuery(Query indexQuery, ValueSource predicateValueSource) {
        this.indexQuery = indexQuery;
        this.predicateValueSource = predicateValueSource;
    }

    public Query rewrite(IndexReader reader) throws IOException {
        if (this.getBoost() != 1.0f) {
            return super.rewrite(reader);
        }
        Query rewritten = this.indexQuery.rewrite(reader);
        if (rewritten != this.indexQuery) {
            return new CompositeVerifyQuery(rewritten, this.predicateValueSource);
        }
        return super.rewrite(reader);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CompositeVerifyQuery that = (CompositeVerifyQuery)((Object)o);
        if (!this.indexQuery.equals((Object)that.indexQuery)) {
            return false;
        }
        return this.predicateValueSource.equals((Object)that.predicateValueSource);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.indexQuery.hashCode();
        result = 31 * result + this.predicateValueSource.hashCode();
        return result;
    }

    public String toString(String field) {
        return ((Object)((Object)this)).getClass().getSimpleName() + "(" + this.indexQuery.toString(field) + ", " + this.predicateValueSource + ")";
    }

    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        final Weight indexQueryWeight = this.indexQuery.createWeight(searcher, false);
        final Map valueSourceContext = ValueSource.newContext((IndexSearcher)searcher);
        return new ConstantScoreWeight(this){

            public Scorer scorer(LeafReaderContext context) throws IOException {
                final Scorer indexQueryScorer = indexQueryWeight.scorer(context);
                if (indexQueryScorer == null) {
                    return null;
                }
                final FunctionValues predFuncValues = CompositeVerifyQuery.this.predicateValueSource.getValues(valueSourceContext, context);
                TwoPhaseIterator twoPhaseIterator = new TwoPhaseIterator((DocIdSetIterator)indexQueryScorer){

                    public boolean matches() throws IOException {
                        return predFuncValues.boolVal(indexQueryScorer.docID());
                    }

                    public float matchCost() {
                        return 100.0f;
                    }
                };
                return new ConstantScoreScorer((Weight)this, this.score(), twoPhaseIterator);
            }
        };
    }
}

