/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.sampling;

import java.io.IOException;
import java.util.Random;
import org.apache.lucene.facet.old.ScoredDocIDs;
import org.apache.lucene.facet.old.ScoredDocIDsIterator;
import org.apache.lucene.facet.old.ScoredDocIdsUtils;
import org.apache.lucene.facet.sampling.Sampler;
import org.apache.lucene.facet.sampling.SamplingParams;

public class RandomSampler
extends Sampler {
    private final Random random;

    public RandomSampler() {
        this.random = new Random();
    }

    public RandomSampler(SamplingParams params, Random random) throws IllegalArgumentException {
        super(params);
        this.random = random;
    }

    @Override
    protected Sampler.SampleResult createSample(ScoredDocIDs docids, int actualSize, int sampleSetSize) throws IOException {
        int[] sample = new int[sampleSetSize];
        int maxStep = actualSize * 2 / sampleSetSize;
        int remaining = actualSize;
        ScoredDocIDsIterator it = docids.iterator();
        int i = 0;
        while (i < sample.length && remaining > sampleSetSize - maxStep - i) {
            int skipStep = 1 + this.random.nextInt(maxStep);
            for (int j = 0; j < skipStep; ++j) {
                it.next();
                --remaining;
            }
            sample[i++] = it.getDocID();
        }
        while (i < sample.length) {
            it.next();
            sample[i++] = it.getDocID();
        }
        ScoredDocIDs sampleRes = ScoredDocIdsUtils.createScoredDocIDsSubset(docids, sample);
        Sampler.SampleResult res = new Sampler.SampleResult(sampleRes, (double)sampleSetSize / (double)actualSize);
        return res;
    }
}

