/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.compound;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;

public abstract class CompoundWordTokenFilterBase
extends TokenFilter {
    public static final int DEFAULT_MIN_WORD_SIZE = 5;
    public static final int DEFAULT_MIN_SUBWORD_SIZE = 2;
    public static final int DEFAULT_MAX_SUBWORD_SIZE = 15;
    protected final CharArraySet dictionary;
    protected final LinkedList tokens = new LinkedList();
    protected final int minWordSize;
    protected final int minSubwordSize;
    protected final int maxSubwordSize;
    protected final boolean onlyLongestMatch;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected CompoundWordTokenFilterBase(TokenStream input, String[] dictionary, int minWordSize, int minSubwordSize, int maxSubwordSize, boolean onlyLongestMatch) {
        this(input, CompoundWordTokenFilterBase.makeDictionary(dictionary), minWordSize, minSubwordSize, maxSubwordSize, onlyLongestMatch);
    }

    protected CompoundWordTokenFilterBase(TokenStream input, String[] dictionary, boolean onlyLongestMatch) {
        this(input, CompoundWordTokenFilterBase.makeDictionary(dictionary), 5, 2, 15, onlyLongestMatch);
    }

    protected CompoundWordTokenFilterBase(TokenStream input, Set dictionary, boolean onlyLongestMatch) {
        this(input, dictionary, 5, 2, 15, onlyLongestMatch);
    }

    protected CompoundWordTokenFilterBase(TokenStream input, String[] dictionary) {
        this(input, CompoundWordTokenFilterBase.makeDictionary(dictionary), 5, 2, 15, false);
    }

    protected CompoundWordTokenFilterBase(TokenStream input, Set dictionary) {
        this(input, dictionary, 5, 2, 15, false);
    }

    protected CompoundWordTokenFilterBase(TokenStream input, Set dictionary, int minWordSize, int minSubwordSize, int maxSubwordSize, boolean onlyLongestMatch) {
        super(input);
        this.minWordSize = minWordSize;
        this.minSubwordSize = minSubwordSize;
        this.maxSubwordSize = maxSubwordSize;
        this.onlyLongestMatch = onlyLongestMatch;
        if (dictionary instanceof CharArraySet) {
            this.dictionary = (CharArraySet)dictionary;
        } else {
            this.dictionary = new CharArraySet(dictionary.size(), false);
            CompoundWordTokenFilterBase.addAllLowerCase((Set)this.dictionary, dictionary);
        }
    }

    public static final Set makeDictionary(String[] dictionary) {
        CharArraySet dict = new CharArraySet(dictionary.length, false);
        CompoundWordTokenFilterBase.addAllLowerCase((Set)dict, Arrays.asList(dictionary));
        return dict;
    }

    public Token next(Token reusableToken) throws IOException {
        if (!$assertionsDisabled && reusableToken == null) {
            throw new AssertionError();
        }
        if (this.tokens.size() > 0) {
            return (Token)this.tokens.removeFirst();
        }
        Token nextToken = this.input.next(reusableToken);
        if (nextToken == null) {
            return null;
        }
        this.decompose(nextToken);
        if (this.tokens.size() > 0) {
            return (Token)this.tokens.removeFirst();
        }
        return null;
    }

    protected static final void addAllLowerCase(Set target, Collection col) {
        Iterator iter = col.iterator();
        while (iter.hasNext()) {
            target.add(((String)iter.next()).toLowerCase());
        }
    }

    protected static char[] makeLowerCaseCopy(char[] buffer) {
        char[] result = new char[buffer.length];
        System.arraycopy(buffer, 0, result, 0, buffer.length);
        for (int i = 0; i < buffer.length; ++i) {
            result[i] = Character.toLowerCase(buffer[i]);
        }
        return result;
    }

    protected final Token createToken(int offset, int length, Token prototype) {
        int newStart = prototype.startOffset() + offset;
        Token t = prototype.clone(prototype.termBuffer(), offset, length, newStart, newStart + length);
        t.setPositionIncrement(0);
        return t;
    }

    protected void decompose(Token token) {
        this.tokens.add((Token)token.clone());
        if (token.termLength() < this.minWordSize) {
            return;
        }
        this.decomposeInternal(token);
    }

    protected abstract void decomposeInternal(Token var1);

    static {
        $assertionsDisabled = !CompoundWordTokenFilterBase.class.desiredAssertionStatus();
    }
}

