/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.web;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.lookup.Interpolator;
import org.apache.logging.log4j.core.lookup.StrLookup;
import org.apache.logging.log4j.core.lookup.StrSubstitutor;

public class Log4jContextListener
implements ServletContextListener {
    public static final String LOG4J_CONTEXT_ATTRIBUTE = "Log4jContext";
    public static final String LOG4J_CONFIG = "log4jConfiguration";
    public static final String LOG4J_CONTEXT_NAME = "log4jContextName";
    private final StrSubstitutor subst = new StrSubstitutor((StrLookup)new Interpolator());

    public void contextInitialized(ServletContextEvent event) {
        ServletContext context = event.getServletContext();
        String locn = this.subst.replace(context.getInitParameter(LOG4J_CONFIG));
        String name = this.subst.replace(context.getInitParameter(LOG4J_CONTEXT_NAME));
        if (name == null) {
            name = context.getServletContextName();
        }
        if (name == null && locn == null) {
            context.log("No Log4j context configuration provided");
            return;
        }
        context.setAttribute(LOG4J_CONTEXT_ATTRIBUTE, (Object)Configurator.initialize((String)name, (ClassLoader)this.getClassLoader(context), (String)locn));
    }

    public void contextDestroyed(ServletContextEvent event) {
        LoggerContext ctx = (LoggerContext)event.getServletContext().getAttribute(LOG4J_CONTEXT_ATTRIBUTE);
        Configurator.shutdown((LoggerContext)ctx);
    }

    private ClassLoader getClassLoader(ServletContext context) {
        try {
            return (ClassLoader)context.getClass().getMethod("getClassLoader", new Class[0]).invoke((Object)context, new Object[0]);
        }
        catch (Exception ignore) {
            return Log4jContextListener.class.getClassLoader();
        }
    }
}

