/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.util;

import java.util.Collection;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.common.MetadataVersion;

public final class SnapshotReason {
    public static final SnapshotReason UNKNOWN = new SnapshotReason("unknown reason");
    private final String reason;

    public static SnapshotReason maxBytesExceeded(long bytes, long maxBytes) {
        return new SnapshotReason(String.format("%s bytes exceeded the maximum bytes of %s", bytes, maxBytes));
    }

    public static SnapshotReason maxIntervalExceeded(long interval, long maxInterval) {
        return new SnapshotReason(String.format("%s ms exceeded the maximum snapshot interval of %s ms", interval, maxInterval));
    }

    public static SnapshotReason metadataVersionChanged(MetadataVersion metadataVersion) {
        return new SnapshotReason(String.format("metadata version was changed to %s", metadataVersion));
    }

    public static String stringFromReasons(Collection<SnapshotReason> reasons) {
        return Utils.join(reasons, (String)", ");
    }

    private SnapshotReason(String reason) {
        this.reason = reason;
    }

    public String toString() {
        return this.reason;
    }
}

