/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// THIS CODE IS AUTOMATICALLY GENERATED.  DO NOT EDIT.

package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;
import org.apache.kafka.common.utils.Bytes;

import static org.apache.kafka.common.protocol.types.Field.TaggedFieldsSection;


public class ConsumerGroupHeartbeatResponseData implements ApiMessage {
    int throttleTimeMs;
    short errorCode;
    String errorMessage;
    String memberId;
    int memberEpoch;
    boolean shouldComputeAssignment;
    int heartbeatIntervalMs;
    Assignment assignment;
    private List<RawTaggedField> _unknownTaggedFields;
    
    public static final Schema SCHEMA_0 =
        new Schema(
            new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."),
            new Field("error_code", Type.INT16, "The top-level error code, or 0 if there was no error"),
            new Field("error_message", Type.COMPACT_NULLABLE_STRING, "The top-level error message, or null if there was no error."),
            new Field("member_id", Type.COMPACT_NULLABLE_STRING, "The member id generated by the coordinator. Only provided when the member joins with MemberEpoch == 0."),
            new Field("member_epoch", Type.INT32, "The member epoch."),
            new Field("should_compute_assignment", Type.BOOLEAN, "True if the member should compute the assignment for the group."),
            new Field("heartbeat_interval_ms", Type.INT32, "The heartbeat interval in milliseconds."),
            new Field("assignment", Assignment.SCHEMA_0, "null if not provided; the assignment otherwise."),
            TaggedFieldsSection.of(
            )
        );
    
    public static final Schema[] SCHEMAS = new Schema[] {
        SCHEMA_0
    };
    
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;
    
    public ConsumerGroupHeartbeatResponseData(Readable _readable, short _version) {
        read(_readable, _version);
    }
    
    public ConsumerGroupHeartbeatResponseData() {
        this.throttleTimeMs = 0;
        this.errorCode = (short) 0;
        this.errorMessage = null;
        this.memberId = null;
        this.memberEpoch = 0;
        this.shouldComputeAssignment = false;
        this.heartbeatIntervalMs = 0;
        this.assignment = null;
    }
    
    @Override
    public short apiKey() {
        return 68;
    }
    
    @Override
    public short lowestSupportedVersion() {
        return 0;
    }
    
    @Override
    public short highestSupportedVersion() {
        return 0;
    }
    
    @Override
    public void read(Readable _readable, short _version) {
        this.throttleTimeMs = _readable.readInt();
        this.errorCode = _readable.readShort();
        {
            int length;
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                this.errorMessage = null;
            } else if (length > 0x7fff) {
                throw new RuntimeException("string field errorMessage had invalid length " + length);
            } else {
                this.errorMessage = _readable.readString(length);
            }
        }
        {
            int length;
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                this.memberId = null;
            } else if (length > 0x7fff) {
                throw new RuntimeException("string field memberId had invalid length " + length);
            } else {
                this.memberId = _readable.readString(length);
            }
        }
        this.memberEpoch = _readable.readInt();
        this.shouldComputeAssignment = _readable.readByte() != 0;
        this.heartbeatIntervalMs = _readable.readInt();
        {
            if (_readable.readByte() < 0) {
                this.assignment = null;
            } else {
                this.assignment = new Assignment(_readable, _version);
            }
        }
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; _i++) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default:
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                    break;
            }
        }
    }
    
    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _writable.writeInt(throttleTimeMs);
        _writable.writeShort(errorCode);
        if (errorMessage == null) {
            _writable.writeUnsignedVarint(0);
        } else {
            byte[] _stringBytes = _cache.getSerializedValue(errorMessage);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
        }
        if (memberId == null) {
            _writable.writeUnsignedVarint(0);
        } else {
            byte[] _stringBytes = _cache.getSerializedValue(memberId);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
        }
        _writable.writeInt(memberEpoch);
        _writable.writeByte(shouldComputeAssignment ? (byte) 1 : (byte) 0);
        _writable.writeInt(heartbeatIntervalMs);
        if (assignment == null) {
            _writable.writeByte((byte) -1);
        } else {
            _writable.writeByte((byte) 1);
            assignment.write(_writable, _cache, _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(_unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        _writable.writeUnsignedVarint(_numTaggedFields);
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }
    
    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _size.addBytes(4);
        _size.addBytes(2);
        if (errorMessage == null) {
            _size.addBytes(1);
        } else {
            byte[] _stringBytes = errorMessage.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > 0x7fff) {
                throw new RuntimeException("'errorMessage' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(errorMessage, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
        }
        if (memberId == null) {
            _size.addBytes(1);
        } else {
            byte[] _stringBytes = memberId.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > 0x7fff) {
                throw new RuntimeException("'memberId' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(memberId, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
        }
        _size.addBytes(4);
        _size.addBytes(1);
        _size.addBytes(4);
        if (assignment == null) {
            _size.addBytes(1);
        } else {
            _size.addBytes(1);
            this.assignment.addSize(_size, _cache, _version);
        }
        if (_unknownTaggedFields != null) {
            _numTaggedFields += _unknownTaggedFields.size();
            for (RawTaggedField _field : _unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
    }
    
    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ConsumerGroupHeartbeatResponseData)) return false;
        ConsumerGroupHeartbeatResponseData other = (ConsumerGroupHeartbeatResponseData) obj;
        if (throttleTimeMs != other.throttleTimeMs) return false;
        if (errorCode != other.errorCode) return false;
        if (this.errorMessage == null) {
            if (other.errorMessage != null) return false;
        } else {
            if (!this.errorMessage.equals(other.errorMessage)) return false;
        }
        if (this.memberId == null) {
            if (other.memberId != null) return false;
        } else {
            if (!this.memberId.equals(other.memberId)) return false;
        }
        if (memberEpoch != other.memberEpoch) return false;
        if (shouldComputeAssignment != other.shouldComputeAssignment) return false;
        if (heartbeatIntervalMs != other.heartbeatIntervalMs) return false;
        if (this.assignment == null) {
            if (other.assignment != null) return false;
        } else {
            if (!this.assignment.equals(other.assignment)) return false;
        }
        return MessageUtil.compareRawTaggedFields(_unknownTaggedFields, other._unknownTaggedFields);
    }
    
    @Override
    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + throttleTimeMs;
        hashCode = 31 * hashCode + errorCode;
        hashCode = 31 * hashCode + (errorMessage == null ? 0 : errorMessage.hashCode());
        hashCode = 31 * hashCode + (memberId == null ? 0 : memberId.hashCode());
        hashCode = 31 * hashCode + memberEpoch;
        hashCode = 31 * hashCode + (shouldComputeAssignment ? 1231 : 1237);
        hashCode = 31 * hashCode + heartbeatIntervalMs;
        hashCode = 31 * hashCode + (assignment == null ? 0 : assignment.hashCode());
        return hashCode;
    }
    
    @Override
    public ConsumerGroupHeartbeatResponseData duplicate() {
        ConsumerGroupHeartbeatResponseData _duplicate = new ConsumerGroupHeartbeatResponseData();
        _duplicate.throttleTimeMs = throttleTimeMs;
        _duplicate.errorCode = errorCode;
        if (errorMessage == null) {
            _duplicate.errorMessage = null;
        } else {
            _duplicate.errorMessage = errorMessage;
        }
        if (memberId == null) {
            _duplicate.memberId = null;
        } else {
            _duplicate.memberId = memberId;
        }
        _duplicate.memberEpoch = memberEpoch;
        _duplicate.shouldComputeAssignment = shouldComputeAssignment;
        _duplicate.heartbeatIntervalMs = heartbeatIntervalMs;
        if (assignment == null) {
            _duplicate.assignment = null;
        } else {
            _duplicate.assignment = assignment.duplicate();
        }
        return _duplicate;
    }
    
    @Override
    public String toString() {
        return "ConsumerGroupHeartbeatResponseData("
            + "throttleTimeMs=" + throttleTimeMs
            + ", errorCode=" + errorCode
            + ", errorMessage=" + ((errorMessage == null) ? "null" : "'" + errorMessage.toString() + "'")
            + ", memberId=" + ((memberId == null) ? "null" : "'" + memberId.toString() + "'")
            + ", memberEpoch=" + memberEpoch
            + ", shouldComputeAssignment=" + (shouldComputeAssignment ? "true" : "false")
            + ", heartbeatIntervalMs=" + heartbeatIntervalMs
            + ", assignment=" + ((assignment == null) ? "null" : assignment.toString())
            + ")";
    }
    
    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }
    
    public short errorCode() {
        return this.errorCode;
    }
    
    public String errorMessage() {
        return this.errorMessage;
    }
    
    public String memberId() {
        return this.memberId;
    }
    
    public int memberEpoch() {
        return this.memberEpoch;
    }
    
    public boolean shouldComputeAssignment() {
        return this.shouldComputeAssignment;
    }
    
    public int heartbeatIntervalMs() {
        return this.heartbeatIntervalMs;
    }
    
    public Assignment assignment() {
        return this.assignment;
    }
    
    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (_unknownTaggedFields == null) {
            _unknownTaggedFields = new ArrayList<>(0);
        }
        return _unknownTaggedFields;
    }
    
    public ConsumerGroupHeartbeatResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }
    
    public ConsumerGroupHeartbeatResponseData setErrorCode(short v) {
        this.errorCode = v;
        return this;
    }
    
    public ConsumerGroupHeartbeatResponseData setErrorMessage(String v) {
        this.errorMessage = v;
        return this;
    }
    
    public ConsumerGroupHeartbeatResponseData setMemberId(String v) {
        this.memberId = v;
        return this;
    }
    
    public ConsumerGroupHeartbeatResponseData setMemberEpoch(int v) {
        this.memberEpoch = v;
        return this;
    }
    
    public ConsumerGroupHeartbeatResponseData setShouldComputeAssignment(boolean v) {
        this.shouldComputeAssignment = v;
        return this;
    }
    
    public ConsumerGroupHeartbeatResponseData setHeartbeatIntervalMs(int v) {
        this.heartbeatIntervalMs = v;
        return this;
    }
    
    public ConsumerGroupHeartbeatResponseData setAssignment(Assignment v) {
        this.assignment = v;
        return this;
    }
    
    public static class Assignment implements Message {
        byte error;
        List<TopicPartitions> assignedTopicPartitions;
        List<TopicPartitions> pendingTopicPartitions;
        short metadataVersion;
        byte[] metadataBytes;
        private List<RawTaggedField> _unknownTaggedFields;
        
        public static final Schema SCHEMA_0 =
            new Schema(
                new Field("error", Type.INT8, "The assigned error."),
                new Field("assigned_topic_partitions", new CompactArrayOf(TopicPartitions.SCHEMA_0), "The partitions assigned to the member that can be used immediately."),
                new Field("pending_topic_partitions", new CompactArrayOf(TopicPartitions.SCHEMA_0), "The partitions assigned to the member that cannot be used because they are not released by their former owners yet."),
                new Field("metadata_version", Type.INT16, "The version of the metadata."),
                new Field("metadata_bytes", Type.COMPACT_BYTES, "The assigned metadata."),
                TaggedFieldsSection.of(
                )
            );
        
        public static final Schema[] SCHEMAS = new Schema[] {
            SCHEMA_0
        };
        
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;
        
        public Assignment(Readable _readable, short _version) {
            read(_readable, _version);
        }
        
        public Assignment() {
            this.error = (byte) 0;
            this.assignedTopicPartitions = new ArrayList<TopicPartitions>(0);
            this.pendingTopicPartitions = new ArrayList<TopicPartitions>(0);
            this.metadataVersion = (short) 0;
            this.metadataBytes = Bytes.EMPTY;
        }
        
        
        @Override
        public short lowestSupportedVersion() {
            return 0;
        }
        
        @Override
        public short highestSupportedVersion() {
            return 0;
        }
        
        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of Assignment");
            }
            this.error = _readable.readByte();
            {
                int arrayLength;
                arrayLength = _readable.readUnsignedVarint() - 1;
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field assignedTopicPartitions was serialized as null");
                } else {
                    if (arrayLength > _readable.remaining()) {
                        throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                    }
                    ArrayList<TopicPartitions> newCollection = new ArrayList<>(arrayLength);
                    for (int i = 0; i < arrayLength; i++) {
                        newCollection.add(new TopicPartitions(_readable, _version));
                    }
                    this.assignedTopicPartitions = newCollection;
                }
            }
            {
                int arrayLength;
                arrayLength = _readable.readUnsignedVarint() - 1;
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field pendingTopicPartitions was serialized as null");
                } else {
                    if (arrayLength > _readable.remaining()) {
                        throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                    }
                    ArrayList<TopicPartitions> newCollection = new ArrayList<>(arrayLength);
                    for (int i = 0; i < arrayLength; i++) {
                        newCollection.add(new TopicPartitions(_readable, _version));
                    }
                    this.pendingTopicPartitions = newCollection;
                }
            }
            this.metadataVersion = _readable.readShort();
            {
                int length;
                length = _readable.readUnsignedVarint() - 1;
                if (length < 0) {
                    throw new RuntimeException("non-nullable field metadataBytes was serialized as null");
                } else {
                    byte[] newBytes = _readable.readArray(length);
                    this.metadataBytes = newBytes;
                }
            }
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; _i++) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default:
                        this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                        break;
                }
            }
        }
        
        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            _writable.writeByte(error);
            _writable.writeUnsignedVarint(assignedTopicPartitions.size() + 1);
            for (TopicPartitions assignedTopicPartitionsElement : assignedTopicPartitions) {
                assignedTopicPartitionsElement.write(_writable, _cache, _version);
            }
            _writable.writeUnsignedVarint(pendingTopicPartitions.size() + 1);
            for (TopicPartitions pendingTopicPartitionsElement : pendingTopicPartitions) {
                pendingTopicPartitionsElement.write(_writable, _cache, _version);
            }
            _writable.writeShort(metadataVersion);
            _writable.writeUnsignedVarint(metadataBytes.length + 1);
            _writable.writeByteArray(metadataBytes);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(_unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }
        
        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of Assignment");
            }
            _size.addBytes(1);
            {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(assignedTopicPartitions.size() + 1));
                for (TopicPartitions assignedTopicPartitionsElement : assignedTopicPartitions) {
                    assignedTopicPartitionsElement.addSize(_size, _cache, _version);
                }
            }
            {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(pendingTopicPartitions.size() + 1));
                for (TopicPartitions pendingTopicPartitionsElement : pendingTopicPartitions) {
                    pendingTopicPartitionsElement.addSize(_size, _cache, _version);
                }
            }
            _size.addBytes(2);
            {
                _size.addBytes(metadataBytes.length);
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(metadataBytes.length + 1));
            }
            if (_unknownTaggedFields != null) {
                _numTaggedFields += _unknownTaggedFields.size();
                for (RawTaggedField _field : _unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }
        
        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof Assignment)) return false;
            Assignment other = (Assignment) obj;
            if (error != other.error) return false;
            if (this.assignedTopicPartitions == null) {
                if (other.assignedTopicPartitions != null) return false;
            } else {
                if (!this.assignedTopicPartitions.equals(other.assignedTopicPartitions)) return false;
            }
            if (this.pendingTopicPartitions == null) {
                if (other.pendingTopicPartitions != null) return false;
            } else {
                if (!this.pendingTopicPartitions.equals(other.pendingTopicPartitions)) return false;
            }
            if (metadataVersion != other.metadataVersion) return false;
            if (!Arrays.equals(this.metadataBytes, other.metadataBytes)) return false;
            return MessageUtil.compareRawTaggedFields(_unknownTaggedFields, other._unknownTaggedFields);
        }
        
        @Override
        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + error;
            hashCode = 31 * hashCode + (assignedTopicPartitions == null ? 0 : assignedTopicPartitions.hashCode());
            hashCode = 31 * hashCode + (pendingTopicPartitions == null ? 0 : pendingTopicPartitions.hashCode());
            hashCode = 31 * hashCode + metadataVersion;
            hashCode = 31 * hashCode + Arrays.hashCode(metadataBytes);
            return hashCode;
        }
        
        @Override
        public Assignment duplicate() {
            Assignment _duplicate = new Assignment();
            _duplicate.error = error;
            ArrayList<TopicPartitions> newAssignedTopicPartitions = new ArrayList<TopicPartitions>(assignedTopicPartitions.size());
            for (TopicPartitions _element : assignedTopicPartitions) {
                newAssignedTopicPartitions.add(_element.duplicate());
            }
            _duplicate.assignedTopicPartitions = newAssignedTopicPartitions;
            ArrayList<TopicPartitions> newPendingTopicPartitions = new ArrayList<TopicPartitions>(pendingTopicPartitions.size());
            for (TopicPartitions _element : pendingTopicPartitions) {
                newPendingTopicPartitions.add(_element.duplicate());
            }
            _duplicate.pendingTopicPartitions = newPendingTopicPartitions;
            _duplicate.metadataVersion = metadataVersion;
            _duplicate.metadataBytes = MessageUtil.duplicate(metadataBytes);
            return _duplicate;
        }
        
        @Override
        public String toString() {
            return "Assignment("
                + "error=" + error
                + ", assignedTopicPartitions=" + MessageUtil.deepToString(assignedTopicPartitions.iterator())
                + ", pendingTopicPartitions=" + MessageUtil.deepToString(pendingTopicPartitions.iterator())
                + ", metadataVersion=" + metadataVersion
                + ", metadataBytes=" + Arrays.toString(metadataBytes)
                + ")";
        }
        
        public byte error() {
            return this.error;
        }
        
        public List<TopicPartitions> assignedTopicPartitions() {
            return this.assignedTopicPartitions;
        }
        
        public List<TopicPartitions> pendingTopicPartitions() {
            return this.pendingTopicPartitions;
        }
        
        public short metadataVersion() {
            return this.metadataVersion;
        }
        
        public byte[] metadataBytes() {
            return this.metadataBytes;
        }
        
        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (_unknownTaggedFields == null) {
                _unknownTaggedFields = new ArrayList<>(0);
            }
            return _unknownTaggedFields;
        }
        
        public Assignment setError(byte v) {
            this.error = v;
            return this;
        }
        
        public Assignment setAssignedTopicPartitions(List<TopicPartitions> v) {
            this.assignedTopicPartitions = v;
            return this;
        }
        
        public Assignment setPendingTopicPartitions(List<TopicPartitions> v) {
            this.pendingTopicPartitions = v;
            return this;
        }
        
        public Assignment setMetadataVersion(short v) {
            this.metadataVersion = v;
            return this;
        }
        
        public Assignment setMetadataBytes(byte[] v) {
            this.metadataBytes = v;
            return this;
        }
    }
    
    public static class TopicPartitions implements Message {
        Uuid topicId;
        List<Integer> partitions;
        private List<RawTaggedField> _unknownTaggedFields;
        
        public static final Schema SCHEMA_0 =
            new Schema(
                new Field("topic_id", Type.UUID, "The topic ID."),
                new Field("partitions", new CompactArrayOf(Type.INT32), "The partitions."),
                TaggedFieldsSection.of(
                )
            );
        
        public static final Schema[] SCHEMAS = new Schema[] {
            SCHEMA_0
        };
        
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;
        
        public TopicPartitions(Readable _readable, short _version) {
            read(_readable, _version);
        }
        
        public TopicPartitions() {
            this.topicId = Uuid.ZERO_UUID;
            this.partitions = new ArrayList<Integer>(0);
        }
        
        
        @Override
        public short lowestSupportedVersion() {
            return 0;
        }
        
        @Override
        public short highestSupportedVersion() {
            return 32767;
        }
        
        @Override
        public void read(Readable _readable, short _version) {
            this.topicId = _readable.readUuid();
            {
                int arrayLength;
                arrayLength = _readable.readUnsignedVarint() - 1;
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field partitions was serialized as null");
                } else {
                    if (arrayLength > _readable.remaining()) {
                        throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                    }
                    ArrayList<Integer> newCollection = new ArrayList<>(arrayLength);
                    for (int i = 0; i < arrayLength; i++) {
                        newCollection.add(_readable.readInt());
                    }
                    this.partitions = newCollection;
                }
            }
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; _i++) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default:
                        this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                        break;
                }
            }
        }
        
        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            _writable.writeUuid(topicId);
            _writable.writeUnsignedVarint(partitions.size() + 1);
            for (Integer partitionsElement : partitions) {
                _writable.writeInt(partitionsElement);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(_unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }
        
        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            _size.addBytes(16);
            {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(partitions.size() + 1));
                _size.addBytes(partitions.size() * 4);
            }
            if (_unknownTaggedFields != null) {
                _numTaggedFields += _unknownTaggedFields.size();
                for (RawTaggedField _field : _unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }
        
        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof TopicPartitions)) return false;
            TopicPartitions other = (TopicPartitions) obj;
            if (!this.topicId.equals(other.topicId)) return false;
            if (this.partitions == null) {
                if (other.partitions != null) return false;
            } else {
                if (!this.partitions.equals(other.partitions)) return false;
            }
            return MessageUtil.compareRawTaggedFields(_unknownTaggedFields, other._unknownTaggedFields);
        }
        
        @Override
        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + topicId.hashCode();
            hashCode = 31 * hashCode + (partitions == null ? 0 : partitions.hashCode());
            return hashCode;
        }
        
        @Override
        public TopicPartitions duplicate() {
            TopicPartitions _duplicate = new TopicPartitions();
            _duplicate.topicId = topicId;
            ArrayList<Integer> newPartitions = new ArrayList<Integer>(partitions.size());
            for (Integer _element : partitions) {
                newPartitions.add(_element);
            }
            _duplicate.partitions = newPartitions;
            return _duplicate;
        }
        
        @Override
        public String toString() {
            return "TopicPartitions("
                + "topicId=" + topicId.toString()
                + ", partitions=" + MessageUtil.deepToString(partitions.iterator())
                + ")";
        }
        
        public Uuid topicId() {
            return this.topicId;
        }
        
        public List<Integer> partitions() {
            return this.partitions;
        }
        
        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (_unknownTaggedFields == null) {
                _unknownTaggedFields = new ArrayList<>(0);
            }
            return _unknownTaggedFields;
        }
        
        public TopicPartitions setTopicId(Uuid v) {
            this.topicId = v;
            return this;
        }
        
        public TopicPartitions setPartitions(List<Integer> v) {
            this.partitions = v;
            return this;
        }
    }
}
