/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.transaction.txn;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.jena.atlas.logging.FmtLog;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.dboe.base.file.Location;
import org.apache.jena.dboe.sys.Sys;
import org.apache.jena.dboe.transaction.txn.ComponentGroup;
import org.apache.jena.dboe.transaction.txn.ComponentId;
import org.apache.jena.dboe.transaction.txn.PrepareState;
import org.apache.jena.dboe.transaction.txn.QuorumGenerator;
import org.apache.jena.dboe.transaction.txn.SysTrans;
import org.apache.jena.dboe.transaction.txn.SysTransState;
import org.apache.jena.dboe.transaction.txn.Transaction;
import org.apache.jena.dboe.transaction.txn.TransactionCoordinatorState;
import org.apache.jena.dboe.transaction.txn.TransactionException;
import org.apache.jena.dboe.transaction.txn.TransactionalComponent;
import org.apache.jena.dboe.transaction.txn.TxnId;
import org.apache.jena.dboe.transaction.txn.TxnIdFactory;
import org.apache.jena.dboe.transaction.txn.TxnIdGenerator;
import org.apache.jena.dboe.transaction.txn.journal.Journal;
import org.apache.jena.dboe.transaction.txn.journal.JournalEntry;
import org.apache.jena.dboe.transaction.txn.journal.JournalEntryType;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.query.TxnType;
import org.slf4j.Logger;

public final class TransactionCoordinator {
    private static Logger log = Sys.syslog;
    private final Journal journal;
    private boolean configurable = true;
    private final ComponentGroup components = new ComponentGroup(new TransactionalComponent[0]);
    private ComponentGroup txnComponents = null;
    private List<ShutdownHook> shutdownHooks;
    private TxnIdGenerator txnIdGenerator = TxnIdFactory.txnIdGenSimple;
    private QuorumGenerator quorumGenerator = null;
    private Semaphore writersWaiting = new Semaphore(1, true);
    private ReadWriteLock exclusivitylock = new ReentrantReadWriteLock();
    private final AtomicLong dataVersion = new AtomicLong(0L);
    private Object coordinatorLock = new Object();
    private static final boolean promotionWaitForWriters = true;
    private Set<Transaction> activeTransactions = ConcurrentHashMap.newKeySet();
    private AtomicLong activeTransactionCount = new AtomicLong(0L);
    private AtomicLong activeReadersCount = new AtomicLong(0L);
    private AtomicLong activeWritersCount = new AtomicLong(0L);
    private final AtomicLong countBegin = new AtomicLong(0L);
    private final AtomicLong countBeginRead = new AtomicLong(0L);
    private final AtomicLong countBeginWrite = new AtomicLong(0L);
    private final AtomicLong countFinished = new AtomicLong(0L);

    public TransactionCoordinator(Location location) {
        this(Journal.create(location));
    }

    public TransactionCoordinator(Journal journal) {
        this(journal, null, new ArrayList<ShutdownHook>());
    }

    public TransactionCoordinator(Journal journal, List<TransactionalComponent> components) {
        this(journal, components, new ArrayList<ShutdownHook>());
    }

    private TransactionCoordinator(Journal journal, List<TransactionalComponent> txnComp, List<ShutdownHook> shutdownHooks) {
        this.journal = journal;
        this.shutdownHooks = new ArrayList<ShutdownHook>(shutdownHooks);
        if (txnComp != null) {
            txnComp.forEach(this.components::add);
        }
    }

    public TransactionCoordinator add(TransactionalComponent elt) {
        this.checklAllowModification();
        this.components.add(elt);
        return this;
    }

    public TransactionCoordinator remove(TransactionalComponent elt) {
        this.checklAllowModification();
        this.components.remove(elt.getComponentId());
        return this;
    }

    public void modify(Runnable action) {
        try {
            this.startExclusiveMode();
            this.configurable = true;
            action.run();
        }
        finally {
            this.configurable = false;
            this.finishExclusiveMode();
        }
    }

    public void add(ShutdownHook hook) {
        this.checklAllowModification();
        this.shutdownHooks.add(hook);
    }

    public void remove(ShutdownHook hook) {
        this.checklAllowModification();
        this.shutdownHooks.remove(hook);
    }

    public void setQuorumGenerator(QuorumGenerator qGen) {
        this.checklAllowModification();
        this.quorumGenerator = qGen;
    }

    public void start() {
        this.checklAllowModification();
        this.recovery();
        this.configurable = false;
    }

    private void recovery() {
        Iterator<JournalEntry> iter = this.journal.entries();
        if (!iter.hasNext()) {
            this.components.forEachComponent(c -> c.cleanStart());
            return;
        }
        log.info("Journal recovery start");
        this.components.forEachComponent(c -> c.startRecovery());
        ArrayList entries = new ArrayList();
        iter.forEachRemaining(entry -> {
            switch (entry.getType()) {
                case ABORT: {
                    entries.clear();
                    break;
                }
                case COMMIT: {
                    this.recover(entries);
                    entries.clear();
                    break;
                }
                case REDO: 
                case UNDO: {
                    entries.add(entry);
                }
            }
        });
        this.components.forEachComponent(c -> c.finishRecovery());
        this.journal.reset();
        log.info("Journal recovery end");
    }

    private void recover(List<JournalEntry> entries) {
        entries.forEach(e -> {
            if (e.getType() == JournalEntryType.UNDO) {
                Log.warn((Object)this, (String)"UNDO entry : not handled");
                return;
            }
            ComponentId cid = e.getComponentId();
            ByteBuffer bb = e.getByteBuffer();
            TransactionalComponent c = this.components.findComponent(cid);
            if (c == null) {
                Log.warn((Object)this, (String)("No component for " + cid));
                return;
            }
            c.recover(bb);
        });
    }

    public void setTxnIdGenerator(TxnIdGenerator generator) {
        this.txnIdGenerator = generator;
    }

    public Journal getJournal() {
        return this.journal;
    }

    public TransactionCoordinatorState detach(Transaction txn) {
        txn.detach();
        TransactionCoordinatorState coordinatorState = new TransactionCoordinatorState(txn);
        this.components.forEach((id, c) -> {
            SysTransState s = c.detach();
            coordinatorState.componentStates.put((ComponentId)id, s);
        });
        return coordinatorState;
    }

    public void attach(TransactionCoordinatorState coordinatorState) {
        Transaction txn = coordinatorState.transaction;
        txn.attach();
        coordinatorState.componentStates.forEach((id, obj) -> this.components.findComponent((ComponentId)id).attach((SysTransState)obj));
    }

    public void shutdown() {
        if (this.coordinatorLock == null) {
            return;
        }
        if (this.countActive() > 0L) {
            FmtLog.warn((Logger)log, (String)"Transactions active: W=%d, R=%d", (Object[])new Object[]{this.countActiveWriter(), this.countActiveReaders()});
        }
        this.components.forEach((id, c) -> c.shutdown());
        this.shutdownHooks.forEach(h -> h.shutdown());
        this.coordinatorLock = null;
        this.journal.close();
    }

    private void checklAllowModification() {
        if (!this.configurable) {
            throw new TransactionException("TransactionCoordinator configuration is locked");
        }
    }

    private void checkActive() {
        if (this.configurable) {
            throw new TransactionException("TransactionCoordinator has not been started");
        }
        this.checkNotShutdown();
    }

    private void checkNotShutdown() {
        if (this.coordinatorLock == null) {
            throw new TransactionException("TransactionCoordinator has been shutdown");
        }
    }

    private void releaseWriterLock() {
        int x = this.writersWaiting.availablePermits();
        if (x != 0) {
            throw new TransactionException("TransactionCoordinator: Probably mismatch of enable/disableWriter calls");
        }
        this.writersWaiting.release();
    }

    private boolean acquireWriterLock(boolean canBlock) {
        if (!canBlock) {
            return this.writersWaiting.tryAcquire();
        }
        try {
            this.writersWaiting.acquire();
            return true;
        }
        catch (InterruptedException e) {
            throw new TransactionException(e);
        }
    }

    public void startExclusiveMode() {
        this.startExclusiveMode(true);
    }

    public boolean tryExclusiveMode() {
        return this.tryExclusiveMode(false);
    }

    public boolean tryExclusiveMode(boolean canBlock) {
        return this.startExclusiveMode(canBlock);
    }

    private boolean startExclusiveMode(boolean canBlock) {
        if (canBlock) {
            this.exclusivitylock.writeLock().lock();
            return true;
        }
        return this.exclusivitylock.writeLock().tryLock();
    }

    public void finishExclusiveMode() {
        this.exclusivitylock.writeLock().unlock();
    }

    public void execExclusive(Runnable action) {
        this.startExclusiveMode();
        try {
            action.run();
        }
        finally {
            this.finishExclusiveMode();
        }
    }

    public void blockWriters() {
        this.acquireWriterLock(true);
    }

    public boolean tryBlockWriters() {
        return this.tryBlockWriters(false);
    }

    public boolean tryBlockWriters(boolean canBlock) {
        return this.acquireWriterLock(canBlock);
    }

    public void enableWriters() {
        this.releaseWriterLock();
    }

    public void execAsWriter(Runnable action) {
        this.blockWriters();
        try {
            action.run();
        }
        finally {
            this.enableWriters();
        }
    }

    public Transaction begin(TxnType txnType) {
        return this.begin(txnType, true);
    }

    public Transaction begin(TxnType txnType, boolean canBlock) {
        boolean b;
        Objects.nonNull(txnType);
        this.checkActive();
        if (canBlock) {
            this.exclusivitylock.readLock().lock();
        } else if (!this.exclusivitylock.readLock().tryLock()) {
            return null;
        }
        if (txnType == TxnType.WRITE && !(b = this.acquireWriterLock(canBlock))) {
            this.exclusivitylock.readLock().unlock();
            return null;
        }
        Transaction transaction = this.begin$(txnType);
        this.startActiveTransaction(transaction);
        transaction.begin();
        return transaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Transaction begin$(TxnType txnType) {
        Object object = this.coordinatorLock;
        synchronized (object) {
            this.checkActive();
            TxnId txnId = this.txnIdGenerator.generate();
            ArrayList<SysTrans> sysTransList = new ArrayList<SysTrans>();
            Transaction transaction = new Transaction(this, txnType, TransactionCoordinator.initialMode(txnType), txnId, this.dataVersion.get(), sysTransList);
            ComponentGroup txnComponents = this.chooseComponents(this.components, txnType);
            txnComponents.forEachComponent(elt -> {
                SysTrans sysTrans = new SysTrans((TransactionalComponent)elt, transaction, txnId);
                sysTransList.add(sysTrans);
            });
            txnComponents.forEachComponent(elt -> elt.begin(transaction));
            return transaction;
        }
    }

    private static ReadWrite initialMode(TxnType txnType) {
        return TxnType.initial((TxnType)txnType);
    }

    private ComponentGroup chooseComponents(ComponentGroup components, TxnType txnType) {
        if (this.quorumGenerator == null) {
            return components;
        }
        ComponentGroup cg = this.quorumGenerator.genQuorum(txnType);
        if (cg == null) {
            return components;
        }
        cg.forEach((id, c) -> {
            TransactionalComponent tcx = components.findComponent((ComponentId)id);
            if (!tcx.equals(c)) {
                log.warn("TransactionalComponent not in TransactionCoordinator's ComponentGroup");
            }
        });
        if (log.isDebugEnabled()) {
            log.debug("Custom ComponentGroup for transaction " + txnType + ": size=" + cg.size() + " of " + components.size());
        }
        return cg;
    }

    boolean promoteTxn(Transaction transaction, boolean readCommittedPromotion) {
        if (transaction.getMode() == ReadWrite.WRITE) {
            return true;
        }
        if (transaction.getTxnType() == TxnType.READ) {
            throw new TransactionException("promote: can't promote a READ transaction");
        }
        return this.promoteTxn$(transaction, readCommittedPromotion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean promoteTxn$(Transaction transaction, boolean readCommittedPromotion) {
        if (transaction.getTxnType() == TxnType.READ_COMMITTED_PROMOTE) {
            if (!this.promotionWaitForWriters()) {
                return false;
            }
            Object object = this.coordinatorLock;
            synchronized (object) {
                try {
                    transaction.promoteComponents();
                }
                catch (TransactionException ex) {
                    try {
                        transaction.abort();
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                    this.releaseWriterLock();
                    return false;
                }
                this.promoteActiveTransaction(transaction);
            }
            return true;
        }
        if (!this.checkNoInterveningCommits(transaction)) {
            return false;
        }
        if (!this.promotionWaitForWriters()) {
            return false;
        }
        Object object = this.coordinatorLock;
        synchronized (object) {
            if (!this.checkNoInterveningCommits(transaction)) {
                this.releaseWriterLock();
                return false;
            }
            try {
                transaction.promoteComponents();
            }
            catch (TransactionException ex) {
                try {
                    transaction.abort();
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                this.releaseWriterLock();
                return false;
            }
            this.promoteActiveTransaction(transaction);
        }
        return true;
    }

    private boolean checkNoInterveningCommits(Transaction transaction) {
        long currentEpoch;
        long txnEpoch = transaction.getDataVersion();
        return txnEpoch >= (currentEpoch = this.dataVersion.get());
    }

    private boolean promotionWaitForWriters() {
        return this.acquireWriterLock(true);
    }

    void completed(Transaction transaction) {
        this.finishActiveTransaction(transaction);
        this.journal.reset();
    }

    void executePrepare(Transaction transaction) {
        this.notifyPrepareStart(transaction);
        transaction.getComponents().forEach(sysTrans -> {
            TransactionalComponent c = sysTrans.getComponent();
            ByteBuffer data = c.commitPrepare(transaction);
            if (data != null) {
                PrepareState s = new PrepareState(c.getComponentId(), data);
                this.journal.write(s);
            }
        });
        this.notifyPrepareFinish(transaction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void executeCommit(Transaction transaction, Runnable commit, Runnable finish) {
        if (transaction.getMode() == ReadWrite.READ) {
            finish.run();
            this.notifyCommitFinish(transaction);
            return;
        }
        Object object = this.coordinatorLock;
        synchronized (object) {
            this.journal.sync();
            commit.run();
            this.journal.truncate(0L);
            finish.run();
            this.advanceDataVersion();
            this.notifyCommitFinish(transaction);
        }
    }

    private void advanceDataVersion() {
        this.dataVersion.incrementAndGet();
    }

    void executeAbort(Transaction transaction, Runnable abort) {
        this.notifyAbortStart(transaction);
        abort.run();
        this.notifyAbortFinish(transaction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startActiveTransaction(Transaction transaction) {
        Object object = this.coordinatorLock;
        synchronized (object) {
            this.countBegin.incrementAndGet();
            switch (transaction.getMode()) {
                case READ: {
                    this.countBeginRead.incrementAndGet();
                    this.activeReadersCount.incrementAndGet();
                    break;
                }
                case WRITE: {
                    this.countBeginWrite.incrementAndGet();
                    this.activeWritersCount.incrementAndGet();
                }
            }
            this.activeTransactionCount.incrementAndGet();
            this.activeTransactions.add(transaction);
        }
    }

    private void promoteActiveTransaction(Transaction transaction) {
        this.activeReadersCount.decrementAndGet();
        this.activeWritersCount.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishActiveTransaction(Transaction transaction) {
        Object object = this.coordinatorLock;
        synchronized (object) {
            boolean x = this.activeTransactions.remove(transaction);
            if (!x) {
                return;
            }
            this.countFinished.incrementAndGet();
            this.activeTransactionCount.decrementAndGet();
            switch (transaction.getMode()) {
                case READ: {
                    this.activeReadersCount.decrementAndGet();
                    break;
                }
                case WRITE: {
                    this.activeWritersCount.decrementAndGet();
                }
            }
        }
        this.exclusivitylock.readLock().unlock();
    }

    public long countActiveReaders() {
        return this.activeReadersCount.get();
    }

    public long countActiveWriter() {
        return this.activeWritersCount.get();
    }

    public long countActive() {
        return this.activeTransactionCount.get();
    }

    void notifyPrepareStart(Transaction transaction) {
    }

    void notifyPrepareFinish(Transaction transaction) {
    }

    private void notifyCommitStart(Transaction transaction) {
    }

    private void notifyCommitFinish(Transaction transaction) {
        if (transaction.getMode() == ReadWrite.WRITE) {
            this.releaseWriterLock();
        }
    }

    private void notifyAbortStart(Transaction transaction) {
    }

    private void notifyAbortFinish(Transaction transaction) {
        if (transaction.getMode() == ReadWrite.WRITE) {
            this.releaseWriterLock();
        }
    }

    void notifyEndStart(Transaction transaction) {
    }

    void notifyEndFinish(Transaction transaction) {
    }

    void notifyCompleteStart(Transaction transaction) {
    }

    void notifyCompleteFinish(Transaction transaction) {
    }

    public long countBegin() {
        return this.countBegin.get();
    }

    public long countBeginRead() {
        return this.countBeginRead.get();
    }

    public long countBeginWrite() {
        return this.countBeginWrite.get();
    }

    public long countFinished() {
        return this.countFinished.get();
    }

    @FunctionalInterface
    public static interface ShutdownHook {
        public void shutdown();
    }
}

