/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.transaction;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.lib.FileOps;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.dboe.migrate.L;
import org.apache.jena.dboe.transaction.txn.ComponentId;
import org.apache.jena.dboe.transaction.txn.TransactionalComponentLifecycle;
import org.apache.jena.dboe.transaction.txn.TxnId;
import org.apache.jena.query.ReadWrite;

public class TransInteger
extends TransactionalComponentLifecycle<IntegerState> {
    private final AtomicLong value = new AtomicLong(-1712L);
    private final String filename;
    static int counter = 0;
    private boolean recoveryAction = false;

    public TransInteger() {
        this(0L);
    }

    public TransInteger(long v) {
        this(v, ComponentId.allocLocal());
    }

    public TransInteger(long v, ComponentId componentId) {
        this(null, componentId);
        this.value.set(v);
    }

    public TransInteger(String filename, ComponentId cid) {
        super(cid);
        this.filename = filename;
        this.readLocation();
    }

    private void readLocation() {
        if (this.filename != null) {
            if (!FileOps.exists((String)this.filename)) {
                this.value.set(0L);
                this.writeLocation();
                return;
            }
            long x = TransInteger.read(this.filename);
            this.value.set(x);
        }
    }

    private void writeLocation() {
        this.writeLocation(this.value.get());
    }

    private void writeLocation(long value) {
        if (this.filename != null) {
            TransInteger.write(this.filename, value);
        }
    }

    private static long read(String filename) {
        try {
            String str = IO.readWholeFileAsUTF8((String)filename);
            if (str.endsWith("\n")) {
                str = str.substring(0, str.length() - 1);
            }
            str = str.trim();
            return Long.parseLong(str);
        }
        catch (IOException ex) {
            Log.error(TransInteger.class, (String)("IOException: " + ex.getMessage()), (Throwable)ex);
            IO.exception((IOException)ex);
        }
        catch (NumberFormatException ex) {
            Log.error(TransInteger.class, (String)("NumberformatException: " + ex.getMessage()));
            throw new InternalErrorException((Throwable)ex);
        }
        return Long.MIN_VALUE;
    }

    private static void write(String filename, long value) {
        try {
            L.writeStringAsUTF8((String)filename, (String)Long.toString(value));
        }
        catch (IOException iOException) {
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Override
    public void startRecovery() {
        this.recoveryAction = false;
    }

    @Override
    public void recover(ByteBuffer ref) {
        long x = ref.getLong();
        this.value.set(x);
        this.recoveryAction = true;
    }

    @Override
    public void finishRecovery() {
        if (this.recoveryAction) {
            this.writeLocation();
        }
    }

    @Override
    public void cleanStart() {
        this.recoveryAction = false;
    }

    public void inc() {
        this.checkWriteTxn();
        IntegerState ts = (IntegerState)this.getDataState();
        ++ts.txnValue;
    }

    public long set(long x) {
        this.checkWriteTxn();
        IntegerState ts = (IntegerState)this.getDataState();
        long v = ts.txnValue;
        ts.txnValue = x;
        return v;
    }

    public long read() {
        this.checkTxn();
        return ((IntegerState)this.getDataState()).txnValue;
    }

    public long get() {
        if (super.isActiveTxn()) {
            return ((IntegerState)this.getDataState()).txnValue;
        }
        return this.value.get();
    }

    public long value() {
        return this.value.get();
    }

    @Override
    protected IntegerState _begin(ReadWrite readWrite, TxnId txnId) {
        return this.createState();
    }

    private IntegerState createState() {
        return new IntegerState(this.value.get());
    }

    @Override
    protected IntegerState _promote(TxnId txnId, IntegerState state) {
        return this.createState();
    }

    @Override
    protected ByteBuffer _commitPrepare(TxnId txnId, IntegerState state) {
        if (this.isReadTxn()) {
            return null;
        }
        ByteBuffer x = ByteBuffer.allocate(8);
        x.putLong(state.txnValue);
        return x;
    }

    @Override
    protected void _commit(TxnId txnId, IntegerState state) {
        if (this.isReadTxn()) {
            return;
        }
        this.writeLocation(state.txnValue);
    }

    @Override
    protected void _commitEnd(TxnId txnId, IntegerState state) {
        if (this.isReadTxn()) {
            return;
        }
        this.value.set(state.txnValue);
    }

    @Override
    protected void _abort(TxnId txnId, IntegerState state) {
    }

    @Override
    protected void _complete(TxnId txnId, IntegerState state) {
    }

    @Override
    protected void _shutdown() {
    }

    public String toString() {
        return String.valueOf(super.getComponentId());
    }

    static class IntegerState {
        long txnValue;

        public IntegerState(long v) {
            this.txnValue = v;
        }
    }
}

