/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.json;

import java.math.BigDecimal;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.jena.atlas.json.JsonArray;
import org.apache.jena.atlas.json.JsonBoolean;
import org.apache.jena.atlas.json.JsonException;
import org.apache.jena.atlas.json.JsonNull;
import org.apache.jena.atlas.json.JsonNumber;
import org.apache.jena.atlas.json.JsonObject;
import org.apache.jena.atlas.json.JsonString;
import org.apache.jena.atlas.json.JsonValue;
import org.apache.jena.atlas.logging.Log;

public class JsonBuilder {
    private JsonValue builtValue = null;
    private static final String NoMarker = "";
    private Deque<String> markers = new ArrayDeque<String>();
    private Deque<JsonArray> arrays = new ArrayDeque<JsonArray>();
    private Deque<JsonObject> objects = new ArrayDeque<JsonObject>();
    private Deque<State> stack = new ArrayDeque<State>();
    private Deque<String> keys = new ArrayDeque<String>();
    private static String LABEL = "%|%object%|%";

    public static JsonBuilder create() {
        return new JsonBuilder();
    }

    public static JsonBuilder createFrom(JsonValue arg) {
        if (arg.isObject()) {
            JsonObject obj = arg.getAsObject();
            JsonBuilder builder = JsonBuilder.create();
            builder.startObject();
            obj.forEach((k, v) -> builder.key((String)k).value(JsonBuilder.copy(v)));
            builder.finishObject();
            return builder;
        }
        if (arg.isArray()) {
            JsonArray array = arg.getAsArray();
            JsonBuilder builder = JsonBuilder.create();
            builder.startArray();
            array.forEach(a -> builder.value(JsonBuilder.copy(a)));
            builder.finishArray();
            return builder;
        }
        throw new IllegalArgumentException("Not a JSON object or JSON array; " + arg);
    }

    public static JsonValue copy(JsonValue arg) {
        if (!arg.isArray() && !arg.isObject()) {
            return arg;
        }
        return JsonBuilder.createFrom(arg).build();
    }

    public static JsonObject buildObject(Consumer<JsonBuilder> setup) {
        JsonBuilder b = JsonBuilder.create().startObject(LABEL);
        setup.accept(b);
        return b.finishObject(LABEL).build().getAsObject();
    }

    public JsonValue build() {
        if (this.builtValue == null) {
            if (this.objects.isEmpty() && this.arrays.isEmpty()) {
                throw new JsonException("Alignment error: no object or array started");
            }
            throw new JsonException("Alignment error: unfinished outer object or array");
        }
        return this.builtValue;
    }

    public void reset() {
        this.builtValue = null;
        this.stack.clear();
        this.objects.clear();
        this.keys.clear();
        this.arrays.clear();
    }

    public JsonBuilder startObject() {
        return this.startObject(NoMarker);
    }

    public JsonBuilder startObject(String startMarker) {
        this.markers.push(startMarker);
        this.objects.push(new JsonObject());
        this.stack.push(State.OBJECT);
        return this;
    }

    public JsonBuilder finishObject() {
        return this.finishObject(NoMarker);
    }

    public JsonBuilder finishObject(String finishMarker) {
        String startMarker;
        if (this.stack.isEmpty()) {
            throw new JsonException("Alignment error : already built outer-most object or array");
        }
        State state = this.stack.pop();
        if (state != State.OBJECT) {
            throw new JsonException("JSON build error : not in an object");
        }
        JsonValue value = this.objects.pop();
        this.maybeObjectOrArray(value);
        if (this.stack.isEmpty()) {
            this.builtValue = value;
        }
        if (!Objects.equals(startMarker = this.markers.pop(), finishMarker)) {
            throw new JsonException("JSON build error : start/finish alignment error: start=" + startMarker + "  finish=" + finishMarker);
        }
        return this;
    }

    public JsonBuilder startArray() {
        this.arrays.push(new JsonArray());
        this.stack.push(State.ARRAY);
        return this;
    }

    public JsonBuilder finishArray() {
        if (this.stack.isEmpty()) {
            throw new JsonException("Alignment error : already built outer-most object or array");
        }
        State state = this.stack.pop();
        if (state != State.ARRAY) {
            throw new JsonException("JSON build error : not in an array");
        }
        JsonValue value = this.arrays.pop();
        this.maybeObjectOrArray(value);
        if (this.stack.isEmpty()) {
            this.builtValue = value;
        }
        return this;
    }

    public JsonBuilder pair(String key, JsonValue value) {
        this.key(key);
        this.value(value);
        return this;
    }

    public JsonBuilder pair(String key, boolean value) {
        this.key(key);
        this.value(value);
        return this;
    }

    public JsonBuilder pair(String key, BigDecimal value) {
        this.key(key);
        this.value(value);
        return this;
    }

    public JsonBuilder pair(String key, double value) {
        this.key(key);
        this.value(value);
        return this;
    }

    public JsonBuilder pair(String key, long value) {
        this.key(key);
        this.value(value);
        return this;
    }

    public JsonBuilder pair(String key, String value) {
        this.key(key);
        this.value(value);
        return this;
    }

    public JsonBuilder key(String key) {
        State state = this.stack.peek();
        if (state != State.OBJECT) {
            throw new JsonException("JSON build error : not in an object");
        }
        this.keys.push(key);
        return this;
    }

    private void maybeObjectOrArray(JsonValue value) {
        if (this.stack.size() == 0) {
            return;
        }
        switch (this.stack.peek()) {
            case OBJECT: {
                String k = this.keys.pop();
                JsonObject obj = this.objects.peek();
                if (obj.hasKey(k)) {
                    Log.warn((Object)this, (String)("Duplicate key '" + k + "' for object"));
                }
                obj.put(k, value);
                return;
            }
            case ARRAY: {
                this.arrays.peek().add(value);
                return;
            }
        }
    }

    public JsonBuilder value(JsonValue v) {
        this.maybeObjectOrArray(v);
        return this;
    }

    public JsonBuilder value(boolean b) {
        JsonBoolean value = new JsonBoolean(b);
        this.maybeObjectOrArray(value);
        return this;
    }

    public JsonBuilder value(BigDecimal decimal) {
        JsonNumber value = JsonNumber.value(decimal);
        this.maybeObjectOrArray(value);
        return this;
    }

    public JsonBuilder value(double d) {
        JsonNumber value = JsonNumber.value(d);
        this.maybeObjectOrArray(value);
        return this;
    }

    public JsonBuilder value(long val) {
        JsonNumber value = JsonNumber.value(val);
        this.maybeObjectOrArray(value);
        return this;
    }

    public JsonBuilder valueNull() {
        JsonNull value = JsonNull.instance;
        this.maybeObjectOrArray(value);
        return this;
    }

    public JsonBuilder value(String string) {
        JsonString value = new JsonString(string);
        this.maybeObjectOrArray(value);
        return this;
    }

    private static enum State {
        ARRAY,
        OBJECT;

    }
}

