/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.jcr.search;

import java.util.ArrayList;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import org.apache.jackrabbit.commons.webdav.QueryUtil;
import org.apache.jackrabbit.value.ValueHelper;
import org.apache.jackrabbit.webdav.jcr.ItemResourceConstants;
import org.apache.jackrabbit.webdav.property.AbstractDavProperty;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SearchResultProperty
extends AbstractDavProperty<Value[]>
implements ItemResourceConstants {
    private static Logger log = LoggerFactory.getLogger(SearchResultProperty.class);
    private static final DavPropertyName SEARCH_RESULT_PROPERTY = DavPropertyName.create((String)"search-result-property", (Namespace)ItemResourceConstants.NAMESPACE);
    private final String[] columnNames;
    private final String[] selectorNames;
    private final Value[] values;

    public SearchResultProperty(String[] columnNames, String[] selectorNames, Value[] values) {
        super(SEARCH_RESULT_PROPERTY, true);
        this.columnNames = columnNames;
        this.selectorNames = selectorNames;
        this.values = values;
    }

    public SearchResultProperty(DavProperty<?> property, ValueFactory valueFactory) throws RepositoryException {
        super(property.getName(), true);
        if (!SEARCH_RESULT_PROPERTY.equals((Object)this.getName())) {
            throw new IllegalArgumentException("SearchResultProperty may only be created from a property named " + SEARCH_RESULT_PROPERTY.toString());
        }
        ArrayList colList = new ArrayList();
        ArrayList selList = new ArrayList();
        ArrayList valList = new ArrayList();
        QueryUtil.parseResultPropertyValue((Object)property.getValue(), colList, selList, valList, (ValueFactory)valueFactory);
        this.columnNames = colList.toArray(new String[colList.size()]);
        this.selectorNames = selList.toArray(new String[selList.size()]);
        this.values = valList.toArray(new Value[valList.size()]);
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public String[] getSelectorNames() {
        return this.selectorNames;
    }

    public Value[] getValues() {
        return this.values;
    }

    public Value[] getValue() {
        return this.values;
    }

    public Element toXml(Document document) {
        Element elem = this.getName().toXml(document);
        for (int i = 0; i < this.columnNames.length; ++i) {
            String propertyName = this.columnNames[i];
            String selectorName = this.selectorNames[i];
            Value propertyValue = this.values[i];
            Element columnEl = DomUtil.addChildElement((Element)elem, (String)"column", (Namespace)ItemResourceConstants.NAMESPACE);
            DomUtil.addChildElement((Element)columnEl, (String)JCR_NAME.getName(), (Namespace)JCR_NAME.getNamespace(), (String)propertyName);
            if (propertyValue != null) {
                try {
                    String serializedValue = ValueHelper.serialize((Value)propertyValue, (boolean)true);
                    Element xmlValue = DomUtil.addChildElement((Element)columnEl, (String)"value", (Namespace)ItemResourceConstants.NAMESPACE, (String)serializedValue);
                    String type = PropertyType.nameFromValue((int)propertyValue.getType());
                    DomUtil.setAttribute((Element)xmlValue, (String)"type", (Namespace)ItemResourceConstants.NAMESPACE, (String)type);
                }
                catch (RepositoryException e) {
                    log.error(e.toString());
                }
            }
            if (selectorName == null) continue;
            DomUtil.addChildElement((Element)columnEl, (String)JCR_SELECTOR_NAME.getName(), (Namespace)JCR_SELECTOR_NAME.getNamespace(), (String)selectorName);
        }
        return elem;
    }
}

