/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authorize;

import java.security.Policy;
import javax.security.auth.Subject;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UnixUserGroupInformation;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.apache.hadoop.security.authorize.ConfiguredPolicy;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.security.authorize.Service;
import org.apache.hadoop.security.authorize.ServiceAuthorizationManager;

public class TestConfiguredPolicy
extends TestCase {
    private static final String USER1 = "drwho";
    private static final String USER2 = "joe";
    private static final String[] GROUPS1 = new String[]{"tardis"};
    private static final String[] GROUPS2 = new String[]{"users"};
    private static final String KEY_1 = "test.policy.1";
    private static final String KEY_2 = "test.policy.2";

    public void testConfiguredPolicy() throws Exception {
        Configuration conf = new Configuration();
        conf.set(KEY_1, "*");
        conf.set(KEY_2, "drwho " + GROUPS1[0]);
        ConfiguredPolicy policy = new ConfiguredPolicy(conf, (PolicyProvider)new TestPolicyProvider());
        SecurityUtil.setPolicy((Policy)policy);
        Subject user1 = SecurityUtil.getSubject((UserGroupInformation)new UnixUserGroupInformation(USER1, GROUPS1));
        ServiceAuthorizationManager.authorize((Subject)user1, Protocol1.class);
        Subject user2 = SecurityUtil.getSubject((UserGroupInformation)new UnixUserGroupInformation(USER2, GROUPS2));
        boolean failed = false;
        try {
            ServiceAuthorizationManager.authorize((Subject)user2, Protocol2.class);
        }
        catch (AuthorizationException ae) {
            failed = true;
        }
        TestConfiguredPolicy.assertTrue((boolean)failed);
    }

    private static class TestPolicyProvider
    extends PolicyProvider {
        private TestPolicyProvider() {
        }

        public Service[] getServices() {
            return new Service[]{new Service(TestConfiguredPolicy.KEY_1, Protocol1.class), new Service(TestConfiguredPolicy.KEY_2, Protocol2.class)};
        }
    }

    public static class Protocol2 {
        int j;
    }

    public static class Protocol1 {
        int i;
    }
}

