/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.util.Iterator;
import java.util.Set;
import junit.framework.TestCase;
import org.apache.hadoop.security.SecurityUtil;

public class TestAccessControlList
extends TestCase {
    public void testWildCardAccessControlList() throws Exception {
        SecurityUtil.AccessControlList acl = new SecurityUtil.AccessControlList("*");
        TestAccessControlList.assertTrue((boolean)acl.allAllowed());
        acl = new SecurityUtil.AccessControlList("  * ");
        TestAccessControlList.assertTrue((boolean)acl.allAllowed());
        acl = new SecurityUtil.AccessControlList(" *");
        TestAccessControlList.assertTrue((boolean)acl.allAllowed());
        acl = new SecurityUtil.AccessControlList("*  ");
        TestAccessControlList.assertTrue((boolean)acl.allAllowed());
    }

    public void testAccessControlList() throws Exception {
        SecurityUtil.AccessControlList acl = new SecurityUtil.AccessControlList("drwho tardis");
        Set users = acl.getUsers();
        TestAccessControlList.assertEquals((int)users.size(), (int)1);
        TestAccessControlList.assertEquals((String)((String)users.iterator().next()), (String)"drwho");
        Set groups = acl.getGroups();
        TestAccessControlList.assertEquals((int)groups.size(), (int)1);
        TestAccessControlList.assertEquals((String)((String)groups.iterator().next()), (String)"tardis");
        acl = new SecurityUtil.AccessControlList("drwho");
        users = acl.getUsers();
        TestAccessControlList.assertEquals((int)users.size(), (int)1);
        TestAccessControlList.assertEquals((String)((String)users.iterator().next()), (String)"drwho");
        groups = acl.getGroups();
        TestAccessControlList.assertEquals((int)groups.size(), (int)0);
        acl = new SecurityUtil.AccessControlList("drwho ");
        users = acl.getUsers();
        TestAccessControlList.assertEquals((int)users.size(), (int)1);
        TestAccessControlList.assertEquals((String)((String)users.iterator().next()), (String)"drwho");
        groups = acl.getGroups();
        TestAccessControlList.assertEquals((int)groups.size(), (int)0);
        acl = new SecurityUtil.AccessControlList(" tardis");
        users = acl.getUsers();
        TestAccessControlList.assertEquals((int)users.size(), (int)0);
        groups = acl.getGroups();
        TestAccessControlList.assertEquals((int)groups.size(), (int)1);
        TestAccessControlList.assertEquals((String)((String)groups.iterator().next()), (String)"tardis");
        acl = new SecurityUtil.AccessControlList("drwho,joe tardis,users");
        users = acl.getUsers();
        TestAccessControlList.assertEquals((int)users.size(), (int)2);
        Iterator iter = users.iterator();
        TestAccessControlList.assertEquals((String)((String)iter.next()), (String)"drwho");
        TestAccessControlList.assertEquals((String)((String)iter.next()), (String)"joe");
        groups = acl.getGroups();
        TestAccessControlList.assertEquals((int)groups.size(), (int)2);
        iter = groups.iterator();
        TestAccessControlList.assertEquals((String)((String)iter.next()), (String)"tardis");
        TestAccessControlList.assertEquals((String)((String)iter.next()), (String)"users");
        acl = new SecurityUtil.AccessControlList("drwho,joe tardis, users");
        users = acl.getUsers();
        TestAccessControlList.assertEquals((int)users.size(), (int)2);
        iter = users.iterator();
        TestAccessControlList.assertEquals((String)((String)iter.next()), (String)"drwho");
        TestAccessControlList.assertEquals((String)((String)iter.next()), (String)"joe");
        groups = acl.getGroups();
        TestAccessControlList.assertEquals((int)groups.size(), (int)2);
        iter = groups.iterator();
        TestAccessControlList.assertEquals((String)((String)iter.next()), (String)"tardis");
        TestAccessControlList.assertEquals((String)((String)iter.next()), (String)"users");
    }
}

