/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.file.tfile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.Random;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.io.file.tfile.Compression;
import org.apache.hadoop.io.file.tfile.TFile;

public class TestTFileByteArrays
extends TestCase {
    private static String ROOT = System.getProperty("test.build.data", "/tmp/tfile-test");
    private static final int BLOCK_SIZE = 512;
    private static final int BUF_SIZE = 64;
    private static final int K = 1024;
    protected boolean skip = false;
    private static final String KEY = "key";
    private static final String VALUE = "value";
    private FileSystem fs;
    private Configuration conf;
    private Path path;
    private FSDataOutputStream out;
    private TFile.Writer writer;
    private String compression = Compression.Algorithm.GZ.getName();
    private String comparator = "memcmp";
    private String outputFile = "TFileTestByteArrays";
    private int records1stBlock = 4480;
    private int records2ndBlock = 4263;

    public void init(String compression, String comparator, String outputFile, int numRecords1stBlock, int numRecords2ndBlock) {
        this.compression = compression;
        this.comparator = comparator;
        this.outputFile = outputFile;
        this.records1stBlock = numRecords1stBlock;
        this.records2ndBlock = numRecords2ndBlock;
    }

    public void setUp() throws IOException {
        this.conf = new Configuration();
        this.path = new Path(ROOT, this.outputFile);
        this.fs = this.path.getFileSystem(this.conf);
        this.out = this.fs.create(this.path);
        this.writer = new TFile.Writer(this.out, 512, this.compression, this.comparator, this.conf);
    }

    public void tearDown() throws IOException {
        if (!this.skip) {
            this.fs.delete(this.path, true);
        }
    }

    public void testNoDataEntry() throws IOException {
        if (this.skip) {
            return;
        }
        this.closeOutput();
        TFile.Reader reader = new TFile.Reader(this.fs.open(this.path), this.fs.getFileStatus(this.path).getLen(), this.conf);
        Assert.assertTrue((boolean)reader.isSorted());
        TFile.Reader.Scanner scanner = reader.createScanner();
        Assert.assertTrue((boolean)scanner.atEnd());
        scanner.close();
        reader.close();
    }

    public void testOneDataEntry() throws IOException {
        if (this.skip) {
            return;
        }
        this.writeRecords(1);
        this.readRecords(1);
        this.checkBlockIndex(1, 0, 0);
        this.readValueBeforeKey(1, 0);
        this.readKeyWithoutValue(1, 0);
        this.readValueWithoutKey(1, 0);
        this.readKeyManyTimes(1, 0);
    }

    public void testTwoDataEntries() throws IOException {
        if (this.skip) {
            return;
        }
        this.writeRecords(2);
        this.readRecords(2);
    }

    public void testOneBlock() throws IOException {
        if (this.skip) {
            return;
        }
        this.writeRecords(this.records1stBlock);
        this.readRecords(this.records1stBlock);
        this.checkBlockIndex(this.records1stBlock, this.records1stBlock - 1, 0);
    }

    public void testOneBlockPlusOneEntry() throws IOException {
        if (this.skip) {
            return;
        }
        this.writeRecords(this.records1stBlock + 1);
        this.readRecords(this.records1stBlock + 1);
        this.checkBlockIndex(this.records1stBlock + 1, this.records1stBlock - 1, 0);
        this.checkBlockIndex(this.records1stBlock + 1, this.records1stBlock, 1);
    }

    public void testTwoBlocks() throws IOException {
        if (this.skip) {
            return;
        }
        this.writeRecords(this.records1stBlock + 5);
        this.readRecords(this.records1stBlock + 5);
        this.checkBlockIndex(this.records1stBlock + 5, this.records1stBlock + 4, 1);
    }

    public void testThreeBlocks() throws IOException {
        if (this.skip) {
            return;
        }
        this.writeRecords(2 * this.records1stBlock + 5);
        this.readRecords(2 * this.records1stBlock + 5);
        this.checkBlockIndex(2 * this.records1stBlock + 5, 2 * this.records1stBlock + 4, 2);
        this.readValueBeforeKey(2 * this.records1stBlock + 5, 0);
        this.readKeyWithoutValue(2 * this.records1stBlock + 5, 0);
        this.readValueWithoutKey(2 * this.records1stBlock + 5, 0);
        this.readKeyManyTimes(2 * this.records1stBlock + 5, 0);
        this.readValueBeforeKey(2 * this.records1stBlock + 5, 2 * this.records1stBlock + 4);
        this.readKeyWithoutValue(2 * this.records1stBlock + 5, 2 * this.records1stBlock + 4);
        this.readValueWithoutKey(2 * this.records1stBlock + 5, 2 * this.records1stBlock + 4);
        this.readKeyManyTimes(2 * this.records1stBlock + 5, 2 * this.records1stBlock + 4);
        this.checkBlockIndex(2 * this.records1stBlock + 5, this.records1stBlock - 1, 0);
        this.checkBlockIndex(2 * this.records1stBlock + 5, this.records1stBlock, 1);
        this.readValueBeforeKey(2 * this.records1stBlock + 5, this.records1stBlock);
        this.readKeyWithoutValue(2 * this.records1stBlock + 5, this.records1stBlock);
        this.readValueWithoutKey(2 * this.records1stBlock + 5, this.records1stBlock);
        this.readKeyManyTimes(2 * this.records1stBlock + 5, this.records1stBlock);
        this.checkBlockIndex(2 * this.records1stBlock + 5, this.records1stBlock + this.records2ndBlock - 1, 1);
        this.checkBlockIndex(2 * this.records1stBlock + 5, this.records1stBlock + this.records2ndBlock, 2);
        this.readValueBeforeKey(2 * this.records1stBlock + 5, this.records1stBlock + this.records2ndBlock - 1);
        this.readKeyWithoutValue(2 * this.records1stBlock + 5, this.records1stBlock + this.records2ndBlock - 1);
        this.readValueWithoutKey(2 * this.records1stBlock + 5, this.records1stBlock + this.records2ndBlock - 1);
        this.readKeyManyTimes(2 * this.records1stBlock + 5, this.records1stBlock + this.records2ndBlock - 1);
        this.readValueBeforeKey(2 * this.records1stBlock + 5, this.records1stBlock + 10);
        this.readKeyWithoutValue(2 * this.records1stBlock + 5, this.records1stBlock + 10);
        this.readValueWithoutKey(2 * this.records1stBlock + 5, this.records1stBlock + 10);
        this.readKeyManyTimes(2 * this.records1stBlock + 5, this.records1stBlock + 10);
    }

    TFile.Reader.Location locate(TFile.Reader.Scanner scanner, byte[] key) throws IOException {
        if (scanner.seekTo(key)) {
            return scanner.currentLocation;
        }
        return scanner.endLocation;
    }

    public void testLocate() throws IOException {
        if (this.skip) {
            return;
        }
        this.writeRecords(3 * this.records1stBlock);
        TFile.Reader reader = new TFile.Reader(this.fs.open(this.path), this.fs.getFileStatus(this.path).getLen(), this.conf);
        TFile.Reader.Scanner scanner = reader.createScanner();
        TFile.Reader.Location loc2 = this.locate(scanner, TestTFileByteArrays.composeSortedKey(KEY, 3 * this.records1stBlock, 2).getBytes());
        TFile.Reader.Location locLastIn1stBlock = this.locate(scanner, TestTFileByteArrays.composeSortedKey(KEY, 3 * this.records1stBlock, this.records1stBlock - 1).getBytes());
        TFile.Reader.Location locFirstIn2ndBlock = this.locate(scanner, TestTFileByteArrays.composeSortedKey(KEY, 3 * this.records1stBlock, this.records1stBlock).getBytes());
        TFile.Reader.Location locX = this.locate(scanner, "keyX".getBytes());
        Assert.assertEquals((Object)scanner.endLocation, (Object)locX);
        scanner.close();
        reader.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFailureWriterNotClosed() throws IOException {
        if (this.skip) {
            return;
        }
        TFile.Reader reader = null;
        try {
            reader = new TFile.Reader(this.fs.open(this.path), this.fs.getFileStatus(this.path).getLen(), this.conf);
            Assert.fail((String)"Cannot read before closing the writer.");
        }
        catch (IOException iOException) {
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    public void testFailureWriteMetaBlocksWithSameName() throws IOException {
        if (this.skip) {
            return;
        }
        this.writer.append("keyX".getBytes(), "valueX".getBytes());
        DataOutputStream outMeta = this.writer.prepareMetaBlock("testX", Compression.Algorithm.GZ.getName());
        outMeta.write(123);
        outMeta.write("foo".getBytes());
        outMeta.close();
        try {
            DataOutputStream outMeta2 = this.writer.prepareMetaBlock("testX", Compression.Algorithm.GZ.getName());
            Assert.fail((String)"Cannot create metablocks with the same name.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.closeOutput();
    }

    public void testFailureGetNonExistentMetaBlock() throws IOException {
        if (this.skip) {
            return;
        }
        this.writer.append("keyX".getBytes(), "valueX".getBytes());
        DataOutputStream outMeta = this.writer.prepareMetaBlock("testX", Compression.Algorithm.GZ.getName());
        outMeta.write(123);
        outMeta.write("foo".getBytes());
        outMeta.close();
        this.closeOutput();
        TFile.Reader reader = new TFile.Reader(this.fs.open(this.path), this.fs.getFileStatus(this.path).getLen(), this.conf);
        DataInputStream mb = reader.getMetaBlock("testX");
        Assert.assertNotNull((Object)mb);
        mb.close();
        try {
            DataInputStream mbBad = reader.getMetaBlock("testY");
            Assert.assertNull((Object)mbBad);
            Assert.fail((String)"Error on handling non-existent metablocks.");
        }
        catch (Exception e) {
            // empty catch block
        }
        reader.close();
    }

    public void testFailureWriteRecordAfterMetaBlock() throws IOException {
        if (this.skip) {
            return;
        }
        this.writer.append("keyX".getBytes(), "valueX".getBytes());
        DataOutputStream outMeta = this.writer.prepareMetaBlock("testX", Compression.Algorithm.GZ.getName());
        outMeta.write(123);
        outMeta.write("dummy".getBytes());
        outMeta.close();
        try {
            this.writer.append("keyY".getBytes(), "valueY".getBytes());
            Assert.fail((String)"Cannot add key/value after start adding meta blocks.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.closeOutput();
    }

    public void testFailureReadValueManyTimes() throws IOException {
        if (this.skip) {
            return;
        }
        this.writeRecords(5);
        TFile.Reader reader = new TFile.Reader(this.fs.open(this.path), this.fs.getFileStatus(this.path).getLen(), this.conf);
        TFile.Reader.Scanner scanner = reader.createScanner();
        byte[] vbuf = new byte[64];
        int vlen = scanner.entry().getValueLength();
        scanner.entry().getValue(vbuf);
        Assert.assertEquals((String)new String(vbuf, 0, vlen), (String)"value0");
        try {
            scanner.entry().getValue(vbuf);
            Assert.fail((String)"Cannot get the value mlutiple times.");
        }
        catch (Exception e) {
            // empty catch block
        }
        scanner.close();
        reader.close();
    }

    public void testFailureBadCompressionCodec() throws IOException {
        if (this.skip) {
            return;
        }
        this.closeOutput();
        this.out = this.fs.create(this.path);
        try {
            this.writer = new TFile.Writer(this.out, 512, "BAD", this.comparator, this.conf);
            Assert.fail((String)"Error on handling invalid compression codecs.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testFailureOpenEmptyFile() throws IOException {
        if (this.skip) {
            return;
        }
        this.closeOutput();
        this.path = new Path(this.fs.getWorkingDirectory(), this.outputFile);
        this.out = this.fs.create(this.path);
        this.out.close();
        try {
            TFile.Reader reader = new TFile.Reader(this.fs.open(this.path), this.fs.getFileStatus(this.path).getLen(), this.conf);
            Assert.fail((String)"Error on handling empty files.");
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }

    public void testFailureOpenRandomFile() throws IOException {
        if (this.skip) {
            return;
        }
        this.closeOutput();
        this.path = new Path(this.fs.getWorkingDirectory(), this.outputFile);
        this.out = this.fs.create(this.path);
        Random rand = new Random();
        byte[] buf = new byte[1024];
        for (int nx = 0; nx < 1026; ++nx) {
            rand.nextBytes(buf);
            this.out.write(buf);
        }
        this.out.close();
        try {
            TFile.Reader reader = new TFile.Reader(this.fs.open(this.path), this.fs.getFileStatus(this.path).getLen(), this.conf);
            Assert.fail((String)"Error on handling random files.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void testFailureKeyLongerThan64K() throws IOException {
        if (this.skip) {
            return;
        }
        byte[] buf = new byte[65537];
        Random rand = new Random();
        rand.nextBytes(buf);
        try {
            this.writer.append(buf, "valueX".getBytes());
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.closeOutput();
    }

    public void testFailureOutOfOrderKeys() throws IOException {
        if (this.skip) {
            return;
        }
        try {
            this.writer.append("keyM".getBytes(), "valueM".getBytes());
            this.writer.append("keyA".getBytes(), "valueA".getBytes());
            Assert.fail((String)"Error on handling out of order keys.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.closeOutput();
    }

    public void testFailureNegativeOffset() throws IOException {
        if (this.skip) {
            return;
        }
        try {
            this.writer.append("keyX".getBytes(), -1, 4, "valueX".getBytes(), 0, 6);
            Assert.fail((String)"Error on handling negative offset.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.closeOutput();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFailureNegativeOffset_2() throws IOException {
        if (this.skip) {
            return;
        }
        this.closeOutput();
        TFile.Reader reader = new TFile.Reader(this.fs.open(this.path), this.fs.getFileStatus(this.path).getLen(), this.conf);
        TFile.Reader.Scanner scanner = reader.createScanner();
        try {
            scanner.lowerBound("keyX".getBytes(), -1, 4);
            Assert.fail((String)"Error on handling negative offset.");
        }
        catch (Exception exception) {
        }
        finally {
            reader.close();
            scanner.close();
        }
        this.closeOutput();
    }

    public void testFailureNegativeLength() throws IOException {
        if (this.skip) {
            return;
        }
        try {
            this.writer.append("keyX".getBytes(), 0, -1, "valueX".getBytes(), 0, 6);
            Assert.fail((String)"Error on handling negative length.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.closeOutput();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFailureNegativeLength_2() throws IOException {
        if (this.skip) {
            return;
        }
        this.closeOutput();
        TFile.Reader reader = new TFile.Reader(this.fs.open(this.path), this.fs.getFileStatus(this.path).getLen(), this.conf);
        TFile.Reader.Scanner scanner = reader.createScanner();
        try {
            scanner.lowerBound("keyX".getBytes(), 0, -1);
            Assert.fail((String)"Error on handling negative length.");
        }
        catch (Exception exception) {
        }
        finally {
            scanner.close();
            reader.close();
        }
        this.closeOutput();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFailureNegativeLength_3() throws IOException {
        if (this.skip) {
            return;
        }
        this.writeRecords(3);
        TFile.Reader reader = new TFile.Reader(this.fs.open(this.path), this.fs.getFileStatus(this.path).getLen(), this.conf);
        TFile.Reader.Scanner scanner = reader.createScanner();
        try {
            try {
                scanner.seekTo("keyY".getBytes(), -1, 4);
                Assert.fail((String)"Failed to handle negative offset.");
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                scanner.seekTo("keyY".getBytes(), 0, -2);
                Assert.fail((String)"Failed to handle negative key length.");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        finally {
            reader.close();
            scanner.close();
        }
    }

    public void testFailureCompressionNotWorking() throws IOException {
        if (this.skip) {
            return;
        }
        long rawDataSize = this.writeRecords(10 * this.records1stBlock, false);
        if (!this.compression.equalsIgnoreCase(Compression.Algorithm.NONE.getName())) {
            Assert.assertTrue((this.out.getPos() < rawDataSize ? 1 : 0) != 0);
        }
        this.closeOutput();
    }

    public void testFailureFileWriteNotAt0Position() throws IOException {
        if (this.skip) {
            return;
        }
        this.closeOutput();
        this.out = this.fs.create(this.path);
        this.out.write(123);
        try {
            this.writer = new TFile.Writer(this.out, 512, this.compression, this.comparator, this.conf);
            Assert.fail((String)"Failed to catch file write not at position 0.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.closeOutput();
    }

    private long writeRecords(int count) throws IOException {
        return this.writeRecords(count, true);
    }

    private long writeRecords(int count, boolean close) throws IOException {
        long rawDataSize = TestTFileByteArrays.writeRecords(this.writer, count);
        if (close) {
            this.closeOutput();
        }
        return rawDataSize;
    }

    static long writeRecords(TFile.Writer writer, int count) throws IOException {
        long rawDataSize = 0L;
        for (int nx = 0; nx < count; ++nx) {
            byte[] key = TestTFileByteArrays.composeSortedKey(KEY, count, nx).getBytes();
            byte[] value = (VALUE + nx).getBytes();
            writer.append(key, value);
            rawDataSize += (long)(WritableUtils.getVIntSize((long)key.length) + key.length + WritableUtils.getVIntSize((long)value.length) + value.length);
        }
        return rawDataSize;
    }

    static String composeSortedKey(String prefix, int total, int value) {
        return String.format("%s%010d", prefix, value);
    }

    private static int numberDigits(int value) {
        int digits = 0;
        while ((value /= 10) > 0) {
            ++digits;
        }
        return digits;
    }

    private void readRecords(int count) throws IOException {
        TestTFileByteArrays.readRecords(this.fs, this.path, count, this.conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void readRecords(FileSystem fs, Path path, int count, Configuration conf) throws IOException {
        TFile.Reader reader = new TFile.Reader(fs.open(path), fs.getFileStatus(path).getLen(), conf);
        TFile.Reader.Scanner scanner = reader.createScanner();
        try {
            for (int nx = 0; nx < count; ++nx) {
                Assert.assertFalse((boolean)scanner.atEnd());
                byte[] kbuf = new byte[64];
                int klen = scanner.entry().getKeyLength();
                scanner.entry().getKey(kbuf);
                Assert.assertEquals((String)new String(kbuf, 0, klen), (String)TestTFileByteArrays.composeSortedKey(KEY, count, nx));
                byte[] vbuf = new byte[64];
                int vlen = scanner.entry().getValueLength();
                scanner.entry().getValue(vbuf);
                Assert.assertEquals((String)new String(vbuf, 0, vlen), (String)(VALUE + nx));
                scanner.advance();
            }
            Assert.assertTrue((boolean)scanner.atEnd());
            Assert.assertFalse((boolean)scanner.advance());
        }
        finally {
            scanner.close();
            reader.close();
        }
    }

    private void checkBlockIndex(int count, int recordIndex, int blockIndexExpected) throws IOException {
        TFile.Reader reader = new TFile.Reader(this.fs.open(this.path), this.fs.getFileStatus(this.path).getLen(), this.conf);
        TFile.Reader.Scanner scanner = reader.createScanner();
        scanner.seekTo(TestTFileByteArrays.composeSortedKey(KEY, count, recordIndex).getBytes());
        Assert.assertEquals((int)blockIndexExpected, (int)scanner.currentLocation.getBlockIndex());
        scanner.close();
        reader.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readValueBeforeKey(int count, int recordIndex) throws IOException {
        TFile.Reader reader = new TFile.Reader(this.fs.open(this.path), this.fs.getFileStatus(this.path).getLen(), this.conf);
        TFile.Reader.Scanner scanner = reader.createScannerByKey(TestTFileByteArrays.composeSortedKey(KEY, count, recordIndex).getBytes(), null);
        try {
            byte[] vbuf = new byte[64];
            int vlen = scanner.entry().getValueLength();
            scanner.entry().getValue(vbuf);
            Assert.assertEquals((String)new String(vbuf, 0, vlen), (String)(VALUE + recordIndex));
            byte[] kbuf = new byte[64];
            int klen = scanner.entry().getKeyLength();
            scanner.entry().getKey(kbuf);
            Assert.assertEquals((String)new String(kbuf, 0, klen), (String)TestTFileByteArrays.composeSortedKey(KEY, count, recordIndex));
        }
        finally {
            scanner.close();
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readKeyWithoutValue(int count, int recordIndex) throws IOException {
        TFile.Reader reader = new TFile.Reader(this.fs.open(this.path), this.fs.getFileStatus(this.path).getLen(), this.conf);
        TFile.Reader.Scanner scanner = reader.createScannerByKey(TestTFileByteArrays.composeSortedKey(KEY, count, recordIndex).getBytes(), null);
        try {
            byte[] kbuf1 = new byte[64];
            int klen1 = scanner.entry().getKeyLength();
            scanner.entry().getKey(kbuf1);
            Assert.assertEquals((String)new String(kbuf1, 0, klen1), (String)TestTFileByteArrays.composeSortedKey(KEY, count, recordIndex));
            if (scanner.advance() && !scanner.atEnd()) {
                byte[] kbuf2 = new byte[64];
                int klen2 = scanner.entry().getKeyLength();
                scanner.entry().getKey(kbuf2);
                Assert.assertEquals((String)new String(kbuf2, 0, klen2), (String)TestTFileByteArrays.composeSortedKey(KEY, count, recordIndex + 1));
            }
        }
        finally {
            scanner.close();
            reader.close();
        }
    }

    private void readValueWithoutKey(int count, int recordIndex) throws IOException {
        TFile.Reader reader = new TFile.Reader(this.fs.open(this.path), this.fs.getFileStatus(this.path).getLen(), this.conf);
        TFile.Reader.Scanner scanner = reader.createScannerByKey(TestTFileByteArrays.composeSortedKey(KEY, count, recordIndex).getBytes(), null);
        byte[] vbuf1 = new byte[64];
        int vlen1 = scanner.entry().getValueLength();
        scanner.entry().getValue(vbuf1);
        Assert.assertEquals((String)new String(vbuf1, 0, vlen1), (String)(VALUE + recordIndex));
        if (scanner.advance() && !scanner.atEnd()) {
            byte[] vbuf2 = new byte[64];
            int vlen2 = scanner.entry().getValueLength();
            scanner.entry().getValue(vbuf2);
            Assert.assertEquals((String)new String(vbuf2, 0, vlen2), (String)(VALUE + (recordIndex + 1)));
        }
        scanner.close();
        reader.close();
    }

    private void readKeyManyTimes(int count, int recordIndex) throws IOException {
        TFile.Reader reader = new TFile.Reader(this.fs.open(this.path), this.fs.getFileStatus(this.path).getLen(), this.conf);
        TFile.Reader.Scanner scanner = reader.createScannerByKey(TestTFileByteArrays.composeSortedKey(KEY, count, recordIndex).getBytes(), null);
        byte[] kbuf1 = new byte[64];
        int klen1 = scanner.entry().getKeyLength();
        scanner.entry().getKey(kbuf1);
        Assert.assertEquals((String)new String(kbuf1, 0, klen1), (String)TestTFileByteArrays.composeSortedKey(KEY, count, recordIndex));
        klen1 = scanner.entry().getKeyLength();
        scanner.entry().getKey(kbuf1);
        Assert.assertEquals((String)new String(kbuf1, 0, klen1), (String)TestTFileByteArrays.composeSortedKey(KEY, count, recordIndex));
        klen1 = scanner.entry().getKeyLength();
        scanner.entry().getKey(kbuf1);
        Assert.assertEquals((String)new String(kbuf1, 0, klen1), (String)TestTFileByteArrays.composeSortedKey(KEY, count, recordIndex));
        scanner.close();
        reader.close();
    }

    private void closeOutput() throws IOException {
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
        }
        if (this.out != null) {
            this.out.close();
            this.out = null;
        }
    }
}

