/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.TestWritable;
import org.apache.hadoop.io.UTF8;
import org.apache.hadoop.io.Writable;

public class TestUTF8
extends TestCase {
    private static final Random RANDOM = new Random();

    public TestUTF8(String name) {
        super(name);
    }

    public static String getTestString() throws Exception {
        StringBuffer buffer = new StringBuffer();
        int length = RANDOM.nextInt(100);
        for (int i = 0; i < length; ++i) {
            buffer.append((char)RANDOM.nextInt(65535));
        }
        return buffer.toString();
    }

    public void testWritable() throws Exception {
        for (int i = 0; i < 10; ++i) {
            TestWritable.testWritable((Writable)new UTF8(TestUTF8.getTestString()));
        }
    }

    public void testGetBytes() throws Exception {
        for (int i = 0; i < 10; ++i) {
            String before = TestUTF8.getTestString();
            TestUTF8.assertEquals((String)before, (String)new String(UTF8.getBytes((String)before), "UTF-8"));
        }
    }

    public void testIO() throws Exception {
        DataOutputBuffer out = new DataOutputBuffer();
        DataInputBuffer in = new DataInputBuffer();
        for (int i = 0; i < 10; ++i) {
            String before = TestUTF8.getTestString();
            out.reset();
            UTF8.writeString((DataOutput)out, (String)before);
            in.reset(out.getData(), out.getLength());
            String after = UTF8.readString((DataInput)in);
            TestUTF8.assertTrue((boolean)before.equals(after));
            in.reset(out.getData(), out.getLength());
            String after2 = in.readUTF();
            TestUTF8.assertTrue((boolean)before.equals(after2));
            String after3 = new String(out.getData(), 2, out.getLength() - 2, "UTF-8");
            TestUTF8.assertTrue((boolean)before.equals(after3));
        }
    }
}

