/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.IOException;
import java.util.List;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.server.datanode.DataBlockScanner;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.protocol.BlockMetaDataInfo;
import org.apache.hadoop.hdfs.server.protocol.InterDatanodeProtocol;

public class TestInterDatanodeProtocol
extends TestCase {
    public static void checkMetaInfo(Block b, InterDatanodeProtocol idp, DataBlockScanner scanner) throws IOException {
        BlockMetaDataInfo metainfo = idp.getBlockMetaDataInfo(b);
        TestInterDatanodeProtocol.assertEquals((long)b.getBlockId(), (long)metainfo.getBlockId());
        TestInterDatanodeProtocol.assertEquals((long)b.getNumBytes(), (long)metainfo.getNumBytes());
        if (scanner != null) {
            TestInterDatanodeProtocol.assertEquals((long)scanner.getLastScanTime(b), (long)metainfo.getLastScanTime());
        }
    }

    public static LocatedBlock getLastLocatedBlock(ClientProtocol namenode, String src) throws IOException {
        LocatedBlocks locations = namenode.getBlockLocations(src, 0L, Long.MAX_VALUE);
        List blocks = locations.getLocatedBlocks();
        DataNode.LOG.info((Object)("blocks.size()=" + blocks.size()));
        TestInterDatanodeProtocol.assertTrue((blocks.size() > 0 ? 1 : 0) != 0);
        return (LocatedBlock)blocks.get(blocks.size() - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBlockMetaDataInfo() throws Exception {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster(conf, 3, true, null);
            cluster.waitActive();
            DistributedFileSystem dfs = (DistributedFileSystem)cluster.getFileSystem();
            String filestr = "/foo";
            Path filepath = new Path(filestr);
            DFSTestUtil.createFile((FileSystem)dfs, filepath, 1024L, (short)3, 0L);
            TestInterDatanodeProtocol.assertTrue((boolean)dfs.getClient().exists(filestr));
            LocatedBlock locatedblock = TestInterDatanodeProtocol.getLastLocatedBlock(dfs.getClient().namenode, filestr);
            DatanodeInfo[] datanodeinfo = locatedblock.getLocations();
            TestInterDatanodeProtocol.assertTrue((datanodeinfo.length > 0 ? 1 : 0) != 0);
            InterDatanodeProtocol idp = DataNode.createInterDataNodeProtocolProxy((DatanodeID)datanodeinfo[0], (Configuration)conf);
            DataNode datanode = cluster.getDataNode(datanodeinfo[0].getIpcPort());
            TestInterDatanodeProtocol.assertTrue((datanode != null ? 1 : 0) != 0);
            datanode.blockScannerThread.interrupt();
            Block b = locatedblock.getBlock();
            InterDatanodeProtocol.LOG.info((Object)("b=" + b + ", " + b.getClass()));
            TestInterDatanodeProtocol.checkMetaInfo(b, idp, datanode.blockScanner);
            Block newblock = new Block(b.getBlockId(), b.getNumBytes() / 2L, b.getGenerationStamp() + 1L);
            idp.updateBlock(b, newblock, false);
            TestInterDatanodeProtocol.checkMetaInfo(newblock, idp, datanode.blockScanner);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }
}

