/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ChecksumFileSystem;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;

public class TestSeekBug
extends TestCase {
    static final long seed = 3735928559L;
    static final int ONEMB = 0x100000;

    private void writeFile(FileSystem fileSys, Path name) throws IOException {
        FSDataOutputStream stm = fileSys.create(name);
        byte[] buffer = new byte[0x100000];
        Random rand = new Random(3735928559L);
        rand.nextBytes(buffer);
        stm.write(buffer);
        stm.close();
    }

    private void checkAndEraseData(byte[] actual, int from, byte[] expected, String message) {
        for (int idx = 0; idx < actual.length; ++idx) {
            TestSeekBug.assertEquals((String)(message + " byte " + (from + idx) + " differs. expected " + expected[from + idx] + " actual " + actual[idx]), (byte)actual[idx], (byte)expected[from + idx]);
            actual[idx] = 0;
        }
    }

    private void seekReadFile(FileSystem fileSys, Path name) throws IOException {
        FSDataInputStream stm = fileSys.open(name, 4096);
        byte[] expected = new byte[0x100000];
        Random rand = new Random(3735928559L);
        rand.nextBytes(expected);
        byte[] actual = new byte[128];
        stm.read(actual, 0, actual.length);
        actual = new byte[100000];
        stm.read(actual, 0, actual.length);
        this.checkAndEraseData(actual, 128, expected, "First Read Test");
        stm.seek(96036L);
        actual = new byte[128];
        stm.read(actual, 0, actual.length);
        this.checkAndEraseData(actual, 96036, expected, "Seek Bug");
        stm.close();
    }

    private void smallReadSeek(FileSystem fileSys, Path name) throws IOException {
        if (fileSys instanceof ChecksumFileSystem) {
            fileSys = ((ChecksumFileSystem)fileSys).getRawFileSystem();
        }
        FSDataInputStream stmRaw = fileSys.open(name, 1);
        byte[] expected = new byte[0x100000];
        Random rand = new Random(3735928559L);
        rand.nextBytes(expected);
        byte[] actual = new byte[128];
        stmRaw.seek(100000L);
        stmRaw.read(actual, 0, actual.length);
        this.checkAndEraseData(actual, 100000, expected, "First Small Read Test");
        int newpos1 = 100132;
        stmRaw.seek((long)newpos1);
        stmRaw.read(actual, 0, actual.length);
        this.checkAndEraseData(actual, newpos1, expected, "Small Seek Bug 1");
        int newpos2 = newpos1 + 256;
        stmRaw.seek((long)newpos2);
        stmRaw.read(actual, 0, actual.length);
        this.checkAndEraseData(actual, newpos2, expected, "Small Seek Bug 2");
        stmRaw.close();
    }

    private void cleanupFile(FileSystem fileSys, Path name) throws IOException {
        TestSeekBug.assertTrue((boolean)fileSys.exists(name));
        fileSys.delete(name, true);
        TestSeekBug.assertTrue((!fileSys.exists(name) ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSeekBugDFS() throws IOException {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = new MiniDFSCluster(conf, 1, true, null);
        FileSystem fileSys = cluster.getFileSystem();
        try {
            Path file1 = new Path("seektest.dat");
            this.writeFile(fileSys, file1);
            this.seekReadFile(fileSys, file1);
            this.smallReadSeek(fileSys, file1);
            this.cleanupFile(fileSys, file1);
        }
        finally {
            fileSys.close();
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSeekBugLocalFS() throws IOException {
        Configuration conf = new Configuration();
        LocalFileSystem fileSys = FileSystem.getLocal((Configuration)conf);
        try {
            Path file1 = new Path("build/test/data", "seektest.dat");
            this.writeFile((FileSystem)fileSys, file1);
            this.seekReadFile((FileSystem)fileSys, file1);
            this.cleanupFile((FileSystem)fileSys, file1);
        }
        finally {
            fileSys.close();
        }
    }
}

