/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;

public class TestLease
extends TestCase {
    final Path dir = new Path("/test/lease/");

    static boolean hasLease(MiniDFSCluster cluster, Path src) {
        return cluster.getNameNode().namesystem.leaseManager.getLeaseByPath(src.toString()) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLease() throws Exception {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = new MiniDFSCluster(conf, 2, true, null);
        try {
            FileSystem fs = cluster.getFileSystem();
            TestLease.assertTrue((boolean)fs.mkdirs(this.dir));
            Path a = new Path(this.dir, "a");
            Path b = new Path(this.dir, "b");
            FSDataOutputStream a_out = fs.create(a);
            a_out.writeBytes("something");
            TestLease.assertTrue((boolean)TestLease.hasLease(cluster, a));
            TestLease.assertTrue((!TestLease.hasLease(cluster, b) ? 1 : 0) != 0);
            FSDataOutputStream b_out = fs.create(b);
            b_out.writeBytes("something");
            TestLease.assertTrue((boolean)TestLease.hasLease(cluster, a));
            TestLease.assertTrue((boolean)TestLease.hasLease(cluster, b));
            a_out.close();
            b_out.close();
            TestLease.assertTrue((!TestLease.hasLease(cluster, a) ? 1 : 0) != 0);
            TestLease.assertTrue((!TestLease.hasLease(cluster, b) ? 1 : 0) != 0);
            fs.delete(this.dir, true);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }
}

