/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeMap;
import java.util.zip.CRC32;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.FSConstants;
import org.apache.hadoop.hdfs.server.common.HdfsConstants;

public class TestDFSUpgradeFromImage
extends TestCase {
    private static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.hdfs.TestDFSUpgradeFromImage");
    public int numDataNodes = 4;
    LinkedList<ReferenceFileInfo> refList = new LinkedList();
    Iterator<ReferenceFileInfo> refIter;
    boolean printChecksum = false;
    CRC32 overallChecksum = new CRC32();

    protected void setUp() throws IOException {
        this.unpackStorage();
    }

    public void unpackStorage() throws IOException {
        String line;
        String tarFile = System.getProperty("test.cache.data", "build/test/cache") + "/hadoop-14-dfs-dir.tgz";
        String dataDir = System.getProperty("test.build.data", "build/test/data");
        File dfsDir = new File(dataDir, "dfs");
        if (dfsDir.exists() && !FileUtil.fullyDelete((File)dfsDir)) {
            throw new IOException("Could not delete dfs directory '" + dfsDir + "'");
        }
        FileUtil.unTar((File)new File(tarFile), (File)new File(dataDir));
        BufferedReader reader = new BufferedReader(new FileReader(System.getProperty("test.cache.data", "build/test/cache") + "/hadoop-dfs-dir.txt"));
        while ((line = reader.readLine()) != null) {
            String[] arr;
            if ((line = line.trim()).length() <= 0 || line.startsWith("#") || (arr = line.split("\\s+\t\\s+")).length < 1) continue;
            if (arr[0].equals("printChecksums")) {
                this.printChecksum = true;
                break;
            }
            if (arr.length < 2) continue;
            ReferenceFileInfo info = new ReferenceFileInfo();
            info.path = arr[0];
            info.checksum = Long.parseLong(arr[1]);
            this.refList.add(info);
        }
        reader.close();
    }

    private void verifyChecksum(String path, long checksum) throws IOException {
        if (this.refIter == null) {
            this.refIter = this.refList.iterator();
        }
        if (this.printChecksum) {
            LOG.info((Object)("CRC info for reference file : " + path + " \t " + checksum));
        } else {
            if (!this.refIter.hasNext()) {
                throw new IOException("Checking checksum for " + path + "Not enough elements in the refList");
            }
            ReferenceFileInfo info = this.refIter.next();
            TestDFSUpgradeFromImage.assertEquals((String)info.path, (String)path);
            TestDFSUpgradeFromImage.assertEquals((String)("Checking checksum for " + path), (long)info.checksum, (long)checksum);
        }
    }

    private void verifyDir(DFSClient client, String dir) throws IOException {
        FileStatus[] fileArr = client.listPaths(dir);
        TreeMap<String, Boolean> fileMap = new TreeMap<String, Boolean>();
        for (FileStatus file : fileArr) {
            String path = file.getPath().toString();
            fileMap.put(path, file.isDir());
        }
        for (String path : fileMap.keySet()) {
            boolean isDir = (Boolean)fileMap.get(path);
            this.overallChecksum.update(path.getBytes());
            if (isDir) {
                this.verifyDir(client, path);
                continue;
            }
            CRC32 fileCRC = new CRC32();
            DFSClient.DFSInputStream in = client.open(path);
            byte[] buf = new byte[4096];
            int nRead = 0;
            while ((nRead = in.read(buf, 0, buf.length)) > 0) {
                fileCRC.update(buf, 0, nRead);
            }
            this.verifyChecksum(path, fileCRC.getValue());
        }
    }

    private void verifyFileSystem(DFSClient client) throws IOException {
        this.verifyDir(client, "/");
        this.verifyChecksum("overallCRC", this.overallChecksum.getValue());
        if (this.printChecksum) {
            throw new IOException("Checksums are written to log as requested. Throwing this exception to force an error for this test.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUpgradeFromImage() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            Configuration conf = new Configuration();
            if (System.getProperty("test.build.data") == null) {
                System.setProperty("test.build.data", "build/test/data");
            }
            conf.setInt("dfs.datanode.scan.period.hours", -1);
            cluster = new MiniDFSCluster(0, conf, this.numDataNodes, false, true, HdfsConstants.StartupOption.UPGRADE, null);
            cluster.waitActive();
            DFSClient dfsClient = new DFSClient(new InetSocketAddress("localhost", cluster.getNameNodePort()), conf);
            while (dfsClient.setSafeMode(FSConstants.SafeModeAction.SAFEMODE_GET)) {
                LOG.info((Object)"Waiting for SafeMode to be OFF.");
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ignored) {}
            }
            this.verifyFileSystem(dfsClient);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    private static class ReferenceFileInfo {
        String path;
        long checksum;

        private ReferenceFileInfo() {
        }
    }
}

