/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3native;

import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystemContractBaseTest;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.s3native.NativeFileSystemStore;
import org.apache.hadoop.fs.s3native.NativeS3FileSystem;

public abstract class NativeS3FileSystemContractBaseTest
extends FileSystemContractBaseTest {
    private NativeFileSystemStore store;

    abstract NativeFileSystemStore getNativeFileSystemStore() throws IOException;

    protected void setUp() throws Exception {
        Configuration conf = new Configuration();
        this.store = this.getNativeFileSystemStore();
        this.fs = new NativeS3FileSystem(this.store);
        this.fs.initialize(URI.create(conf.get("test.fs.s3n.name")), conf);
    }

    @Override
    protected void tearDown() throws Exception {
        this.store.purge("test");
        super.tearDown();
    }

    public void testListStatusForRoot() throws Exception {
        Path testDir = this.path("/test");
        NativeS3FileSystemContractBaseTest.assertTrue((boolean)this.fs.mkdirs(testDir));
        FileStatus[] paths = this.fs.listStatus(this.path("/"));
        NativeS3FileSystemContractBaseTest.assertEquals((int)1, (int)paths.length);
        NativeS3FileSystemContractBaseTest.assertEquals((Object)this.path("/test"), (Object)paths[0].getPath());
    }
}

