/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.hadoop.fs.DU;
import org.apache.hadoop.fs.FileUtil;

public class TestDU
extends TestCase {
    private static final File DU_DIR = new File(System.getProperty("test.build.data", "/tmp"), "dutmp");

    public void setUp() throws IOException {
        FileUtil.fullyDelete((File)DU_DIR);
        TestDU.assertTrue((boolean)DU_DIR.mkdirs());
    }

    public void tearDown() throws IOException {
        FileUtil.fullyDelete((File)DU_DIR);
    }

    private void createFile(File newFile, int size) throws IOException {
        Random random = new Random();
        byte[] data = new byte[size];
        random.nextBytes(data);
        newFile.createNewFile();
        RandomAccessFile file = new RandomAccessFile(newFile, "rws");
        file.write(data);
        file.getFD().sync();
        file.close();
    }

    public void testDU() throws IOException, InterruptedException {
        int writtenSize = 32768;
        File file = new File(DU_DIR, "data");
        this.createFile(file, writtenSize);
        Thread.sleep(5000L);
        DU du = new DU(file, 10000L);
        du.start();
        long duSize = du.getUsed();
        du.shutdown();
        TestDU.assertEquals((long)writtenSize, (long)duSize);
        du = new DU(file, 0L);
        du.start();
        duSize = du.getUsed();
        du.shutdown();
        TestDU.assertEquals((long)writtenSize, (long)duSize);
        du = new DU(file, 10000L);
        duSize = du.getUsed();
        TestDU.assertEquals((long)writtenSize, (long)duSize);
    }
}

