/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.FileDescriptor;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.ReadaheadPool;
import org.apache.hadoop.io.nativeio.NativeIO;
import org.jboss.netty.handler.stream.ChunkedFile;

public class FadvisedChunkedFile
extends ChunkedFile {
    private static final Log LOG = LogFactory.getLog(FadvisedChunkedFile.class);
    private final boolean manageOsCache;
    private final int readaheadLength;
    private final ReadaheadPool readaheadPool;
    private final FileDescriptor fd;
    private final String identifier;
    private ReadaheadPool.ReadaheadRequest readaheadRequest;

    public FadvisedChunkedFile(RandomAccessFile file, long position, long count, int chunkSize, boolean manageOsCache, int readaheadLength, ReadaheadPool readaheadPool, String identifier) throws IOException {
        super(file, position, count, chunkSize);
        this.manageOsCache = manageOsCache;
        this.readaheadLength = readaheadLength;
        this.readaheadPool = readaheadPool;
        this.fd = file.getFD();
        this.identifier = identifier;
    }

    public Object nextChunk() throws Exception {
        if (this.manageOsCache && this.readaheadPool != null) {
            this.readaheadRequest = this.readaheadPool.readaheadStream(this.identifier, this.fd, this.getCurrentOffset(), (long)this.readaheadLength, this.getEndOffset(), this.readaheadRequest);
        }
        return super.nextChunk();
    }

    public void close() throws Exception {
        if (this.readaheadRequest != null) {
            this.readaheadRequest.cancel();
        }
        if (this.manageOsCache && this.getEndOffset() - this.getStartOffset() > 0L) {
            try {
                NativeIO.POSIX.posixFadviseIfPossible((String)this.identifier, (FileDescriptor)this.fd, (long)this.getStartOffset(), (long)(this.getEndOffset() - this.getStartOffset()), (int)4);
            }
            catch (Throwable t) {
                LOG.warn((Object)("Failed to manage OS cache for " + this.identifier), t);
            }
        }
        super.close();
    }
}

