/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.snapshot;

import java.io.IOException;
import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.SnapshotDiffReport;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestSnapshotDiffReport {
    protected static final long seed = 0L;
    protected static final short REPLICATION = 3;
    protected static final short REPLICATION_1 = 2;
    protected static final long BLOCKSIZE = 1024L;
    public static final int SNAPSHOTNUMBER = 10;
    private final Path dir = new Path("/TestSnapshot");
    private final Path sub1 = new Path(this.dir, "sub1");
    protected Configuration conf;
    protected MiniDFSCluster cluster;
    protected DistributedFileSystem hdfs;
    private HashMap<Path, Integer> snapshotNumberMap = new HashMap();

    @Before
    public void setUp() throws Exception {
        this.conf = new Configuration();
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(3).format(true).build();
        this.cluster.waitActive();
        this.hdfs = this.cluster.getFileSystem();
    }

    @After
    public void tearDown() throws Exception {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    private String genSnapshotName(Path snapshotDir) {
        int sNum = -1;
        if (this.snapshotNumberMap.containsKey(snapshotDir)) {
            sNum = this.snapshotNumberMap.get(snapshotDir);
        }
        this.snapshotNumberMap.put(snapshotDir, ++sNum);
        return "s" + sNum;
    }

    private void modifyAndCreateSnapshot(Path modifyDir, Path[] snapshotDirs) throws Exception {
        Path file10 = new Path(modifyDir, "file10");
        Path file11 = new Path(modifyDir, "file11");
        Path file12 = new Path(modifyDir, "file12");
        Path file13 = new Path(modifyDir, "file13");
        Path file14 = new Path(modifyDir, "file14");
        Path file15 = new Path(modifyDir, "file15");
        DFSTestUtil.createFile((FileSystem)this.hdfs, file10, 1024L, (short)2, 0L);
        DFSTestUtil.createFile((FileSystem)this.hdfs, file11, 1024L, (short)2, 0L);
        DFSTestUtil.createFile((FileSystem)this.hdfs, file12, 1024L, (short)2, 0L);
        DFSTestUtil.createFile((FileSystem)this.hdfs, file13, 1024L, (short)2, 0L);
        for (Path snapshotDir : snapshotDirs) {
            this.hdfs.allowSnapshot(snapshotDir);
            this.hdfs.createSnapshot(snapshotDir, this.genSnapshotName(snapshotDir));
        }
        this.hdfs.delete(file11, true);
        this.hdfs.setReplication(file12, (short)3);
        this.hdfs.setReplication(file13, (short)3);
        DFSTestUtil.createFile((FileSystem)this.hdfs, file14, 1024L, (short)3, 0L);
        DFSTestUtil.createFile((FileSystem)this.hdfs, file15, 1024L, (short)3, 0L);
        for (Path snapshotDir : snapshotDirs) {
            this.hdfs.createSnapshot(snapshotDir, this.genSnapshotName(snapshotDir));
        }
        DFSTestUtil.createFile((FileSystem)this.hdfs, file11, 1024L, (short)3, 0L);
        this.hdfs.delete(file12, true);
        this.hdfs.setReplication(file13, (short)1);
        this.hdfs.delete(file14, true);
        this.hdfs.setReplication(file15, (short)2);
        for (Path snapshotDir : snapshotDirs) {
            this.hdfs.createSnapshot(snapshotDir, this.genSnapshotName(snapshotDir));
        }
        this.hdfs.setReplication(file10, (short)2);
    }

    private void verifyDiffReport(Path dir, String from, String to, SnapshotDiffReport.DiffReportEntry ... entries) throws IOException {
        SnapshotDiffReport report = this.hdfs.getSnapshotDiffReport(dir, from, to);
        SnapshotDiffReport inverseReport = this.hdfs.getSnapshotDiffReport(dir, to, from);
        System.out.println(report.toString());
        System.out.println(inverseReport.toString() + "\n");
        Assert.assertEquals((long)entries.length, (long)report.getDiffList().size());
        Assert.assertEquals((long)entries.length, (long)inverseReport.getDiffList().size());
        for (SnapshotDiffReport.DiffReportEntry entry : entries) {
            if (entry.getType() == SnapshotDiffReport.DiffType.MODIFY) {
                Assert.assertTrue((boolean)report.getDiffList().contains(entry));
                Assert.assertTrue((boolean)inverseReport.getDiffList().contains(entry));
                continue;
            }
            if (entry.getType() == SnapshotDiffReport.DiffType.DELETE) {
                Assert.assertTrue((boolean)report.getDiffList().contains(entry));
                Assert.assertTrue((boolean)inverseReport.getDiffList().contains(new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, entry.getRelativePath())));
                continue;
            }
            if (entry.getType() != SnapshotDiffReport.DiffType.CREATE) continue;
            Assert.assertTrue((boolean)report.getDiffList().contains(entry));
            Assert.assertTrue((boolean)inverseReport.getDiffList().contains(new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.DELETE, entry.getRelativePath())));
        }
    }

    @Test(timeout=60000L)
    public void testDiffReport() throws Exception {
        this.cluster.getNamesystem().getSnapshotManager().setAllowNestedSnapshots(true);
        Path subsub1 = new Path(this.sub1, "subsub1");
        Path subsubsub1 = new Path(subsub1, "subsubsub1");
        this.hdfs.mkdirs(subsubsub1);
        this.modifyAndCreateSnapshot(this.sub1, new Path[]{this.sub1, subsubsub1});
        this.modifyAndCreateSnapshot(subsubsub1, new Path[]{this.sub1, subsubsub1});
        try {
            this.hdfs.getSnapshotDiffReport(subsub1, "s1", "s2");
            Assert.fail((String)("Expect exception when getting snapshot diff report: " + subsub1 + " is not a snapshottable directory."));
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains((String)("Directory is not a snapshottable directory: " + subsub1), (Throwable)e);
        }
        String invalidName = "invalid";
        try {
            this.hdfs.getSnapshotDiffReport(this.sub1, "invalid", "invalid");
            Assert.fail((String)"Expect exception when providing invalid snapshot name for diff report");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains((String)("Cannot find the snapshot of directory " + this.sub1 + " with name " + "invalid"), (Throwable)e);
        }
        SnapshotDiffReport report = this.hdfs.getSnapshotDiffReport(this.sub1, "s0", "s0");
        System.out.println(report);
        Assert.assertEquals((long)0L, (long)report.getDiffList().size());
        report = this.hdfs.getSnapshotDiffReport(this.sub1, "", "");
        System.out.println(report);
        Assert.assertEquals((long)0L, (long)report.getDiffList().size());
        report = this.hdfs.getSnapshotDiffReport(subsubsub1, "s0", "s2");
        System.out.println(report);
        Assert.assertEquals((long)0L, (long)report.getDiffList().size());
        report = this.hdfs.getSnapshotDiffReport(this.hdfs.makeQualified(subsubsub1), "s0", "s2");
        System.out.println(report);
        Assert.assertEquals((long)0L, (long)report.getDiffList().size());
        this.verifyDiffReport(this.sub1, "s0", "s2", new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"file15")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.DELETE, DFSUtil.string2Bytes((String)"file12")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.DELETE, DFSUtil.string2Bytes((String)"file11")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"file11")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"file13")));
        this.verifyDiffReport(this.sub1, "s0", "s5", new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"file15")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.DELETE, DFSUtil.string2Bytes((String)"file12")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"file10")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.DELETE, DFSUtil.string2Bytes((String)"file11")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"file11")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"file13")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"subsub1/subsubsub1")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"subsub1/subsubsub1/file10")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"subsub1/subsubsub1/file11")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"subsub1/subsubsub1/file13")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"subsub1/subsubsub1/file15")));
        this.verifyDiffReport(this.sub1, "s2", "s5", new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"file10")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"subsub1/subsubsub1")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"subsub1/subsubsub1/file10")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"subsub1/subsubsub1/file11")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"subsub1/subsubsub1/file13")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"subsub1/subsubsub1/file15")));
        this.verifyDiffReport(this.sub1, "s3", "", new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"subsub1/subsubsub1")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"subsub1/subsubsub1/file15")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.DELETE, DFSUtil.string2Bytes((String)"subsub1/subsubsub1/file12")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"subsub1/subsubsub1/file10")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.DELETE, DFSUtil.string2Bytes((String)"subsub1/subsubsub1/file11")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"subsub1/subsubsub1/file11")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"subsub1/subsubsub1/file13")));
    }

    @Test(timeout=60000L)
    public void testDiffReport2() throws Exception {
        Path subsub1 = new Path(this.sub1, "subsub1");
        Path subsubsub1 = new Path(subsub1, "subsubsub1");
        this.hdfs.mkdirs(subsubsub1);
        this.modifyAndCreateSnapshot(subsubsub1, new Path[]{this.sub1});
        this.hdfs.delete(subsub1, true);
        this.verifyDiffReport(this.sub1, "s0", "s2", new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"subsub1/subsubsub1")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"subsub1/subsubsub1/file15")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.DELETE, DFSUtil.string2Bytes((String)"subsub1/subsubsub1/file12")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.DELETE, DFSUtil.string2Bytes((String)"subsub1/subsubsub1/file11")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"subsub1/subsubsub1/file11")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"subsub1/subsubsub1/file13")));
        this.verifyDiffReport(this.sub1, "s0", "", new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.DELETE, DFSUtil.string2Bytes((String)"subsub1")));
    }
}

